/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.formatting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.xml.XMLPairFinder;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editor.xml.formatting.XMLUtils;
import com.aptana.ide.editor.xml.parsing.XMLParseState;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IPreferenceClient;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class XMLPairTagModifyStrategy
implements IAutoEditStrategy,
IPreferenceClient {
    protected SourceViewerConfiguration configuration;
    protected ISourceViewer sourceViewer;
    protected EditorFileContext context;

    public XMLPairTagModifyStrategy(EditorFileContext context, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        this.context = context;
        this.configuration = configuration;
        this.sourceViewer = sourceViewer;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        IPreferenceStore store = XMLPlugin.getDefault().getPreferenceStore();
        IParseState parseState = this.context.getParseState();
        XMLParseState xmlParseState = (XMLParseState)parseState.getParseState("text/xml");
        this.modifyPairTag(document, command, (IParseState)xmlParseState, store);
    }

    public IPreferenceStore getPreferenceStore() {
        return XMLPlugin.getDefault().getPreferenceStore();
    }

    private void modifyPairTag(IDocument document, DocumentCommand command, IParseState parseState, IPreferenceStore store) {
        XMLPairFinder finder;
        PairMatch match;
        if (store == null || !store.getBoolean("com.aptana.ide.editor.html.AUTO_MODIFY_PAIR_TAG")) {
            return;
        }
        Lexeme cursorLexeme = this.getTagLexeme(parseState, command.offset);
        if (cursorLexeme != null && (match = (finder = new XMLPairFinder()).findPairMatch(command.offset, parseState, cursorLexeme, 2)) != null) {
            Lexeme pairLexeme = match.endStart > command.offset ? this.getTagLexeme(parseState, match.endStart) : this.getTagLexeme(parseState, match.beginStart);
            if (pairLexeme == null) {
                return;
            }
            if (!this.checkMatch(cursorLexeme, pairLexeme)) {
                return;
            }
            if (this.checkFullDelete(command, parseState.getLexemeList(), cursorLexeme, pairLexeme)) {
                return;
            }
            if (this.destroysTag(cursorLexeme, parseState.getLexemeList(), command.offset, command.length)) {
                return;
            }
            int replaceLength = this.filterReplaceLength(command, cursorLexeme);
            if (replaceLength == -1) {
                return;
            }
            String replaceText = this.filterReplaceText(command.text);
            if (replaceLength == 0 && replaceText.length() == 0) {
                return;
            }
            try {
                int caretPosition;
                command.caretOffset = caretPosition = command.offset + command.length;
                command.shiftsCaret = true;
                int offsetDif = command.offset - cursorLexeme.offset;
                if (match.endStart > command.offset) {
                    command.addCommand(match.endStart + offsetDif + 1, replaceLength, replaceText, command.owner);
                } else {
                    command.addCommand(match.beginStart + offsetDif - 1, replaceLength, replaceText, command.owner);
                }
                command.doit = false;
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private boolean checkFullDelete(DocumentCommand command, LexemeList lexemes, Lexeme cursorLexeme, Lexeme pairLexeme) {
        Lexeme cursorEndingLexeme = this.getTagEndingLexeme(cursorLexeme, lexemes);
        Lexeme pairEndingLexeme = this.getTagEndingLexeme(pairLexeme, lexemes);
        if (cursorEndingLexeme == null || pairEndingLexeme == null) {
            return false;
        }
        if (cursorLexeme.getStartingOffset() == command.offset && cursorEndingLexeme.getEndingOffset() == command.offset + command.length) {
            try {
                int caretPosition;
                command.caretOffset = caretPosition = command.offset + command.length;
                command.shiftsCaret = true;
                command.addCommand(pairLexeme.getStartingOffset(), pairEndingLexeme.getEndingOffset() - pairLexeme.getStartingOffset(), "", null);
                command.doit = false;
                return true;
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)"Unexpected exception while checking for complete tag removal", (Throwable)e);
            }
        }
        return false;
    }

    private boolean destroysTag(Lexeme startLexeme, LexemeList lexemes, int offset, int length) {
        Lexeme closing = this.getTagEndingLexeme(startLexeme, lexemes);
        if (closing == null) {
            return false;
        }
        return offset + length > closing.getStartingOffset();
    }

    private Lexeme getTagEndingLexeme(Lexeme startLexeme, LexemeList lexemes) {
        int startIndex = lexemes.getLexemeIndex(startLexeme);
        if (startLexeme.typeIndex != 40 && startLexeme.typeIndex != 27 || startIndex < 0) {
            throw new IllegalArgumentException("Wrong start lexeme");
        }
        Lexeme closing = XMLUtils.getFirstLexemeBreaking(lexemes, startIndex + 1, new int[]{30}, new int[]{40, 27, 40});
        return closing;
    }

    private boolean checkMatch(Lexeme firstLexeme, Lexeme secondLexeme) {
        int firstTagStart = this.getTagNameStartOffset(firstLexeme);
        if (firstTagStart == -1) {
            return false;
        }
        int secondTagStart = this.getTagNameStartOffset(secondLexeme);
        if (secondTagStart == -1) {
            return false;
        }
        String firstName = firstLexeme.getText().substring(firstTagStart - firstLexeme.getStartingOffset());
        String secondName = secondLexeme.getText().substring(secondTagStart - secondLexeme.getStartingOffset());
        return firstName.equalsIgnoreCase(secondName);
    }

    private int filterReplaceLength(DocumentCommand originalCommand, Lexeme tagLexeme) {
        int tagNameStartOffset = this.getTagNameStartOffset(tagLexeme);
        if (originalCommand.offset < tagNameStartOffset) {
            return -1;
        }
        if (originalCommand.offset > tagLexeme.getEndingOffset()) {
            return -1;
        }
        int maxLength = tagLexeme.getEndingOffset() - originalCommand.offset;
        int resultLength = Math.min(originalCommand.length, maxLength);
        return resultLength;
    }

    private String filterReplaceText(String originalText) {
        int pos = 0;
        while (pos < originalText.length()) {
            char ch = originalText.charAt(pos);
            if (!Character.isLetterOrDigit((int)ch)) break;
            ++pos;
        }
        return originalText.substring(0, pos);
    }

    private int getTagNameStartOffset(Lexeme tagLexeme) {
        if (tagLexeme.typeIndex == 40) {
            return tagLexeme.getStartingOffset() + 1;
        }
        if (tagLexeme.typeIndex == 27) {
            return tagLexeme.getStartingOffset() + 2;
        }
        throw new IllegalArgumentException("Tag starting lexeme is excpected");
    }

    private Lexeme getTagLexeme(IParseState state, int offset) {
        LexemeList lexemeList = state.getLexemeList();
        Lexeme currentLexeme = lexemeList.getFloorLexeme(offset);
        if (currentLexeme != null && (currentLexeme.typeIndex == 40 || currentLexeme.typeIndex == 27)) {
            return currentLexeme;
        }
        currentLexeme = lexemeList.getCeilingLexeme(offset);
        if (currentLexeme == null) {
            return null;
        }
        if (currentLexeme.typeIndex == 40 || currentLexeme.typeIndex == 27) {
            return currentLexeme;
        }
        int currentLexemeIndex = lexemeList.getLexemeIndex(currentLexeme);
        if (currentLexemeIndex <= 0) {
            return null;
        }
        Lexeme previousLexeme = lexemeList.get(currentLexemeIndex - 1);
        if ((previousLexeme.typeIndex == 40 || previousLexeme.typeIndex == 27) && currentLexeme.typeIndex == 30) {
            return previousLexeme;
        }
        return null;
    }
}

