/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.parsing;

import com.aptana.ide.editor.xml.parsing.XMLParseState;
import com.aptana.ide.editors.unified.parsing.UnifiedParser;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.text.ParseException;

public class XMLParserBase
extends UnifiedParser {
    private static final String TEXT_GROUP = "text";
    private static final String ERROR_GROUP = "error";
    protected static final String DEFAULT_GROUP = "default";
    protected static final String XML_DECLARATION_GROUP = "xml-declaration";
    protected static final String CDATA_SECTION_GROUP = "cdata-section";
    protected static final String PROCESSING_INSTRUCTION_GROUP = "processing-instruction";
    public static final String DOCTYPE_DECLARATION_GROUP = "doctype-declaration";
    protected IParseNode _currentElement;

    public XMLParserBase() throws ParserInitializationException {
        this("text/xml");
    }

    public XMLParserBase(String language) throws ParserInitializationException {
        super(language);
    }

    protected void advance() throws LexerException {
        ILexer lexer = this.getLexer();
        Lexeme currentLexeme = EOS;
        if (this._currentElement != null && this.currentLexeme != null && this.currentLexeme != EOS) {
            this._currentElement.includeLexemeInRange(this.currentLexeme);
        }
        if (!lexer.isEOS()) {
            boolean inWhitespace = true;
            while (inWhitespace) {
                if (lexer.isEOS()) continue;
                currentLexeme = lexer.getNextLexeme();
                if (currentLexeme == null && !lexer.isEOS()) {
                    lexer.setGroup(ERROR_GROUP);
                    currentLexeme = lexer.getNextLexeme();
                }
                if (currentLexeme != null && currentLexeme.typeIndex == 3) {
                    lexer.setCurrentOffset(currentLexeme.offset);
                    lexer.setGroup("unclosed-comment");
                    currentLexeme = lexer.getNextLexeme();
                }
                if (currentLexeme == null) {
                    currentLexeme = EOS;
                    inWhitespace = false;
                    continue;
                }
                this.addLexeme(currentLexeme);
                inWhitespace = false;
            }
        }
        this.currentLexeme = currentLexeme;
    }

    public IParseState createParseState(IParseState parent) {
        XMLParseState result = parent == null ? new XMLParseState() : new XMLParseState(parent);
        return result;
    }

    public void initializeLexer() throws LexerException {
        ILexer lexer = this.getLexer();
        String language = this.getLanguage();
        lexer.setIgnoreSet(language, new int[]{1});
        lexer.setLanguageAndGroup(language, DEFAULT_GROUP);
    }

    protected void parseDocTypeDeclaration() throws LexerException {
        ILexer lexer = this.getLexer();
        int initialOffset = lexer.getEOFOffset();
        try {
            Range range = lexer.find("doctype-declaration-delimiter");
            int offset = range.getEndingOffset();
            if (range.isEmpty()) {
                offset = lexer.getSourceLength();
            }
            lexer.setEOFOffset(offset);
            lexer.setGroup(DOCTYPE_DECLARATION_GROUP);
            this.advance();
            while (!this.isEOS()) {
                this.advance();
            }
        }
        finally {
            lexer.setEOFOffset(initialOffset);
            lexer.setGroup(DEFAULT_GROUP);
            this.advance();
        }
    }

    protected void parseText(boolean verify) throws LexerException, ParseException {
        ILexer lexer = this.getLexer();
        lexer.setGroup(TEXT_GROUP);
        if (verify) {
            this.assertAndAdvance(30, "error.tag.end.close");
        } else {
            this.advance();
        }
        lexer.setGroup(DEFAULT_GROUP);
        if (this.currentLexeme == EOS || this.isType(0)) {
            if (this.currentLexeme != EOS) {
                lexer.setCurrentOffset(this.currentLexeme.offset);
                this.removeLexeme(this.currentLexeme);
            }
            this.advance();
        }
    }
}

