/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.IInvocationContext;
import com.aptana.internal.ui.text.spelling.JavaPluginImages;
import com.aptana.internal.ui.text.spelling.JavaUIMessages;
import com.aptana.internal.ui.text.spelling.PreferenceConstants;
import com.aptana.internal.ui.text.spelling.SpellCheckEngine;
import com.aptana.internal.ui.text.spelling.SpellingProblemUtils;
import com.aptana.internal.ui.text.spelling.engine.ISpellCheckEngine;
import com.aptana.internal.ui.text.spelling.engine.ISpellChecker;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class AddWordProposal
implements ICompletionProposal {
    private static final String PREF_KEY_DO_NOT_ASK = "do_not_ask_to_install_user_dictionary";
    private final String fWord;
    private final IQuickAssistInvocationContext context;

    public AddWordProposal(String word, IInvocationContext context) {
        this.fWord = word;
        this.context = (IQuickAssistInvocationContext)context;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker == null) {
            return;
        }
        IQuickAssistInvocationContext quickAssistContext = null;
        if (this.context instanceof IQuickAssistInvocationContext) {
            quickAssistContext = this.context;
        }
        if (!checker.acceptsWords()) {
            Shell shell = quickAssistContext != null && quickAssistContext.getSourceViewer() != null ? quickAssistContext.getSourceViewer().getTextWidget().getShell() : Display.getCurrent().getActiveShell();
            if (!AddWordProposal.canAskToConfigure() || !this.askUserToConfigureUserDictionary(shell)) {
                return;
            }
            String[] preferencePageIds = new String[]{"org.eclipse.ui.editors.preferencePages.Spelling"};
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePageIds[0], (String[])preferencePageIds, null).open();
        }
        if (checker.acceptsWords()) {
            checker.addWord(this.fWord);
            if (quickAssistContext != null && quickAssistContext.getSourceViewer() != null) {
                SpellingProblemUtils.removeAll(quickAssistContext.getSourceViewer(), this.fWord);
            }
        }
    }

    private boolean askUserToConfigureUserDictionary(Shell shell) {
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)JavaUIMessages.Spelling_add_askToConfigure_title, (String)JavaUIMessages.Spelling_add_askToConfigure_question, (String)JavaUIMessages.Spelling_add_askToConfigure_ignoreMessage, (boolean)false, null, null);
        PreferenceConstants.getPreferenceStore().setValue(PREF_KEY_DO_NOT_ASK, toggleDialog.getToggleState());
        return toggleDialog.getReturnCode() == 2;
    }

    static boolean canAskToConfigure() {
        return !PreferenceConstants.getPreferenceStore().getBoolean(PREF_KEY_DO_NOT_ASK);
    }

    public String getAdditionalProposalInfo() {
        return MessageFormat.format(JavaUIMessages.Spelling_add_info, this.fWord);
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return MessageFormat.format(JavaUIMessages.Spelling_add_label, this.fWord);
    }

    public Image getImage() {
        return JavaPluginImages.get("add");
    }

    public int getRelevance() {
        return Integer.MIN_VALUE;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.context.getOffset(), this.context.getLength());
    }
}

