/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.IStatusChangeListener;
import com.aptana.internal.ui.text.spelling.OptionsConfigurationBlock;
import com.aptana.internal.ui.text.spelling.PixelConverter;
import com.aptana.internal.ui.text.spelling.PreferencesMessages;
import com.aptana.internal.ui.text.spelling.SWTUtil;
import com.aptana.internal.ui.text.spelling.SpellCheckEngine;
import com.aptana.internal.ui.text.spelling.StatusInfo;
import com.aptana.internal.ui.text.spelling.StatusUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SpellingConfigurationBlock
extends OptionsConfigurationBlock {
    private static final boolean SUPPORT_CONTENT_ASSIST_PROPOSALS = false;
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_DIGITS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_digits");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_MIXED = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_mixed");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_SENTENCE = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_sentence");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_UPPER = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_upper");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_SINGLE_LETTERS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_single_letters");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_NON_LETTERS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_non_letters");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_URLS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_urls");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_LOCALE = SpellingConfigurationBlock.getJDTUIKey("spelling_locale");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_PROPOSAL_THRESHOLD = SpellingConfigurationBlock.getJDTUIKey("spelling_proposal_treshold");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_PROBLEMS_THRESHOLD = SpellingConfigurationBlock.getJDTUIKey("spelling_problems_threshold");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_USER_DICTIONARY = SpellingConfigurationBlock.getJDTUIKey("spelling_user_dictionary");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_USER_DICTIONARY_ENCODING = SpellingConfigurationBlock.getJDTUIKey("spelling_user_dictionary_encoding");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_ENABLE_CONTENTASSIST = SpellingConfigurationBlock.getJDTUIKey("spelling_enable_content_assist");
    private static final String PREF_VALUE_NO_LOCALE = "";
    private Text fDictionaryPath = null;
    private IStatus fFileStatus = new StatusInfo();
    private IStatus fThresholdStatus = new StatusInfo();
    private IStatus fEncodingFieldEditorStatus = new StatusInfo();
    private Composite fEncodingEditorParent;
    private Control[] fAllControls;
    private Control[] fEnabledControls;

    protected static void createSelectionDependency(final Button master, final Control slave) {
        master.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                slave.setEnabled(master.getSelection());
            }
        });
        slave.setEnabled(master.getSelection());
    }

    protected static String[] getDictionaryCodes(Set locales) {
        int index = 0;
        Locale locale2 = null;
        String[] codes = new String[locales.size() + 1];
        for (Locale locale2 : locales) {
            codes[index++] = locale2.toString();
        }
        codes[index++] = PREF_VALUE_NO_LOCALE;
        return codes;
    }

    protected static String[] getDictionaryLabels(Set locales) {
        int index = 0;
        Locale locale2 = null;
        String[] labels = new String[locales.size() + 1];
        for (Locale locale2 : locales) {
            labels[index++] = locale2.getDisplayName();
        }
        labels[index++] = PreferencesMessages.SpellingPreferencePage_dictionary_none;
        return labels;
    }

    protected static IStatus validateAbsoluteFilePath(String path) {
        if (path == null) {
            path = PREF_VALUE_NO_LOCALE;
        }
        StatusInfo status = new StatusInfo();
        if (path.length() > 0) {
            File file = new File(path);
            if (!(file.exists() || file.isAbsolute() && file.getParentFile().canWrite())) {
                status.setError(PreferencesMessages.SpellingPreferencePage_dictionary_error);
            } else if (!(!file.exists() || file.isFile() && file.isAbsolute() && file.canRead() && file.canWrite())) {
                status.setError(PreferencesMessages.SpellingPreferencePage_dictionary_error);
            }
        }
        return status;
    }

    private static IStatus validateLocale(String localeString) {
        if (PREF_VALUE_NO_LOCALE.equals(localeString)) {
            return new StatusInfo();
        }
        Locale locale = SpellCheckEngine.convertToLocale(localeString);
        if (SpellCheckEngine.findClosestLocale(locale) != null) {
            return new StatusInfo();
        }
        return new StatusInfo(4, PreferencesMessages.SpellingPreferencePage_locale_error);
    }

    protected static IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.SpellingPreferencePage_empty_threshold);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(MessageFormat.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(MessageFormat.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
            }
        }
        return status;
    }

    public SpellingConfigurationBlock(IStatusChangeListener context, IWorkbenchPreferenceContainer container) {
        super(context, SpellingConfigurationBlock.getAllKeys(), container);
        IStatus status = SpellingConfigurationBlock.validateAbsoluteFilePath(this.getValue(PREF_SPELLING_USER_DICTIONARY));
        if (status.getSeverity() != 0) {
            this.setValue(PREF_SPELLING_USER_DICTIONARY, PREF_VALUE_NO_LOCALE);
        }
        if ((status = SpellingConfigurationBlock.validateLocale(this.getValue(PREF_SPELLING_LOCALE))).getSeverity() != 0) {
            this.setValue(PREF_SPELLING_LOCALE, SpellCheckEngine.getDefaultLocale().toString());
        }
    }

    protected Combo addComboBox(Composite parent, String label, OptionsConfigurationBlock.Key key, String[] values, String[] valueLabels, int indent) {
        OptionsConfigurationBlock.ControlData data = new OptionsConfigurationBlock.ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        comboBox.setLayoutData((Object)gd);
        comboBox.addSelectionListener(this.getSelectionListener());
        this.fLabels.put(comboBox, labelControl);
        String currValue = this.getValue(key);
        Locale locale = SpellCheckEngine.convertToLocale(currValue);
        locale = SpellCheckEngine.findClosestLocale(locale);
        if (locale != null) {
            currValue = locale.toString();
        }
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        ArrayList<Object> allControls = new ArrayList<Object>();
        PixelConverter converter = new PixelConverter((Control)parent);
        String[] trueFalse = new String[]{"true", "false"};
        Group user = new Group(composite, 0);
        user.setText(PreferencesMessages.SpellingPreferencePage_group_user);
        user.setLayout((Layout)new GridLayout());
        user.setLayoutData((Object)new GridData(768));
        allControls.add(user);
        String label = PreferencesMessages.SpellingPreferencePage_ignore_digits_label;
        Button slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_DIGITS, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_mixed_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_MIXED, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_sentence_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_SENTENCE, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_upper_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_UPPER, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_url_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_URLS, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_non_letters_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_NON_LETTERS, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_single_letters_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_SINGLE_LETTERS, trueFalse, 0);
        allControls.add(slave);
        Set locales = SpellCheckEngine.getLocalesWithInstalledDictionaries();
        boolean hasPlaformDictionaries = locales.size() > 0;
        Group engine = new Group(composite, 0);
        if (hasPlaformDictionaries) {
            engine.setText(PreferencesMessages.SpellingPreferencePage_group_dictionaries);
        } else {
            engine.setText(PreferencesMessages.SpellingPreferencePage_group_dictionary);
        }
        engine.setLayout((Layout)new GridLayout(4, false));
        engine.setLayoutData((Object)new GridData(768));
        allControls.add(engine);
        if (hasPlaformDictionaries) {
            label = PreferencesMessages.SpellingPreferencePage_dictionary_label;
            Combo combo = this.addComboBox((Composite)engine, label, PREF_SPELLING_LOCALE, SpellingConfigurationBlock.getDictionaryCodes(locales), SpellingConfigurationBlock.getDictionaryLabels(locales), 0);
            combo.setEnabled(locales.size() > 0);
            allControls.add(combo);
            allControls.add(this.fLabels.get(combo));
            new Label((Composite)engine, 0);
        }
        label = PreferencesMessages.SpellingPreferencePage_workspace_dictionary_label;
        this.fDictionaryPath = this.addTextField((Composite)engine, label, PREF_SPELLING_USER_DICTIONARY, 0, 0);
        GridData gd = (GridData)this.fDictionaryPath.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = converter.convertWidthInCharsToPixels(40);
        allControls.add(this.fDictionaryPath);
        allControls.add(this.fLabels.get(this.fDictionaryPath));
        Composite buttons = new Composite((Composite)engine, 0);
        buttons.setLayout((Layout)new GridLayout(2, true));
        buttons.setLayoutData((Object)new GridData(128));
        Button button = new Button(buttons, 8);
        button.setText(PreferencesMessages.SpellingPreferencePage_browse_label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SpellingConfigurationBlock.this.handleBrowseButtonSelected();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button.setLayoutData((Object)new GridData(256));
        allControls.add(button);
        new Label((Composite)engine, 0);
        Label description = new Label((Composite)engine, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        description.setLayoutData((Object)gd);
        description.setText(PreferencesMessages.SpellingPreferencePage_user_dictionary_description);
        allControls.add(description);
        this.createEncodingFieldEditor((Composite)engine, allControls);
        Group advanced = new Group(composite, 0);
        advanced.setText(PreferencesMessages.SpellingPreferencePage_group_advanced);
        advanced.setLayout((Layout)new GridLayout(3, false));
        advanced.setLayoutData((Object)new GridData(768));
        allControls.add(advanced);
        label = PreferencesMessages.SpellingPreferencePage_problems_threshold;
        int digits = 4;
        Text text = this.addTextField((Composite)advanced, label, PREF_SPELLING_PROBLEMS_THRESHOLD, 0, converter.convertWidthInCharsToPixels(digits + 1));
        text.setTextLimit(digits);
        allControls.add(text);
        allControls.add(this.fLabels.get(text));
        label = PreferencesMessages.SpellingPreferencePage_proposals_threshold;
        digits = 3;
        text = this.addTextField((Composite)advanced, label, PREF_SPELLING_PROPOSAL_THRESHOLD, 0, converter.convertWidthInCharsToPixels(digits + 1));
        text.setTextLimit(digits);
        gd = new GridData(32);
        allControls.add(text);
        allControls.add(this.fLabels.get(text));
        this.fAllControls = allControls.toArray(new Control[allControls.size()]);
        return composite;
    }

    private void createEncodingFieldEditor(Composite composite, List allControls) {
        Label filler = new Label(composite, 0);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 4;
        filler.setLayoutData((Object)gd);
        PreferenceStore store = new PreferenceStore();
        store.setDefault(PREF_SPELLING_USER_DICTIONARY_ENCODING.getName(), Charset.defaultCharset().name());
        String encoding = this.getValue(PREF_SPELLING_USER_DICTIONARY_ENCODING);
        if (encoding != null && encoding.length() > 0) {
            store.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING.getName(), encoding);
        }
        new DialogPage(){

            public void createControl(Composite c) {
            }

            public void setErrorMessage(String newMessage) {
                StatusInfo status = new StatusInfo();
                if (newMessage != null) {
                    status.setError(newMessage);
                }
                SpellingConfigurationBlock.this.fEncodingFieldEditorStatus = status;
                SpellingConfigurationBlock.this.fContext.statusChanged(StatusUtil.getMostSevere(new IStatus[]{SpellingConfigurationBlock.this.fThresholdStatus, SpellingConfigurationBlock.this.fFileStatus, SpellingConfigurationBlock.this.fEncodingFieldEditorStatus}));
            }
        };
    }

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_SPELLING_USER_DICTIONARY, PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_SPELLING_IGNORE_DIGITS, PREF_SPELLING_IGNORE_MIXED, PREF_SPELLING_IGNORE_SENTENCE, PREF_SPELLING_IGNORE_UPPER, PREF_SPELLING_IGNORE_URLS, PREF_SPELLING_IGNORE_NON_LETTERS, PREF_SPELLING_IGNORE_SINGLE_LETTERS, PREF_SPELLING_LOCALE, PREF_SPELLING_PROPOSAL_THRESHOLD, PREF_SPELLING_PROBLEMS_THRESHOLD};
    }

    protected final String[] getFullBuildDialogStrings(boolean workspace) {
        return null;
    }

    public boolean performOk() {
        this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_VALUE_NO_LOCALE);
        return super.performOk();
    }

    public boolean performApply() {
        this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_VALUE_NO_LOCALE);
        return super.performApply();
    }

    public void performDefaults() {
        super.performDefaults();
        this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_VALUE_NO_LOCALE);
    }

    protected void handleBrowseButtonSelected() {
        FileDialog dialog = new FileDialog(this.fDictionaryPath.getShell(), 4096);
        dialog.setText(PreferencesMessages.SpellingPreferencePage_filedialog_title);
        dialog.setFilterPath(this.fDictionaryPath.getText());
        String path = dialog.open();
        if (path != null) {
            this.fDictionaryPath.setText(path);
        }
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String oldValue, String newValue) {
        this.fThresholdStatus = key == null || PREF_SPELLING_PROPOSAL_THRESHOLD.equals(key) ? SpellingConfigurationBlock.validatePositiveNumber(this.getValue(PREF_SPELLING_PROPOSAL_THRESHOLD)) : new StatusInfo();
        if (key == null || PREF_SPELLING_PROBLEMS_THRESHOLD.equals(key)) {
            IStatus status = SpellingConfigurationBlock.validatePositiveNumber(this.getValue(PREF_SPELLING_PROBLEMS_THRESHOLD));
            this.fThresholdStatus = StatusUtil.getMostSevere(new IStatus[]{this.fThresholdStatus, status});
        }
        if (key == null || PREF_SPELLING_USER_DICTIONARY.equals(key)) {
            this.fFileStatus = SpellingConfigurationBlock.validateAbsoluteFilePath(this.getValue(PREF_SPELLING_USER_DICTIONARY));
        }
        this.fContext.statusChanged(StatusUtil.getMostSevere(new IStatus[]{this.fThresholdStatus, this.fFileStatus, this.fEncodingFieldEditorStatus}));
    }

    protected void updateCheckBox(Button curr) {
        super.updateCheckBox(curr);
        Event event = new Event();
        event.type = 13;
        event.display = curr.getDisplay();
        event.widget = curr;
        curr.notifyListeners(13, event);
    }

    protected void setEnabled(boolean enabled) {
        if (enabled && this.fEnabledControls != null) {
            int i = this.fEnabledControls.length - 1;
            while (i >= 0) {
                this.fEnabledControls[i].setEnabled(true);
                --i;
            }
            this.fEnabledControls = null;
        }
        if (!enabled && this.fEnabledControls == null) {
            ArrayList<Control> enabledControls = new ArrayList<Control>();
            int i = this.fAllControls.length - 1;
            while (i >= 0) {
                Control control = this.fAllControls[i];
                if (control.isEnabled()) {
                    enabledControls.add(control);
                    control.setEnabled(false);
                }
                --i;
            }
            this.fEnabledControls = enabledControls.toArray(new Control[enabledControls.size()]);
        }
    }
}

