/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.JavaSpellingProblem;
import com.aptana.internal.ui.text.spelling.SpellCheckEngine;
import com.aptana.internal.ui.text.spelling.engine.ISpellCheckEngine;
import com.aptana.internal.ui.text.spelling.engine.ISpellChecker;
import com.aptana.internal.ui.text.spelling.engine.ISpellEvent;
import com.aptana.internal.ui.text.spelling.engine.ISpellEventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public abstract class SpellingEngine
implements ISpellingEngine {
    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        ISpellCheckEngine spellingEngine;
        ISpellChecker checker;
        if (collector != null && (checker = (spellingEngine = SpellCheckEngine.getInstance()).getSpellChecker()) != null) {
            this.check(document, regions, checker, collector, monitor);
        }
    }

    protected abstract void check(IDocument var1, IRegion[] var2, ISpellChecker var3, ISpellingProblemCollector var4, IProgressMonitor var5);

    protected static class SpellEventListener
    implements ISpellEventListener {
        private final ISpellingProblemCollector fCollector;
        private final IDocument fDocument;
        private final int fProblemsThreshold;
        private int fProblemCount;

        public SpellEventListener(ISpellingProblemCollector collector, IDocument document) {
            this.fCollector = collector;
            this.fDocument = document;
            this.fProblemsThreshold = 100;
        }

        public void handle(ISpellEvent event) {
            if (this.isProblemsThresholdReached()) {
                return;
            }
            ++this.fProblemCount;
            this.fCollector.accept((SpellingProblem)new JavaSpellingProblem(event, this.fDocument));
        }

        boolean isProblemsThresholdReached() {
            return this.fProblemCount >= this.fProblemsThreshold;
        }
    }
}

