/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.ContentAssistInvocationContext;
import com.aptana.internal.ui.text.spelling.ICompletionProposalComputer;
import com.aptana.internal.ui.text.spelling.JavaPluginImages;
import com.aptana.internal.ui.text.spelling.SpellCheckEngine;
import com.aptana.internal.ui.text.spelling.SpellingCompletionProposal;
import com.aptana.internal.ui.text.spelling.UserWordRanker;
import com.aptana.internal.ui.text.spelling.WordRanker;
import com.aptana.internal.ui.text.spelling.engine.DefaultSpellChecker;
import com.aptana.internal.ui.text.spelling.engine.ISpellCheckEngine;
import com.aptana.internal.ui.text.spelling.engine.ISpellChecker;
import com.aptana.internal.ui.text.spelling.engine.RankedWordProposal;
import com.aptana.semantic.ui.text.spelling.Activator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public final class WordCompletionProposalComputer
implements ICompletionProposalComputer,
ICompletionListener {
    static WordRanker basicWordRanker = new WordRanker();
    static UserWordRanker userWordRanker = new UserWordRanker(basicWordRanker);
    static String stateLocation;
    private static final int PREFIX_RANK_SHIFT = 500;

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WordCompletionProposalComputer.dispose();
            }
        });
    }

    public WordCompletionProposalComputer() {
        stateLocation = Activator.getDefault().getStateLocation().toString();
        try {
            basicWordRanker.loadFromStream(new FileInputStream(String.valueOf(stateLocation) + "\\rates.txt"));
            userWordRanker.loadFromStream(new FileInputStream(String.valueOf(stateLocation) + "\\userRates.txt"));
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (this.contributes()) {
            try {
                ISpellCheckEngine engine;
                ISpellChecker checker;
                IDocument document = context.getDocument();
                int offset = context.getInvocationOffset();
                IRegion region = document.getLineInformationOfOffset(offset);
                String content = document.get(region.getOffset(), region.getLength());
                int index = offset - region.getOffset() - 1;
                while (index >= 0 && Character.isLetter(content.charAt(index))) {
                    --index;
                }
                int start = region.getOffset() + index + 1;
                boolean isSentenceBeginning = WordCompletionProposalComputer.checkSentenceBeginning(start, document);
                final String candidate = content.substring(index + 1, offset - region.getOffset());
                if (candidate.length() > 0 && (checker = (engine = SpellCheckEngine.getInstance()).getSpellChecker()) != null) {
                    Set proposals2 = null;
                    if (checker instanceof DefaultSpellChecker) {
                        DefaultSpellChecker sp = (DefaultSpellChecker)checker;
                        proposals2 = sp.getCompletionProposals(candidate, Character.isUpperCase(candidate.charAt(0)));
                    } else {
                        proposals2 = checker.getProposals(candidate, Character.isUpperCase(candidate.charAt(0)));
                    }
                    ArrayList proposals = new ArrayList(proposals2);
                    ArrayList<SpellingCompletionProposal> result = new ArrayList<SpellingCompletionProposal>(proposals.size());
                    for (RankedWordProposal word : proposals) {
                        String text = word.getText();
                        if (text.startsWith(candidate)) {
                            word.setRank(word.getRank() + 500);
                        }
                        if (isSentenceBeginning && text.length() > 0) {
                            text = String.valueOf(Character.toUpperCase(text.charAt(0))) + text.substring(1);
                        }
                        result.add(new SpellingCompletionProposal(text, start, candidate.length(), text.length(), JavaPluginImages.get("rename"), text, null, null, userWordRanker));
                    }
                    Collections.sort(result, new Comparator<SpellingCompletionProposal>(){

                        @Override
                        public int compare(SpellingCompletionProposal o1, SpellingCompletionProposal o2) {
                            String displayString2;
                            int a2;
                            String displayString = o1.getDisplayString();
                            int a1 = userWordRanker.getRateForWord(displayString);
                            if (a1 < 0) {
                                a1 = userWordRanker.putWithDefaultRank(displayString);
                            }
                            if (displayString.startsWith(candidate)) {
                                a1 = a1 / 2 - 1;
                            }
                            if ((a2 = userWordRanker.getRateForWord(displayString2 = o2.getDisplayString())) < 0) {
                                a2 = userWordRanker.putWithDefaultRank(displayString2);
                            }
                            if (displayString2.startsWith(candidate)) {
                                a2 = a2 / 2 - 1;
                            }
                            if (a1 < a2) {
                                return -1;
                            }
                            if (a1 > a2) {
                                return 1;
                            }
                            if (displayString.length() < displayString2.length()) {
                                return -1;
                            }
                            if (displayString.length() > displayString2.length()) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                    return result;
                }
            }
            catch (BadLocationException exception) {
                Activator.log((Exception)((Object)exception));
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean checkSentenceBeginning(int offset, IDocument document) throws BadLocationException {
        if (offset > 0) {
            --offset;
        }
        while (offset > 0 && (document.get(offset, 1).equals(" ") || document.get(offset, 1).equals("\t"))) {
            --offset;
        }
        return offset == 0 || document.get(offset, 1).equals(".") || document.get(offset, 1).equals("\r") || document.get(offset, 1).equals("\n");
    }

    private boolean contributes() {
        return true;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    public static void dispose() {
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(stateLocation) + "\\rates.txt");
            basicWordRanker.saveToStream(fos);
            fos.close();
            fos = new FileOutputStream(String.valueOf(stateLocation) + "\\userRates.txt");
            userWordRanker.saveToStream(fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void assistSessionEnded(ContentAssistEvent event) {
    }

    public void assistSessionStarted(ContentAssistEvent event) {
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }
}

