/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordRanker {
    protected HashMap<String, Integer> wordRates = new HashMap(this.expectedWordCount);
    protected int minProposalLength = 2;
    protected int raringCoef = 10;
    protected int expectedWordCount = 1000;

    public void loadFromStream(InputStream stream) {
        Scanner scanner = new Scanner(stream);
        while (scanner.hasNext()) {
            boolean intScanned = true;
            int rate = -1;
            do {
                try {
                    rate = scanner.nextInt();
                }
                catch (InputMismatchException inputMismatchException) {
                    intScanned = false;
                    scanner.next();
                }
            } while (!intScanned && scanner.hasNext());
            if (rate <= -1 || !scanner.hasNext()) continue;
            String word = scanner.next();
            if (word.length() >= this.minProposalLength) {
                this.wordRates.put(word, rate);
                continue;
            }
            this.wordRates.put(word, rate + this.expectedWordCount);
        }
    }

    protected void makeRare() {
        for (String s : this.wordRates.keySet()) {
            this.wordRates.put(s, this.wordRates.get(s) * this.raringCoef);
        }
    }

    public HashMap<String, Integer> getWordRateMap() {
        return this.wordRates;
    }

    public int getRateForWord(String word) {
        Integer i = this.wordRates.get(word.trim().toLowerCase());
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int putWithDefaultRank(String word) {
        this.wordRates.put(word, this.expectedWordCount * this.raringCoef);
        return this.expectedWordCount * this.raringCoef;
    }

    public void saveToStream(OutputStream stream) {
        PrintWriter pw = new PrintWriter(stream);
        for (String key : this.wordRates.keySet()) {
            pw.println(this.wordRates.get(key) + " " + key.toLowerCase());
        }
        pw.close();
    }
}

