/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.ui.BaseTimingStartup;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.DialogUtils;
import com.aptana.ide.intro.FeatureChange;
import com.aptana.ide.intro.FeatureChangeManager;
import com.aptana.ide.intro.FeatureInstallJob;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.Messages;
import com.aptana.ide.intro.preferences.FeatureDescriptor;
import com.aptana.ide.intro.preferences.FeatureRegistry;
import com.aptana.ide.server.portal.PortalPlugin;
import com.aptana.ide.update.FeatureUtil;
import com.aptana.ide.update.manager.IPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class IntroStartup
extends BaseTimingStartup {
    public static final String IGNORE = "ignore.initial.my.aptana";

    public String getStartupName() {
        return Messages.IntroStartup_Name;
    }

    public void startup() {
        this.showMyAptana();
        this.installFeatures();
        this.startupDone();
    }

    protected void showMyAptana() {
        boolean shownPreviously;
        IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
        boolean bl = shownPreviously = store.getBoolean("com.aptana.ide.intro.IS_PORTAL_SHOWN_PREVIOUSLY") || "true".equals(System.getProperty(IGNORE));
        if (!shownPreviously) {
            store.setValue("com.aptana.ide.intro.IS_PORTAL_SHOWN_PREVIOUSLY", true);
            this.showStartupPage();
            return;
        }
        String showStartPage = store.getString("com.aptana.ide.intro.SHOW_STARTPAGE_ON_STARTUP");
        boolean portalPreviouslyOpened = PortalPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.server.portal.MY_APTANA_PREVIOUSLY_OPENED");
        if (showStartPage.equals("true") || portalPreviouslyOpened) {
            this.showStartupPage();
            return;
        }
        if (showStartPage.equals("false")) {
            return;
        }
        boolean changed = FeatureChangeManager.getManager().areFeaturesChanged();
        if (changed) {
            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Features Changed");
            List<FeatureChange> changeList = FeatureChangeManager.getManager().getFeatureChangeList();
            if (changeList != null && changeList.size() > 0) {
                this.showStartupPage();
            }
        } else {
            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Unchanged feature store");
        }
    }

    private void showStartupPage() {
        UIJob job = new UIJob("Showing Startup Page"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IPreferenceStore prefs;
                String editorId;
                IEditorPart editorPart;
                IWorkbenchPart activePart = null;
                IWorkbenchPage page = null;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    page = window.getActivePage();
                    activePart = page.getActivePart();
                }
                if ((editorPart = CoreUIUtils.openEditor((String)(editorId = (prefs = IntroPlugin.getDefault().getPreferenceStore()).getString("com.aptana.ide.intro.INTRO_EDITOR_ID")), (boolean)false)) == null) {
                    editorId = prefs.getDefaultString("com.aptana.ide.intro.INTRO_EDITOR_ID");
                    prefs.setValue("com.aptana.ide.intro.INTRO_EDITOR_ID", editorId);
                    CoreUIUtils.openEditor((String)editorId, (boolean)false);
                }
                if (activePart != null) {
                    page.activate(activePart);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule(1000L);
    }

    protected void installFeatures() {
        List<FeatureDescriptor> featuresToUpdate;
        UIJob job;
        final IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
        boolean check = store.getBoolean("com.aptana.ide.intro.INSTALL_PRO_AND_REQUIRED_FEATURES");
        if (!check) {
            return;
        }
        ArrayList features = new ArrayList();
        List installedFeatures = FeatureUtil.getInstalledFeatures();
        String[] installedFeatureIds = new String[installedFeatures.size()];
        int index = 0;
        for (IPlugin feature : installedFeatures) {
            installedFeatureIds[index++] = feature.getId();
        }
        String[] ignored = store.getString("com.aptana.ide.intro.IGNORE_INSTALL_FEATURES").split(",");
        final ArrayList<FeatureDescriptor> featuresToInstall = new ArrayList<FeatureDescriptor>();
        for (FeatureDescriptor featureDescriptor : features) {
            if (FeatureRegistry.isFeatureIgnored(featureDescriptor.getId(), ignored) || FeatureRegistry.doesFeatureConflict(featureDescriptor, installedFeatureIds)) continue;
            featuresToInstall.add(featureDescriptor);
        }
        if (featuresToInstall.size() > 0 && !store.getString("com.aptana.ide.intro.HIDE_DIALOG_INSTALL_PROMPT").equals("never")) {
            String tmp_str = "";
            for (FeatureDescriptor featureDesc : featuresToInstall) {
                tmp_str = String.valueOf(tmp_str) + "\n\t" + featureDesc.getName();
            }
            final String str_features = tmp_str;
            job = new UIJob(Messages.IntroStartup_Job_InstallFeatures){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    int returnCode = DialogUtils.openIgnoreMessageDialogConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.IntroStartup_InstallTitle, (String)MessageFormat.format(Messages.IntroStartup_InstallMessage, str_features), (IPreferenceStore)store, (String)"com.aptana.ide.intro.HIDE_DIALOG_INSTALL_PROMPT");
                    if (returnCode == 1) {
                        return Status.OK_STATUS;
                    }
                    new FeatureInstallJob(featuresToInstall).schedule(0L);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)MutexJobRule.getInstance());
            job.schedule(20000L);
        }
        if ((featuresToUpdate = FeatureRegistry.gatherInstalledRequiredFeatures()).size() > 0) {
            final StringBuilder featureToUpdateStr = new StringBuilder();
            for (FeatureDescriptor featureDesc : featuresToUpdate) {
                featureToUpdateStr.append("\n\t" + featureDesc.getName());
            }
            job = new UIJob(Messages.IntroStartup_Job_UpdateFeatures){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    boolean returnCode = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.IntroStartup_UpdateTitle, (String)MessageFormat.format(Messages.IntroStartup_UpdateMessage, featureToUpdateStr.toString()));
                    if (!returnCode) {
                        return Status.OK_STATUS;
                    }
                    new FeatureInstallJob(featuresToUpdate).schedule(0L);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)MutexJobRule.getInstance());
            job.schedule(20000L);
        }
    }
}

