/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.SignInSignOutAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUtils {
    private static final String ECLIPSE_UI_PLUGIN_ID = "org.eclipse.ui";
    private static final String ACTION_SETS = "actionSets";
    private static final String ACTION_SETS_ID = "id";
    private static final String APTANA_ACTION_SET_ID = "com.aptana.ide.intro.actionSet.MyAptanaToolbar";
    private static final String APTANA_ACTION_ID = "com.aptana.ide.intro.actions.MyAptana";
    private static final String ACTION = "action";
    private static final String ACTION_ICON = "icon";
    private static final String ACTION_LABEL = "label";
    private static final String ACTION_CLASS = "class";
    private static final String MENU = "menu";
    private static final String MENU_ID = "id";
    private static final String MENU_GROUP_MARKER = "groupMarker";
    private static final String MENU_GROUP_MARKER_NAME = "name";
    private static final String MENU_SEPARATOR = "separator";
    private static final String MENUBAR_PATH = "menubarPath";
    private static final ImageRegistry imageRegistry = new ImageRegistry();

    public static void buildMenu(Menu menu, final IWorkbenchWindow window) {
        int n;
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return;
        }
        IExtensionPoint extension = registry.getExtensionPoint(ECLIPSE_UI_PLUGIN_ID, ACTION_SETS);
        if (extension == null) {
            return;
        }
        IConfigurationElement actionSets = null;
        ArrayList<IConfigurationElement> actionElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n2 = elements.length;
        int n3 = 0;
        while (n3 < n2) {
            IConfigurationElement element = iConfigurationElementArray[n3];
            String id = element.getAttribute("id");
            if (id.startsWith(APTANA_ACTION_SET_ID)) {
                IConfigurationElement[] childElements;
                if (id.equals(APTANA_ACTION_SET_ID)) {
                    actionSets = element;
                }
                IConfigurationElement[] iConfigurationElementArray2 = childElements = element.getChildren(ACTION);
                n = childElements.length;
                int n4 = 0;
                while (n4 < n) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    actionElements.add(child);
                    ++n4;
                }
            }
            ++n3;
        }
        if (actionSets != null) {
            IConfigurationElement[] menuElements;
            IConfigurationElement[] iConfigurationElementArray3 = menuElements = actionSets.getChildren(MENU);
            int n5 = menuElements.length;
            n2 = 0;
            while (n2 < n5) {
                IConfigurationElement[] menuChildElements;
                IConfigurationElement menuElement = iConfigurationElementArray3[n2];
                String menuId = menuElement.getAttribute("id");
                IConfigurationElement[] iConfigurationElementArray4 = menuChildElements = menuElement.getChildren();
                int n6 = menuChildElements.length;
                n = 0;
                while (n < n6) {
                    IConfigurationElement menuChildElement = iConfigurationElementArray4[n];
                    if (MENU_GROUP_MARKER.equals(menuChildElement.getName())) {
                        String groupId = menuChildElement.getAttribute(MENU_GROUP_MARKER_NAME);
                        String toolbarPath = String.valueOf(menuId) + "/" + groupId;
                        List<IConfigurationElement> actionsList = ActionUtils.getGroupedActionConfElement(actionElements, toolbarPath);
                        for (IConfigurationElement actionElement : actionsList) {
                            MenuItem item = new MenuItem(menu, 8);
                            item.setText(actionElement.getAttribute(ACTION_LABEL));
                            String imageKey = actionElement.getAttribute(ACTION_ICON);
                            if (imageKey != null && !"".equals(imageKey.trim())) {
                                item.setImage(ActionUtils.getIcon(imageKey));
                            }
                            try {
                                final IWorkbenchWindowActionDelegate delegate = (IWorkbenchWindowActionDelegate)actionElement.createExecutableExtension(ACTION_CLASS);
                                if (delegate instanceof SignInSignOutAction) {
                                    item.setText(((SignInSignOutAction)delegate).getText());
                                }
                                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        delegate.init(window);
                                        delegate.run((IAction)new Action(){

                                            public String getId() {
                                                return ActionUtils.APTANA_ACTION_ID;
                                            }
                                        });
                                    }
                                });
                            }
                            catch (CoreException e) {
                                IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Failed to parse the extensions for My Aptana actions", (Throwable)e);
                            }
                        }
                    } else if (MENU_SEPARATOR.equals(menuChildElement.getName())) {
                        new MenuItem(menu, 2);
                    }
                    ++n;
                }
                ++n2;
            }
        }
    }

    private static List<IConfigurationElement> getGroupedActionConfElement(List<IConfigurationElement> elements, String menubarPath) {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement element : elements) {
            if (!menubarPath.equals(element.getAttribute(MENUBAR_PATH))) continue;
            list.add(element);
        }
        return list;
    }

    private static Image getIcon(String imageKey) {
        if (imageRegistry.get(imageKey) == null) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.intro", (String)imageKey);
            try {
                imageRegistry.put(imageKey, imageDescriptor.createImage(true));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)MessageFormat.format("Failed to get icon at path {0}", imageKey), (Throwable)e);
            }
        }
        return imageRegistry.get(imageKey);
    }
}

