/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.ClientUtils;
import com.aptana.ide.intro.actions.Messages;
import com.aptana.ide.server.jetty.comet.CometClient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardClient
extends CometClient {
    public static final String NEW_PROJECT = "/portal/projects/new";

    protected Object getResponse(String toChannel, Object request) {
        if (NEW_PROJECT.equals(toChannel) && request instanceof String) {
            String id = (String)request;
            final String wizardId = id.length() > 0 ? id : "com.aptana.ide.wizards.WebProjectWizard";
            UIJob job = new UIJob(Messages.NewWizardClient_Job_NewProjectDialog){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(wizardId);
                        if (descriptor != null) {
                            IWorkbenchWizard wizard = descriptor.createWizard();
                            wizard.init(IntroPlugin.getDefault().getWorkbench(), ClientUtils.getNavigatorSelection());
                            if (wizard instanceof IWizard) {
                                WizardDialog dialog = new WizardDialog(CoreUIUtils.getActiveShell(), (IWizard)wizard);
                                dialog.create();
                                if (wizard.getPageCount() > 0) {
                                    dialog.open();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)Messages.NewWizardClient_INF_ErrorLaunchWizard, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{NEW_PROJECT};
    }

    protected String getID(String msgId) {
        return NEW_PROJECT;
    }
}

