/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IModifiableObject;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.dialogs.AptanaSignInDialog;
import com.aptana.ide.intro.actions.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SignInSignOutAction
implements IWorkbenchWindowActionDelegate {
    private IAction action;
    private User user;
    private IModelListener modelListener = new IModelListener(){

        public void modelChanged(IModifiableObject object) {
            CoreUIUtils.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SignInSignOutAction.this.updateState();
                }
            });
        }
    };

    public void dispose() {
        if (this.user != null) {
            this.user.removeListener(this.modelListener);
            this.user = null;
        }
        this.action = null;
    }

    public void init(IWorkbenchWindow window) {
        this.user = AptanaUser.getSignedInUser();
        this.user.addListener(this.modelListener);
    }

    public void run(IAction action) {
        if (this.user != null) {
            if (this.user.hasCredentials()) {
                AptanaUser.signOut();
            } else {
                this.signIn();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.action != action) {
            this.action = action;
            this.updateState();
        }
    }

    public String getText() {
        if (this.user == null) {
            this.user = AptanaUser.getSignedInUser();
        }
        if (this.user.hasCredentials()) {
            return Messages.StartPageTrimWidget_SignOut;
        }
        return Messages.StartPageTrimWidget_SignIn;
    }

    private void updateState() {
        if (this.action != null && this.user != null) {
            if (this.user.hasCredentials()) {
                this.action.setText(Messages.StartPageTrimWidget_SignOut);
            } else {
                this.action.setText(Messages.StartPageTrimWidget_SignIn);
            }
        }
    }

    private void signIn() {
        AptanaSignInDialog dialog = new AptanaSignInDialog(CoreUIUtils.getActiveShell());
        dialog.open();
    }
}

