/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.browser;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.intro.browser.CoreBrowserEditorInput;
import com.aptana.ide.intro.browser.CoreBrowserLocationListener;
import com.aptana.ide.intro.browser.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.WebBrowserEditor;

public class CoreBrowserEditor
extends WebBrowserEditor {
    private CoreBrowserEditorInput browserInput;
    private Composite displayArea;
    public static final String ID = "com.aptana.ide.intro.browserEditor";

    public boolean isSaveAsAllowed() {
        if (this.browserInput != null) {
            return this.browserInput.isSaveAsAllowed();
        }
        return false;
    }

    public void doSaveAs() {
        if (this.browserInput != null) {
            String fileName = this.browserInput.getSaveAsFileName();
            File file = this.browserInput.getSaveAsFile();
            if (fileName != null && file != null && file.exists() && file.canRead()) {
                FileDialog dialog = new FileDialog(this.displayArea.getShell(), 8192);
                dialog.setFileName(fileName);
                dialog.setFilterExtensions(new String[]{"*.html", "*.htm"});
                String outputName = dialog.open();
                if (outputName != null) {
                    try {
                        FileInputStream stream = new FileInputStream(file);
                        FileUtils.writeStreamToFile((InputStream)stream, (String)outputName);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)this.displayArea.getShell(), (String)Messages.CoreBrowserEditor_ErrorSave_Title, (String)(String.valueOf(Messages.CoreBrowserEditor_ErrorSave_Message) + e.getMessage()));
                    }
                }
            }
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        if (this.displayArea != null) {
            this.displayArea.addDisposeListener(listener);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        if (this.displayArea != null) {
            this.displayArea.removeDisposeListener(listener);
        }
    }

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        this.displayArea.setLayout((Layout)layout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        super.createPartControl(this.displayArea);
        Browser browser = this.webBrowser.getBrowser();
        if (browser != null) {
            this.webBrowser.getBrowser().addLocationListener((LocationListener)new CoreBrowserLocationListener());
            this.webBrowser.getBrowser().addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    if (CoreBrowserEditor.this.browserInput.getScript() != null) {
                        CoreBrowserEditor.this.webBrowser.getBrowser().execute(CoreBrowserEditor.this.browserInput.getScript());
                    }
                }

                public void changed(ProgressEvent event) {
                }
            });
            this.webBrowser.getBrowser().addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    event.doit = false;
                }
            });
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof CoreBrowserEditorInput) {
            this.browserInput = (CoreBrowserEditorInput)input;
            if (!this.browserInput.isAlreadyOpened()) {
                this.browserInput.setAlreadyOpened();
            } else if (this.browserInput.isOnlyOneAllowed()) {
                throw new PartInitException("Browser already opened with same input");
            }
            if (this.browserInput.getImage() != null) {
                Image oldImage = this.image;
                this.image = this.browserInput.getImage().createImage();
                this.setTitleImage(this.image);
                if (oldImage != null && !oldImage.isDisposed()) {
                    oldImage.dispose();
                }
            }
        } else {
            throw new PartInitException("Input must be CoreBrowserEditorInput");
        }
    }

    public void executeScript() {
        if (this.browserInput != null && this.browserInput.getScript() != null && this.webBrowser != null && this.webBrowser.getBrowser() != null) {
            this.webBrowser.getBrowser().execute(this.browserInput.getScript());
        }
    }

    public void setURL(String url) {
        if (this.webBrowser != null && this.webBrowser.getBrowser() != null) {
            this.webBrowser.getBrowser().setUrl(url);
        }
    }
}

