/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.interpreters;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.interpreters.IDECorePlugin;
import com.aptana.ide.interpreters.IInterpreter;
import com.aptana.ide.interpreters.IInterpreterProvider;
import com.aptana.ide.interpreters.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreters {
    private static final String EXTENSION_POINT_NAME = "com.aptana.ide.interpreters.interpreterProvider";
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String LANGUAGE_ATTRIBUTE_NAME = "lang";
    private static final String PRIORITY_ATTRIBUTE_NAME = "priority";
    private static final String OS_ATTRIBUTE_NAME = "OpSystem";
    private static Interpreters instance = new Interpreters();
    private Map<String, List<IInterpreter>> interpreters;
    private Map<String, DefaultInterpreterInfo> defaultInterpreters;

    public static Interpreters getDefault() {
        return instance;
    }

    public synchronized List<IInterpreter> getInterpreters(String language) {
        this.collectInterpretersInfo();
        List<IInterpreter> result = this.interpreters.get(language);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public synchronized IInterpreter getDefaultInterpreter(String language) {
        this.collectInterpretersInfo();
        DefaultInterpreterInfo info = this.defaultInterpreters.get(language);
        if (info == null) {
            return null;
        }
        return info.interperter;
    }

    private void collectInterpretersInfo() {
        this.interpreters = new HashMap<String, List<IInterpreter>>();
        this.defaultInterpreters = new HashMap<String, DefaultInterpreterInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_POINT_NAME);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(PROVIDER_ELEMENT_NAME)) {
                        String language = element.getAttribute(LANGUAGE_ATTRIBUTE_NAME);
                        String os = element.getAttribute(OS_ATTRIBUTE_NAME);
                        String currentOS = System.getProperty("os.name").toLowerCase();
                        if (os == null || os.length() == 0 || currentOS.startsWith(os)) {
                            int priority = 0;
                            String priorityString = element.getAttribute(PRIORITY_ATTRIBUTE_NAME);
                            if (priorityString != null) {
                                try {
                                    priority = Integer.parseInt(priorityString);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    IdeLog.logError((Plugin)IDECorePlugin.getDefault(), (String)(String.valueOf(Messages.getString("Interpreters.ERR_WrongPriorityFormatPrefix")) + elementName + Messages.getString("Interpreters.ERR_WrongPriorityFormatSuffix")));
                                }
                            }
                            try {
                                IInterpreterProvider provider = (IInterpreterProvider)element.createExecutableExtension(CLASS_ATTRIBUTE_NAME);
                                try {
                                    DefaultInterpreterInfo oldInfo;
                                    List<IInterpreter> currentInterpreters = provider.getInterpreters();
                                    List<IInterpreter> oldInterpreters = this.interpreters.get(language);
                                    if (oldInterpreters == null) {
                                        oldInterpreters = new ArrayList<IInterpreter>();
                                    }
                                    oldInterpreters.addAll(currentInterpreters);
                                    this.interpreters.put(language, oldInterpreters);
                                    IInterpreter defaultInterpreter = provider.getDefaultInterpreter();
                                    if (defaultInterpreter != null && ((oldInfo = this.defaultInterpreters.get(language)) == null || oldInfo.priority < priority)) {
                                        DefaultInterpreterInfo newInfo = new DefaultInterpreterInfo();
                                        newInfo.priority = priority;
                                        newInfo.interperter = defaultInterpreter;
                                        this.defaultInterpreters.put(language, newInfo);
                                    }
                                }
                                catch (Throwable th) {
                                    IdeLog.logError((Plugin)IDECorePlugin.getDefault(), (String)Messages.getString("Interpreters.ERR_UnableToGetInterpretersFromProvider"), (Throwable)th);
                                }
                            }
                            catch (CoreException e) {
                                IdeLog.logError((Plugin)IDECorePlugin.getDefault(), (String)Messages.getString("Interpreters.ERR_UnableCreatingProvider"), (Throwable)e);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private Interpreters() {
    }

    private static class DefaultInterpreterInfo {
        public IInterpreter interperter;
        public int priority;

        private DefaultInterpreterInfo() {
        }
    }
}

