/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.secureftp;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.filesystem.ftp.FTPPlugin;
import com.aptana.ide.filesystem.secureftp.FTPConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.IFTPSConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.Policy;
import com.aptana.ide.filesystem.secureftp.SSLHostValidator;
import com.aptana.ide.filesystem.secureftp.SecureFTPPlugin;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPValidator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class FTPSConnectionFileManager
extends FTPConnectionFileManager
implements IFTPSConnectionFileManager {
    private boolean validateCertificate;
    private String securityMechanism;

    public void init(String host, int port, IPath basePath, String login, char[] password, boolean passive, String transferType, String encoding, String timezone) {
        throw new UnsupportedOperationException();
    }

    public void init(String host, int port, IPath basePath, String login, char[] password, boolean explicit, boolean passive, String transferType, String encoding, String timezone, boolean validateCertificate) {
        Assert.isTrue((this.ftpClient == null ? 1 : 0) != 0, (String)"FTPS connection has been already initiated");
        try {
            this.ftpClient = this.createFTPClient();
            this.host = host;
            this.port = port;
            this.login = login;
            this.password = password == null ? new char[]{} : password;
            this.basePath = basePath != null ? basePath : Path.ROOT;
            this.authId = Policy.generateAuthId("FTPS", login, host, port);
            this.transferType = transferType;
            this.timezone = timezone != null && timezone.length() == 0 ? null : timezone;
            this.validateCertificate = validateCertificate;
            FTPSConnectionFileManager.initFTPSClient((SSLFTPClient)this.ftpClient, explicit, passive, encoding, validateCertificate);
        }
        catch (Exception e) {
            IdeLog.logImportant((Plugin)SecureFTPPlugin.getDefault(), (String)"FTPS connection initialization failed", (Throwable)e);
            this.ftpClient = null;
        }
    }

    protected static void initFTPSClient(SSLFTPClient ftpsClient, boolean explicit, boolean passive, String encoding, boolean validateCertificate) throws IOException, FTPException {
        FTPSConnectionFileManager.initFTPClient((FTPClient)ftpsClient, passive, encoding);
        ftpsClient.setImplicitFTPS(true);
        ftpsClient.setCustomValidator((SSLFTPValidator)new SSLHostValidator());
        ftpsClient.setValidateServer(validateCertificate);
        ftpsClient.setImplicitFTPS(!explicit);
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.ftpClient != null ? 1 : 0) != 0, (String)"FTPS connection is not initialized");
        SSLFTPClient ftpsClient = (SSLFTPClient)this.ftpClient;
        monitor = Policy.monitorFor(monitor);
        try {
            this.cwd = null;
            this.cleanup();
            ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
            if (this.messageLogWriter == null) {
                if (context != null) {
                    Object object = context.get((Object)"command_log");
                    if (object instanceof PrintWriter) {
                        this.messageLogWriter = (PrintWriter)object;
                    } else if (object instanceof OutputStream) {
                        this.messageLogWriter = new PrintWriter((OutputStream)object);
                    }
                }
                if (this.messageLogWriter == null) {
                    this.messageLogWriter = FTPPlugin.getDefault().getFTPLogWriter();
                }
                if (this.messageLogWriter != null) {
                    this.messageLogWriter.println(StringUtils.format((String)"---------- FTPS {0} ----------", (String)this.host));
                    FTPSConnectionFileManager.setMessageLogger(this.ftpClient, this.messageLogWriter);
                }
            } else {
                this.messageLogWriter.println(StringUtils.format((String)"---------- RECONNECTING - FTPS {0} ----------", (String)this.host));
            }
            monitor.beginTask("Establishing FTPS connection", -1);
            this.ftpClient.setRemoteHost(this.host);
            this.ftpClient.setRemotePort(this.port);
            while (true) {
                monitor.subTask("connecting");
                this.ftpClient.connect();
                if (!ftpsClient.isImplicitFTPS()) {
                    if (this.securityMechanism == null) {
                        String[] supportedMechanisms;
                        block34: {
                            supportedMechanisms = new String[]{"TLS", "TLS-C", "SSL"};
                            try {
                                String[] features = this.ftpClient.features();
                                if (features == null || features.length <= 0) break block34;
                                int i = 0;
                                while (i < features.length) {
                                    features[i] = features[i].trim();
                                    ++i;
                                }
                                List<String> featuresList = Arrays.asList(features);
                                int i2 = 0;
                                while (i2 < supportedMechanisms.length) {
                                    if (featuresList.contains("AUTH " + supportedMechanisms[i2])) {
                                        this.securityMechanism = supportedMechanisms[i2];
                                        break;
                                    }
                                    ++i2;
                                }
                            }
                            catch (Exception exception) {}
                        }
                        if (this.securityMechanism == null) {
                            this.securityMechanism = supportedMechanisms[0];
                        }
                    }
                    ftpsClient.auth(this.securityMechanism);
                }
                if (!(this.password.length != 0 || "anonymous".equals(this.login) || context != null && context.getBoolean("no_password_prompt"))) {
                    this.getOrPromptPassword(StringUtils.format((String)"FTPS Authentication for {0}", (String)this.host), "Please specify password.");
                }
                Policy.checkCanceled(monitor);
                monitor.subTask("authenticating");
                try {
                    this.ftpClient.login(this.login, String.copyValueOf(this.password));
                }
                catch (FTPException e) {
                    Policy.checkCanceled(monitor);
                    if ("331".equals(this.ftpClient.getLastValidReply().getReplyCode())) {
                        if (context != null && context.getBoolean("no_password_prompt")) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Authentication failed: {0}", (String)e.getLocalizedMessage()), (Throwable)e));
                        }
                        this.promptPassword(StringUtils.format((String)"FTPS Authentication for {0}", (String)this.host), "Password was not accepted. Please specify again.");
                        this.safeQuit();
                        continue;
                    }
                    throw e;
                }
                break;
            }
            Policy.checkCanceled(monitor);
            if (ftpsClient.isImplicitFTPS()) {
                ftpsClient.auth('P');
            }
            Policy.checkCanceled(monitor);
            this.changeCurrentDir(this.basePath);
            this.ftpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            if ((this.hasServerInfo || context != null && context.getBoolean("quick_connect")) && (context == null || !context.getBoolean("detect_timezone"))) {
                return;
            }
            try {
                this.getherServerInfo(context, monitor);
            }
            catch (OperationCanceledException e) {
                this.safeQuit();
                throw e;
            }
            catch (CoreException e) {
                this.safeQuit();
                throw e;
            }
            catch (UnknownHostException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Host name not found: " + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Remote folder not found: " + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (Exception e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Establishing FTPS connection failed: " + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected FTPClient createFTPClient() {
        try {
            return new SSLFTPClient();
        }
        catch (FTPException e) {
            IdeLog.logError((Plugin)SecureFTPPlugin.getDefault(), (String)"", (Throwable)e);
            return null;
        }
    }

    protected void initAndAuthFTPClient(FTPClient newFtpClient, IProgressMonitor monitor) throws IOException, FTPException {
        SSLFTPClient newFtpsClient = (SSLFTPClient)newFtpClient;
        FTPSConnectionFileManager.initFTPSClient(newFtpsClient, !((SSLFTPClient)this.ftpClient).isImplicitFTPS(), this.ftpClient.getConnectMode() == FTPConnectMode.PASV, this.ftpClient.getControlEncoding(), this.validateCertificate);
        newFtpClient.setRemoteHost(this.host);
        newFtpClient.setRemotePort(this.port);
        Policy.checkCanceled(monitor);
        newFtpClient.connect();
        monitor.worked(1);
        Policy.checkCanceled(monitor);
        if (!newFtpsClient.isImplicitFTPS()) {
            newFtpsClient.auth(this.securityMechanism);
        }
        newFtpClient.login(this.login, String.copyValueOf(this.password));
        monitor.worked(1);
    }

    protected URI getRootCanonicalURI() {
        try {
            return new URI("ftps", this.login, this.host, this.port != 21 && this.port != 990 ? this.port : -1, Path.ROOT.toPortableString(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

