/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.secureftp;

import com.aptana.ide.core.epl.IMemento;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint15Constants;
import com.aptana.ide.core.io.vfs.IConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.FTPSConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.IFTPSConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.IFTPSConnectionPoint;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class FTPSConnectionPoint
extends ConnectionPoint
implements IFTPSConnectionPoint {
    public static final String TYPE = "ftps";
    private static final String ELEMENT_HOST = "host";
    private static final String ELEMENT_PORT = "port";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_LOGIN = "login";
    private static final String ELEMENT_EXPLICIT = "explicit";
    private static final String ELEMENT_VALIDATE_CERTIFICATE = "validateCertificate";
    private static final String ELEMENT_PASSIVE = "passive";
    private static final String ELEMENT_TRANSFER_TYPE = "transferType";
    private static final String ELEMENT_ENCODING = "encoding";
    private static final String ELEMENT_TIMEZONE = "timezone";
    private String host;
    private int port = 21;
    private IPath path = Path.ROOT;
    private String login = "";
    private char[] password;
    private boolean explicit = true;
    private boolean validateCertificate = true;
    private boolean passiveMode = true;
    private String transferType = "BINARY";
    private String encoding = "US-ASCII";
    private String timezone = null;
    private IFTPSConnectionFileManager connectionFileManager;

    public FTPSConnectionPoint() {
        super(TYPE);
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        IMemento child = memento.getChild(ELEMENT_HOST);
        if (child != null) {
            this.host = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_PORT)) != null) {
            try {
                this.port = Integer.parseInt(child.getTextData());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((child = memento.getChild(ELEMENT_PATH)) != null) {
            this.path = Path.fromPortableString((String)child.getTextData());
        }
        if ((child = memento.getChild(ELEMENT_LOGIN)) != null) {
            this.login = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_EXPLICIT)) != null) {
            this.explicit = Boolean.parseBoolean(child.getTextData());
        }
        if ((child = memento.getChild(ELEMENT_VALIDATE_CERTIFICATE)) != null) {
            this.validateCertificate = Boolean.parseBoolean(child.getTextData());
        }
        if ((child = memento.getChild(ELEMENT_PASSIVE)) != null) {
            this.passiveMode = Boolean.parseBoolean(child.getTextData());
        }
        if ((child = memento.getChild(ELEMENT_TRANSFER_TYPE)) != null) {
            this.transferType = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_ENCODING)) != null) {
            this.encoding = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_TIMEZONE)) != null) {
            this.timezone = child.getTextData();
        }
    }

    protected void saveState(IMemento memento) {
        super.saveState(memento);
        memento.createChild(ELEMENT_HOST).putTextData(this.host);
        if (21 != this.port) {
            memento.createChild(ELEMENT_PORT).putTextData(Integer.toString(this.port));
        }
        if (!Path.ROOT.equals((Object)this.path)) {
            memento.createChild(ELEMENT_PATH).putTextData(this.path.toPortableString());
        }
        if (this.login.length() != 0) {
            memento.createChild(ELEMENT_LOGIN).putTextData(this.login);
        }
        memento.createChild(ELEMENT_EXPLICIT).putTextData(Boolean.toString(this.explicit));
        memento.createChild(ELEMENT_VALIDATE_CERTIFICATE).putTextData(Boolean.toString(this.validateCertificate));
        memento.createChild(ELEMENT_PASSIVE).putTextData(Boolean.toString(this.passiveMode));
        if (!"AUTO".equals(this.transferType)) {
            memento.createChild(ELEMENT_TRANSFER_TYPE).putTextData(this.transferType);
        }
        if (!"US-ASCII".equals(this.encoding)) {
            memento.createChild(ELEMENT_ENCODING).putTextData(this.encoding);
        }
        if (this.timezone != null && this.timezone.length() != 0) {
            memento.createChild(ELEMENT_TIMEZONE).putTextData(this.timezone);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        if (this.explicit != explicit) {
            if (explicit) {
                if (990 == this.port) {
                    this.port = 21;
                }
            } else if (21 == this.port) {
                this.port = 990;
            }
        }
        this.explicit = explicit;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public boolean isValidateCertificate() {
        return this.validateCertificate;
    }

    public void setValidateCertificate(boolean validate) {
        if (this.validateCertificate != validate) {
            this.validateCertificate = validate;
            this.notifyChanged();
            this.resetConnectionFileManager();
        }
    }

    public void connect(boolean force, IProgressMonitor monitor) throws CoreException {
        if (!force && this.isConnected()) {
            return;
        }
        ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
        if (context != null) {
            CoreIOPlugin.setConnectionContext((Object)this.connectionFileManager, (ConnectionContext)context);
        }
        this.getConnectionFileManager().connect(monitor);
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            this.getConnectionFileManager().disconnect(monitor);
        }
    }

    public boolean isConnected() {
        return this.connectionFileManager != null && this.connectionFileManager.isConnected();
    }

    public boolean canDisconnect() {
        return this.isConnected();
    }

    public Object getAdapter(Class adapter) {
        if (IConnectionFileManager.class == adapter) {
            return this.getConnectionFileManager();
        }
        return super.getAdapter(adapter);
    }

    private synchronized void resetConnectionFileManager() {
        this.connectionFileManager = null;
    }

    private synchronized IConnectionFileManager getConnectionFileManager() {
        if (this.connectionFileManager == null) {
            ConnectionContext context;
            this.connectionFileManager = (IFTPSConnectionFileManager)super.getAdapter(IFTPSConnectionFileManager.class);
            if (this.connectionFileManager == null && Platform.getAdapterManager().hasAdapter((Object)this, IFTPSConnectionFileManager.class.getName())) {
                this.connectionFileManager = (IFTPSConnectionFileManager)Platform.getAdapterManager().loadAdapter((Object)this, IFTPSConnectionFileManager.class.getName());
            }
            if (this.connectionFileManager == null) {
                this.connectionFileManager = new FTPSConnectionFileManager();
            }
            if ((context = CoreIOPlugin.getConnectionContext((Object)this)) != null) {
                CoreIOPlugin.setConnectionContext((Object)this.connectionFileManager, (ConnectionContext)context);
            }
            this.connectionFileManager.init(this.host, this.port, this.path, this.login, this.password, this.explicit, this.passiveMode, this.transferType, this.encoding, this.timezone, this.validateCertificate);
        }
        return this.connectionFileManager;
    }

    public boolean load15Data(String data) {
        String[] items = data.split(IConnectionPoint15Constants.DELIMITER);
        if (items.length < 7) {
            return false;
        }
        this.setName(items[0]);
        this.setHost(items[1]);
        if (items[2] == null || "".equals(items[2])) {
            this.setPath((IPath)Path.ROOT);
        } else {
            this.setPath((IPath)new Path(items[2]));
        }
        this.setLogin(items[3]);
        this.setPassword(items[4].toCharArray());
        this.setPassiveMode(items[5].equals(Boolean.TRUE.toString()));
        this.setId(items[6]);
        if (items.length >= 10) {
            this.setPort(Integer.parseInt(items[9]));
        }
        if (items.length >= 12) {
            this.setExplicit(items[11].equals(Boolean.TRUE.toString()));
        }
        return true;
    }

    public String getFileSeparator() {
        return File.separator;
    }
}

