/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.secureftp;

import com.aptana.ide.core.epl.IMemento;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint15Constants;
import com.aptana.ide.core.io.vfs.IConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.ISFTPConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.ISFTPConnectionPoint;
import com.aptana.ide.filesystem.secureftp.SFTPConnectionFileManager;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class SFTPConnectionPoint
extends ConnectionPoint
implements ISFTPConnectionPoint {
    public static final String TYPE = "sftp";
    private static final String ELEMENT_HOST = "host";
    private static final String ELEMENT_PORT = "port";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_LOGIN = "login";
    private static final String ELEMENT_PRIVATE_KEY_FILE = "privateKeyFile";
    private static final String ELEMENT_TRANSFER_TYPE = "transferType";
    private static final String ELEMENT_ENCODING = "encoding";
    private static final String ELEMENT_COMPRESSION = "compression";
    private String host;
    private int port = 22;
    private IPath path = Path.ROOT;
    private String login = "";
    private IPath privateKeyFile;
    private char[] password;
    private String transferType = "BINARY";
    private String encoding = "US-ASCII";
    private String compression = "AUTO";
    private ISFTPConnectionFileManager connectionFileManager;

    public SFTPConnectionPoint() {
        super(TYPE);
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        IMemento child = memento.getChild(ELEMENT_HOST);
        if (child != null) {
            this.host = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_PORT)) != null) {
            try {
                this.port = Integer.parseInt(child.getTextData());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((child = memento.getChild(ELEMENT_PATH)) != null) {
            this.path = Path.fromPortableString((String)child.getTextData());
        }
        if ((child = memento.getChild(ELEMENT_LOGIN)) != null) {
            this.login = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_PRIVATE_KEY_FILE)) != null) {
            this.privateKeyFile = Path.fromPortableString((String)child.getTextData());
        }
        if ((child = memento.getChild(ELEMENT_TRANSFER_TYPE)) != null) {
            this.transferType = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_ENCODING)) != null) {
            this.encoding = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_COMPRESSION)) != null) {
            this.compression = child.getTextData();
        }
    }

    protected void saveState(IMemento memento) {
        super.saveState(memento);
        memento.createChild(ELEMENT_HOST).putTextData(this.host);
        if (22 != this.port) {
            memento.createChild(ELEMENT_PORT).putTextData(Integer.toString(this.port));
        }
        if (!Path.ROOT.equals((Object)this.path)) {
            memento.createChild(ELEMENT_PATH).putTextData(this.path.toPortableString());
        }
        if (this.login.length() != 0) {
            memento.createChild(ELEMENT_LOGIN).putTextData(this.login);
        }
        if (this.privateKeyFile != null && !this.privateKeyFile.isEmpty()) {
            memento.createChild(ELEMENT_PRIVATE_KEY_FILE).putTextData(this.privateKeyFile.toPortableString());
        }
        if (!"AUTO".equals(this.transferType)) {
            memento.createChild(ELEMENT_TRANSFER_TYPE).putTextData(this.transferType);
        }
        if (!"US-ASCII".equals(this.encoding)) {
            memento.createChild(ELEMENT_ENCODING).putTextData(this.encoding);
        }
        if (!"AUTO".equals(this.encoding)) {
            memento.createChild(ELEMENT_COMPRESSION).putTextData(this.compression);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public IPath getKeyFilePath() {
        return this.privateKeyFile;
    }

    public void setKeyFilePath(IPath keyFilePath) {
        this.privateKeyFile = keyFilePath;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
        this.notifyChanged();
        this.resetConnectionFileManager();
    }

    public void connect(boolean force, IProgressMonitor monitor) throws CoreException {
        if (!force && this.isConnected()) {
            return;
        }
        ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
        if (context != null) {
            CoreIOPlugin.setConnectionContext((Object)this.connectionFileManager, (ConnectionContext)context);
        }
        this.getConnectionFileManager().connect(monitor);
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            this.getConnectionFileManager().disconnect(monitor);
        }
    }

    public boolean isConnected() {
        return this.connectionFileManager != null && this.connectionFileManager.isConnected();
    }

    public boolean canDisconnect() {
        return this.isConnected();
    }

    public Object getAdapter(Class adapter) {
        if (IConnectionFileManager.class == adapter) {
            return this.getConnectionFileManager();
        }
        return super.getAdapter(adapter);
    }

    private synchronized void resetConnectionFileManager() {
        this.connectionFileManager = null;
    }

    private synchronized IConnectionFileManager getConnectionFileManager() {
        if (this.connectionFileManager == null) {
            ConnectionContext context;
            this.connectionFileManager = (ISFTPConnectionFileManager)super.getAdapter(ISFTPConnectionFileManager.class);
            if (this.connectionFileManager == null && Platform.getAdapterManager().hasAdapter((Object)this, ISFTPConnectionFileManager.class.getName())) {
                this.connectionFileManager = (ISFTPConnectionFileManager)Platform.getAdapterManager().loadAdapter((Object)this, ISFTPConnectionFileManager.class.getName());
            }
            if (this.connectionFileManager == null) {
                this.connectionFileManager = new SFTPConnectionFileManager();
            }
            if ((context = CoreIOPlugin.getConnectionContext((Object)this)) != null) {
                CoreIOPlugin.setConnectionContext((Object)this.connectionFileManager, (ConnectionContext)context);
            }
            IPath keyFilePath = this.privateKeyFile != null && !this.privateKeyFile.isEmpty() ? this.privateKeyFile : null;
            this.connectionFileManager.init(this.host, this.port, this.path, keyFilePath, this.login, this.password, this.transferType, this.encoding, this.compression);
        }
        return this.connectionFileManager;
    }

    public boolean load15Data(String data) {
        String[] items = data.split(IConnectionPoint15Constants.DELIMITER);
        if (items.length < 6) {
            return false;
        }
        this.setName(items[0]);
        this.setHost(items[1]);
        if (items[2] == null || "".equals(items[2])) {
            this.setPath((IPath)Path.ROOT);
        } else {
            this.setPath((IPath)new Path(items[2]));
        }
        this.setLogin(items[3]);
        this.setPassword(items[4].toCharArray());
        String id = items[5].replace(IConnectionPoint15Constants.DELIMITER.charAt(0), ' ').trim();
        try {
            this.setId(id);
        }
        catch (NumberFormatException numberFormatException) {
            this.setId(UUID.randomUUID().toString());
        }
        if (items.length >= 9) {
            this.setPort(Integer.parseInt(items[8]));
        }
        if (items.length >= 13) {
            this.setKeyFilePath((IPath)new Path(items[12]));
        }
        return true;
    }

    public String getFileSeparator() {
        return "/";
    }
}

