/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.Messages;
import com.aptana.ide.core.StringUtils;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DateUtils {
    protected DateUtils() {
    }

    public static String getTimeOffsetString(long offset) {
        long seconds = offset / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (Math.abs(seconds) < 60L) {
            return StringUtils.format(Messages.DateUtils_seconds, seconds);
        }
        if (Math.abs(minutes) < 60L) {
            return StringUtils.format(Messages.DateUtils_minutes, minutes);
        }
        return StringUtils.format(Messages.DateUtils_hours, hours);
    }

    public static long roundDownToMinuteInterval(long millis, int minuteInterval) {
        long result = millis;
        if (minuteInterval > 0) {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            calendar.setTimeInMillis(millis);
            calendar.clear(13);
            calendar.clear(14);
            int minutes = calendar.get(12);
            int remainder = minutes % minuteInterval;
            if (remainder > 0) {
                ((Calendar)calendar).add(12, -remainder);
            }
            result = calendar.getTimeInMillis();
        }
        return result;
    }

    public static long addDayInterval(long millis, int dayInterval) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(millis);
        ((Calendar)calendar).add(5, dayInterval);
        return calendar.getTimeInMillis();
    }

    public static long addMinuteInterval(long millis, int minuteInterval) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(millis);
        ((Calendar)calendar).add(12, minuteInterval);
        return calendar.getTimeInMillis();
    }
}

