/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.Messages;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class IdeLog {
    private static Map<Plugin, List<Status>> earlyMessageCache = new HashMap<Plugin, List<Status>>();
    private static boolean caching = true;
    public static int OFF = 0;
    public static int ERROR = 1;
    public static int WARNING = 2;
    public static int INFO = 3;

    public static void flushCache() {
        caching = false;
        for (Plugin plugin : earlyMessageCache.keySet()) {
            List<Status> messages = earlyMessageCache.get(plugin);
            int i = 0;
            while (i < messages.size()) {
                Status status = messages.get(i);
                if (status.getSeverity() == 4 || IdeLog.isAptanaDebugging(status.getSeverity()) || plugin.isDebugging()) {
                    IdeLog.log(plugin, status.getSeverity(), status.getMessage(), status.getException());
                }
                ++i;
            }
        }
        earlyMessageCache.clear();
    }

    private IdeLog() {
    }

    public static void logError(Plugin plugin, String message) {
        IdeLog.log(plugin, 4, message, null);
    }

    public static boolean isAptanaDebugging(int debugLevel) {
        if (caching) {
            return true;
        }
        if (Platform.inDebugMode()) {
            return true;
        }
        if (AptanaCorePlugin.getDefault() != null) {
            int statusPreference = Platform.getPreferencesService().getInt("com.aptana.ide.core", "com.aptana.ide.core.PREF_DEBUG_LEVEL", OFF, null);
            if (statusPreference == OFF) {
                return false;
            }
            return statusPreference >= IdeLog.getStatusLevel(debugLevel);
        }
        return false;
    }

    private static int getStatusLevel(int status) {
        switch (status) {
            case 1: {
                return INFO;
            }
            case 2: {
                return WARNING;
            }
            case 4: {
                return ERROR;
            }
        }
        return OFF;
    }

    public static void logError(Plugin plugin, String message, Throwable th) {
        IdeLog.log(plugin, 4, message, th);
    }

    public static void logWarning(Plugin plugin, String message, Throwable th) {
        if (IdeLog.isAptanaDebugging(2) || plugin != null && plugin.isDebugging()) {
            IdeLog.log(plugin, 2, message, th);
        }
    }

    public static void logWarning(Plugin plugin, String message) {
        if (IdeLog.isAptanaDebugging(2) || plugin != null && plugin.isDebugging()) {
            IdeLog.log(plugin, 2, message, null);
        }
    }

    public static void logImportant(Plugin plugin, String message, Throwable th) {
        if (IdeLog.isAptanaDebugging(2) || plugin != null && plugin.isDebugging()) {
            IdeLog.log(plugin, 2, message, th);
        }
    }

    public static void logImportant(Plugin plugin, String message) {
        if (IdeLog.isAptanaDebugging(2) || plugin != null && plugin.isDebugging()) {
            IdeLog.log(plugin, 2, message, null);
        }
    }

    public static void logInfo(Plugin plugin, String message) {
        if (IdeLog.isAptanaDebugging(1) || plugin != null && plugin.isDebugging()) {
            IdeLog.log(plugin, 1, message, null);
        }
    }

    public static void logInfo(Plugin plugin, String message, Throwable th) {
        if (IdeLog.isAptanaDebugging(1) || plugin != null && plugin.isDebugging()) {
            IdeLog.log(plugin, 1, message, th);
        }
    }

    public static void logInfoToFile(Plugin plugin, String message, String name, String suffix, String fileContent) {
        if (IdeLog.isAptanaDebugging(2) || plugin.isDebugging()) {
            File f = null;
            try {
                f = File.createTempFile(name, suffix);
                FileUtils.writeStringToFile(fileContent, f);
                IdeLog.log(plugin, 2, String.valueOf(message) + Messages.IdeLog_File_Written_To + f.getAbsolutePath(), null);
            }
            catch (IOException iOException) {
                IdeLog.log(plugin, 2, String.valueOf(message) + Messages.IdeLog_Unable_To_Write_Temporary_File, null);
            }
        }
    }

    public static void log(Plugin plugin, int status, String message, Throwable th) {
        if (plugin == null) {
            System.err.println(message);
            if (th != null) {
                th.printStackTrace();
            }
            return;
        }
        String tempMessage = StringUtils.format("(Build {0}) {1} {2}", new String[]{PluginUtils.getPluginVersion(plugin), IdeLog.getLabel(status), message});
        if (!PluginUtils.isPluginLoaded(plugin)) {
            System.err.println(tempMessage);
            return;
        }
        Status logStatus = new Status(status, plugin.getBundle().getSymbolicName(), 0, tempMessage, th);
        if (caching) {
            List<Object> statusMessages = null;
            if (earlyMessageCache.containsKey(plugin)) {
                statusMessages = earlyMessageCache.get(plugin);
            } else {
                statusMessages = new ArrayList();
                earlyMessageCache.put(plugin, statusMessages);
            }
            statusMessages.add(logStatus);
        } else {
            plugin.getLog().log((IStatus)logStatus);
        }
        if (status == 4 && IdeLog.isAptanaDebugging(4)) {
            System.err.println(tempMessage);
            if (th != null) {
                th.printStackTrace();
            }
        }
    }

    private static String getLabel(int status) {
        switch (status) {
            case 1: {
                return Messages.IdeLog_INFO;
            }
            case 2: {
                return Messages.IdeLog_IMPORTANT;
            }
            case 4: {
                return Messages.IdeLog_ERROR;
            }
        }
        return Messages.IdeLog_UNKNOWN;
    }
}

