/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.db;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.db.IDBShutdownListener;
import com.aptana.ide.core.db.IResultSetHandler;
import com.aptana.ide.core.db.Messages;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class AptanaDB {
    private static final String DATABASE_NAME = "aptanaDB";
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String PROTOCOL = "jdbc:derby:";
    private static AptanaDB INSTANCE;
    private List<IDBShutdownListener> _shutdownListeners = new ArrayList<IDBShutdownListener>();
    private boolean _driverLoaded = false;

    private AptanaDB() {
    }

    public void addShutdownListener(IDBShutdownListener listener) {
        if (listener != null) {
            if (this._shutdownListeners == null) {
                this._shutdownListeners = new ArrayList<IDBShutdownListener>();
            }
            this._shutdownListeners.add(listener);
        }
    }

    public void execute(String query) {
        Connection connection = INSTANCE.getConnection();
        if (connection != null) {
            Statement statement = null;
            try {
                try {
                    statement = connection.createStatement();
                    statement.execute(query);
                }
                catch (SQLException e) {
                    IdeLog.logInfo(AptanaCorePlugin.getDefault(), Messages.EventLogger_Query_Error, e);
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e2) {
                            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Statement_Close_Error, e2);
                        }
                    }
                    try {
                        connection.close();
                    }
                    catch (SQLException e3) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Connection_Close_Error, e3);
                    }
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Statement_Close_Error, e);
                    }
                }
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Connection_Close_Error, e);
                }
            }
        }
    }

    public void execute(String query, IResultSetHandler handler) {
        Connection connection = INSTANCE.getConnection();
        if (connection != null) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(query);
                    while (resultSet.next()) {
                        handler.processResultSet(resultSet);
                    }
                }
                catch (SQLException e) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Query_Error, e);
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e2) {
                            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.AptanaDB_Error_Closing_ResultSet, e2);
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e3) {
                            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Statement_Close_Error, e3);
                        }
                    }
                    try {
                        connection.close();
                    }
                    catch (SQLException e4) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Connection_Close_Error, e4);
                    }
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.AptanaDB_Error_Closing_ResultSet, e);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Statement_Close_Error, e);
                    }
                }
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Connection_Close_Error, e);
                }
            }
        }
    }

    public Connection getConnection() {
        Connection result = null;
        if (this._driverLoaded) {
            try {
                result = DriverManager.getConnection("jdbc:derby:aptanaDB;create=true");
            }
            catch (SQLException e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Unable_To_Connect, e);
            }
        }
        return result;
    }

    public static AptanaDB getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AptanaDB();
            INSTANCE.loadDriver();
        }
        return INSTANCE;
    }

    protected void loadDriver() {
        try {
            String homeDirectoryName = System.getProperty("osgi.configuration.area");
            URL homeDirectoryURL = FileUtils.uriToURL(homeDirectoryName);
            File homeDirectory = FileUtils.urlToFile(homeDirectoryURL);
            homeDirectory.mkdirs();
            System.setProperty("derby.system.home", homeDirectory.getAbsolutePath());
            Class.forName(DRIVER).newInstance();
            this._driverLoaded = true;
        }
        catch (InstantiationException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Unable_To_Instantiate, e);
        }
        catch (IllegalAccessException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Access_Denied, e);
        }
        catch (ClassNotFoundException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Class_Not_Found, e);
        }
    }

    public void removeShutdownListener(IDBShutdownListener listener) {
        if (this._shutdownListeners != null) {
            this._shutdownListeners.remove(listener);
        }
    }

    public void shutdown() {
        block5: {
            if (this._driverLoaded) {
                if (this._shutdownListeners != null) {
                    for (IDBShutdownListener listener : this._shutdownListeners) {
                        listener.shutdown();
                    }
                }
                try {
                    DriverManager.getConnection("jdbc:derby:aptanaDB;shutdown=true");
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 45000 || "XJ015".equals(e.getSQLState()) || "08006".equals(e.getSQLState())) break block5;
                    IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.EventLogger_Error_While_Shutting_Down, e);
                }
            }
        }
    }
}

