/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureInfo
implements Comparable<FeatureInfo> {
    private static final Pattern TRAILING_DOTTED_NUMBERS = Pattern.compile("(?:\\.[0-9]+)+$");
    public final String name;
    public final String version;
    public final boolean enabled;

    public FeatureInfo(String name, String version, boolean enabled) {
        Matcher m;
        if (name != null && (m = TRAILING_DOTTED_NUMBERS.matcher(name)).find()) {
            name = name.substring(0, m.start());
        }
        this.name = name != null ? name : "";
        this.version = version != null ? version : "";
        this.enabled = enabled;
    }

    @Override
    public int compareTo(FeatureInfo o) {
        int result = this.name.compareTo(o.name);
        if (result == 0 && (result = this.version.compareTo(o.version)) == 0 && this.enabled != o.enabled) {
            result = this.enabled ? -1 : 1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof FeatureInfo) {
            FeatureInfo info = (FeatureInfo)obj;
            result = this.name.equals(info.name) && this.version.equals(info.version) && this.enabled == info.enabled;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.version + ":" + Boolean.toString(this.enabled);
    }
}

