/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.db;

import com.aptana.ide.core.db.AptanaDB;
import com.aptana.ide.core.db.FeatureInfo;
import com.aptana.ide.core.db.IResultSetHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;

public final class FeatureTracker {
    static FeatureTracker INSTANCE;
    private static final String TABLE_NAME = "features";
    private static final String FEATURE = "feature";
    private static final String VERSION = "version";
    private static final String ENABLED = "enabled";
    private static final String GET_FEATURES;

    static {
        GET_FEATURES = MessageFormat.format("SELECT {0}, {1}, {2} FROM {3}", FEATURE, VERSION, ENABLED, TABLE_NAME);
    }

    private FeatureTracker() {
    }

    public static FeatureTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeatureTracker();
            AptanaDB db = AptanaDB.getInstance();
            if (!INSTANCE.tableExists()) {
                String query = MessageFormat.format("CREATE TABLE {0}({1} varchar(255),{2} varchar(255),{3} varchar(255))", TABLE_NAME, FEATURE, VERSION, ENABLED);
                db.execute(query);
            }
        }
        return INSTANCE;
    }

    public void addFeature(FeatureInfo feature) {
        this.addFeature(feature.name, feature.version, Boolean.toString(feature.enabled));
    }

    public void addFeature(String feature, String version, String enabled) {
        String query = MessageFormat.format("INSERT INTO {0}({1},{2},{3}) VALUES(''{4}'',''{5}'',''{6}'')", TABLE_NAME, FEATURE, VERSION, ENABLED, feature != null && feature.length() > 0 ? feature : "", version != null && version.length() > 0 ? version : "", enabled != null && enabled.length() > 0 ? enabled : "");
        AptanaDB.getInstance().execute(query);
    }

    public void clearFeatures() {
        String query = "DELETE FROM features";
        AptanaDB.getInstance().execute(query);
    }

    public FeatureInfo[] getFeatures() {
        final ArrayList features = new ArrayList();
        AptanaDB.getInstance().execute(GET_FEATURES, new IResultSetHandler(){

            public void processResultSet(ResultSet resultSet) throws SQLException {
                String feature = resultSet.getString(1);
                String version = resultSet.getString(2);
                String enabled = resultSet.getString(3);
                features.add(new FeatureInfo(feature, version, Boolean.parseBoolean(enabled)));
            }
        });
        return features.toArray(new FeatureInfo[features.size()]);
    }

    private boolean tableExists() {
        boolean result;
        block26: {
            Connection connection = null;
            Statement statement = null;
            result = true;
            try {
                try {
                    connection = AptanaDB.getInstance().getConnection();
                    if (connection != null) {
                        statement = connection.createStatement();
                        statement.execute("SELECT COUNT(*) FROM features");
                    } else {
                        result = false;
                    }
                }
                catch (SQLException sqle) {
                    String errorStateCode = sqle.getSQLState();
                    if (errorStateCode.equals("42X05")) {
                        result = false;
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }
}

