/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model;

import com.aptana.ide.core.ILoggable;
import com.aptana.ide.core.ILogger;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.model.BaseModelObject;
import com.aptana.ide.core.model.ILocationObject;
import com.aptana.ide.core.model.IServiceErrors;
import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequest;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.IServiceResponse;
import com.aptana.ide.core.model.ISynchronizableObject;
import com.aptana.ide.core.model.ITransformObject;
import com.aptana.ide.core.model.Messages;
import com.aptana.ide.core.model.ServiceErrors;
import com.aptana.ide.core.xpath.XPathUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreModelObject
extends BaseModelObject
implements ILocationObject,
ISynchronizableObject,
ILoggable,
ITransformObject {
    protected static final XPath XPATH = XPathFactory.newInstance().newXPath();
    public static final String ID_ELEMENT = "id";
    public static final String URLS = "urls";
    public static final String URL = "url";
    public static final String PATHS = "paths";
    public static final String PATH = "path";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    protected String id = null;
    protected IServiceProvider provider;
    protected IServiceRequestBuilder builder;
    protected URL location = null;
    protected URL defaultLocation = null;
    protected ILogger logger;
    private int lastUpdateStatus = -1;
    protected ServiceErrors lastErrors;

    protected abstract String getItemString();

    @Override
    public URL getDefaultLocation() {
        return this.defaultLocation;
    }

    @Override
    public URL getLocation() {
        if (this.location == null && this.defaultLocation != null) {
            return this.defaultLocation;
        }
        return this.location;
    }

    @Override
    public IServiceRequestBuilder getRequestBuilder() {
        return this.builder;
    }

    @Override
    public IServiceProvider getServiceProvider() {
        return this.provider;
    }

    @Override
    public boolean hasLocation() {
        return this.location != null && !this.location.equals(this.defaultLocation);
    }

    @Override
    public void setDefaultLocation(URL defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    @Override
    public void setLocation(URL location) {
        if (this.isModelChanged(this.location, location)) {
            this.location = location;
            this.fireChange();
        }
    }

    @Override
    public synchronized void fromXML(String xml) {
        try {
            XPath xpath = XPathUtils.getNewXPath();
            Node site = (Node)xpath.evaluate("/" + this.getItemString(), XPathUtils.createSource(xml), XPathConstants.NODE);
            this.fromNode(site);
        }
        catch (XPathExpressionException e1) {
            String message = MessageFormat.format(Messages.getString("CoreModelObject.Error_Building_XML"), this.getLoggingPrefix(), e1.getMessage());
            this.logError(message);
        }
    }

    @Override
    public void setRequestBuilder(IServiceRequestBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void setServiceProvider(IServiceProvider provider) {
        this.provider = provider;
    }

    public abstract String getLoggingPrefix();

    public void performUploadAction(Map<String, String> nameValuePairs) {
        this.performAction(nameValuePairs, "POST");
    }

    public void performUploadAction(String name, String value) {
        this.performAction(name, value, "POST");
    }

    public void performUploadAction(String nameValuePairs) {
        this.performAction(nameValuePairs, "POST");
    }

    public void performUpdateAction(Map<String, String> nameValuePairs) {
        this.performAction(nameValuePairs, "GET");
    }

    public void performUpdateAction(String name, String value) {
        this.performAction(name, value, "GET");
    }

    public void performUpdateAction(String nameValuePairs) {
        this.performAction(nameValuePairs, "GET");
    }

    @Override
    public IServiceErrors performAction(Map<String, String> nameValuePairs, String type) {
        StringBuffer query = new StringBuffer("?");
        if (nameValuePairs != null) {
            for (String name : nameValuePairs.keySet()) {
                String value = nameValuePairs.get(name);
                query.append(name);
                query.append('=');
                query.append(value);
                query.append('&');
            }
        }
        return this.performAction(query.toString(), type);
    }

    @Override
    public IServiceErrors performAction(String name, String value, String type) {
        return this.performAction(String.valueOf(name) + "=" + value, type);
    }

    protected void handleActionResponse(IServiceResponse response) {
    }

    @Override
    public IServiceErrors performAction(String nameValuePairs, String type) {
        ServiceErrors errors = null;
        if (this.hasLocation()) {
            String query = "";
            String baseURL = this.getLocation().toExternalForm();
            if (baseURL.indexOf(63) == -1) {
                if (!nameValuePairs.startsWith("?")) {
                    query = String.valueOf(query) + "?";
                }
            } else {
                query = String.valueOf(query) + "&";
            }
            query = String.valueOf(query) + nameValuePairs;
            try {
                URL actionURL = new URL(String.valueOf(baseURL) + query);
                if (this.provider != null && this.builder != null) {
                    String message;
                    IServiceResponse response = null;
                    IServiceRequest request = this.builder.generateRequest(this, type);
                    if (request != null) {
                        message = MessageFormat.format(Messages.getString("CoreModelObject.Perform_Action_Content"), this.getLoggingPrefix(), request.getContents());
                        this.logInfo(message);
                    } else {
                        message = MessageFormat.format(Messages.getString("CoreModelObject.Null_Request_On_Action"), this.getLoggingPrefix());
                        this.logInfo(message);
                    }
                    response = this.provider.callService(actionURL, request);
                    if (response != null) {
                        String message1 = MessageFormat.format(Messages.getString("CoreModelObject.Perform_Action_Response"), this.getLoggingPrefix(), response.getContents());
                        String message2 = MessageFormat.format(Messages.getString("CoreModelObject.Perform_Action_Status"), this.getLoggingPrefix(), response.getStatus());
                        this.logInfo(message1);
                        this.logInfo(message2);
                        errors = new ServiceErrors();
                        errors.setStatus(response.getStatus());
                        if (response.getStatus() != 200 && response.getStatus() != -200) {
                            errors.fromXML(response.getContents());
                        }
                        this.handleActionResponse(response);
                    }
                }
            }
            catch (MalformedURLException e) {
                String message = MessageFormat.format(Messages.getString("CoreModelObject.Error_Creating_URL"), e.getMessage());
                this.logError(message);
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    protected void logInfo(String message) {
        if (this.logger != null) {
            this.logger.logInfo(message);
        }
    }

    protected void logError(String message) {
        if (this.logger != null) {
            this.logger.logError(message);
        }
    }

    protected void logError(String message, Throwable th) {
        if (this.logger != null) {
            this.logger.logError(message, th);
        }
    }

    protected void logWarning(String message) {
        if (this.logger != null) {
            this.logger.logWarning(message);
        }
    }

    @Override
    public IServiceErrors commit() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            String message;
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "PUT");
            if (request != null) {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Commit_Content"), this.getLoggingPrefix(), StringUtils.getPublishableMessage(request.getContents()));
                this.logInfo(message);
            } else {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Null_Request_On_Commit"), this.getLoggingPrefix());
                this.logInfo(message);
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                String message1 = MessageFormat.format(Messages.getString("CoreModelObject.Commit_Response"), this.getLoggingPrefix(), response.getContents());
                String message2 = MessageFormat.format(Messages.getString("CoreModelObject.Commit_Reponse_Status"), this.getLoggingPrefix(), response.getStatus());
                this.logInfo(message1);
                this.logInfo(message2);
                if (response.getStatus() == 201 && response.getData() instanceof URL) {
                    this.setLocation((URL)response.getData());
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.setContents(response.getContents());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                    if (response.getStatus() == 200) {
                        this.fireChange();
                    }
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    public IServiceErrors xmlRest(String method) {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            String message;
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, method);
            if (request != null) {
                message = MessageFormat.format(Messages.getString("CoreModelObject.REST_Content"), this.getLoggingPrefix(), request.getContents());
                this.logInfo(message);
            } else {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Null_Request_On_XML_REST"), this.getLoggingPrefix());
                this.logInfo(message);
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                String message1 = MessageFormat.format(Messages.getString("CoreModelObject.XML_REST_Response"), this.getLoggingPrefix(), response.getContents());
                String message2 = MessageFormat.format(Messages.getString("CoreModelObject.XML_REST_Response_Status"), this.getLoggingPrefix(), response.getStatus());
                this.logInfo(message1);
                this.logInfo(message2);
                if (response.getStatus() == 201 || response.getStatus() == 200 || response.getStatus() == 204) {
                    if (response.getData() instanceof String) {
                        this.fromXML((String)response.getData());
                    } else if (response.getData() instanceof URL) {
                        this.setLocation((URL)response.getData());
                    }
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    public IServiceErrors upload() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            String message;
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "POST");
            if (request != null) {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Upload_Content"), this.getLoggingPrefix(), request.getContents());
                this.logInfo(message);
            } else {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Null_Request_On_Upload"), this.getLoggingPrefix());
                this.logInfo(message);
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                String message1 = MessageFormat.format(Messages.getString("CoreModelObject.Upload_Response"), this.getLoggingPrefix(), response.getContents());
                String message2 = MessageFormat.format(Messages.getString("CoreModelObject.Upload_Response_Status"), this.getLoggingPrefix(), response.getContents());
                this.logInfo(message1);
                this.logInfo(message2);
                if (response.getStatus() == 201 && response.getData() instanceof URL) {
                    this.setLocation((URL)response.getData());
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                    if (response.getStatus() == 200) {
                        this.fireChange();
                    }
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    @Override
    public IServiceErrors delete() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            String message;
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "DELETE");
            if (request != null) {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Delete_Content"), this.getLoggingPrefix(), request.getContents());
                this.logInfo(message);
            } else {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Null_Request_On_Delete_Content"), this.getLoggingPrefix());
                this.logInfo(message);
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                String message1 = MessageFormat.format(Messages.getString("CoreModelObject.Delete_Reponse_Status"), this.getLoggingPrefix(), response.getContents());
                String message2 = MessageFormat.format(Messages.getString("CoreModelObject.Delete_Response"), this.getLoggingPrefix(), response.getContents());
                this.logInfo(message1);
                this.logInfo(message2);
                if (response.getStatus() == 204) {
                    this.setLocation(null);
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    @Override
    public IServiceErrors update() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            String message;
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "GET");
            if (request != null) {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Update_Content"), this.getLoggingPrefix(), request.getContents());
                this.logInfo(message);
            } else {
                message = MessageFormat.format(Messages.getString("CoreModelObject.Null_Request_On_Update"), this.getLoggingPrefix());
                this.logInfo(message);
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                this.lastUpdateStatus = response.getStatus();
                String message1 = MessageFormat.format(Messages.getString("CoreModelObject.Update_Response_Status"), this.getLoggingPrefix(), response.getStatus());
                String message2 = MessageFormat.format(Messages.getString("CoreModelObject.Update_Reponse"), this.getLoggingPrefix(), StringUtils.getPublishableMessage(response.getData()));
                this.logInfo(message1);
                this.logInfo(message2);
                if (response.getStatus() == 200) {
                    if (response.getData() instanceof String) {
                        this.fromXML((String)response.getData());
                    } else if (response.getData() instanceof URL) {
                        this.setLocation((URL)response.getData());
                    }
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public synchronized void clear() {
    }

    public int getLastUpdateStatus() {
        return this.lastUpdateStatus;
    }

    protected String getTextContent(String xpath, Node node) {
        String text = null;
        try {
            Node subNode = (Node)XPATH.evaluate(xpath, node, XPathConstants.NODE);
            if (subNode != null) {
                text = subNode.getTextContent();
            }
        }
        catch (XPathExpressionException e) {
            String message = MessageFormat.format(Messages.getString("CoreModelObject.XPath_Error_While_Parsing"), this.getLoggingPrefix(), e.getMessage());
            this.logError(message);
        }
        return text;
    }

    @Override
    public ServiceErrors getLastServiceErrors() {
        return this.lastErrors;
    }

    public void setLastServiceErrors(ServiceErrors lastErrors) {
        this.lastErrors = lastErrors;
    }
}

