/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.editor.css.CSSContributor;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.ide.editor.html.formatting.HTMLAutoIndentStrategy;
import com.aptana.ide.editor.html.formatting.HTMLBracketInserter;
import com.aptana.ide.editor.html.formatting.HTMLPairTagModifyStrategy;
import com.aptana.ide.editor.js.JSContributor;
import com.aptana.ide.editors.formatting.IUnifiedBracketInserter;
import com.aptana.ide.editors.unified.BaseContributor;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedReconcilingStrategy;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.hover.LexemeTextHover;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;

public class HTMLContributor
extends BaseContributor {
    protected IUnifiedEditorContributor[] childContributors;
    private boolean isDisposing = false;
    private IAutoEditStrategy[] _autoEditStrategy;
    private LexemeTextHover _textHover;
    private LanguageColorizer _colorizer = this._colorizer == null ? null : this._colorizer;
    private IUnifiedBracketInserter _inserter;

    public HTMLContributor() {
        this("text/html");
    }

    public HTMLContributor(String mimeType) {
        super(mimeType);
    }

    public IUnifiedEditorContributor[] getChildContributors() {
        if (this.childContributors == null) {
            JSContributor jsc = new JSContributor();
            CSSContributor cssc = new CSSContributor();
            jsc.setParent((IUnifiedEditorContributor)this);
            cssc.setParent((IUnifiedEditorContributor)this);
            this.childContributors = new IUnifiedEditorContributor[]{jsc, cssc};
        }
        return this.childContributors;
    }

    public ITextHover getLocalTextHover(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/html")) {
            this._textHover = new LexemeTextHover(this.getFileContext());
            return this._textHover;
        }
        return null;
    }

    public IAutoEditStrategy[] getLocalAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/html")) {
            HTMLAutoIndentStrategy autoIndentStrategy = new HTMLAutoIndentStrategy(this.getFileContext(), this.getParentConfiguration(), sourceViewer);
            HTMLPairTagModifyStrategy pairTagModifyStrategy = new HTMLPairTagModifyStrategy(this.getFileContext(), this.getParentConfiguration(), sourceViewer);
            this._autoEditStrategy = new IAutoEditStrategy[]{autoIndentStrategy, pairTagModifyStrategy};
            return this._autoEditStrategy;
        }
        return null;
    }

    public IContentAssistProcessor getLocalContentAssistProcessor(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/html")) {
            EditorFileContext context = this.getFileContext();
            if (context != null) {
                return new HTMLContentAssistProcessor(context);
            }
            return null;
        }
        return null;
    }

    public UnifiedReconcilingStrategy getReconcilingStrategy() {
        return new UnifiedReconcilingStrategy();
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        if (this.childContributors != null) {
            int i = 0;
            while (i < this.childContributors.length) {
                IUnifiedEditorContributor child = this.childContributors[i];
                if (child instanceof BaseContributor) {
                    ((BaseContributor)child).dispose();
                }
                ++i;
            }
        }
        this.childContributors = null;
        if (this._colorizer != null) {
            this._colorizer.dispose();
            this._colorizer = null;
        }
        this._autoEditStrategy = null;
        this._textHover = null;
        this._colorizer = null;
        super.dispose();
    }

    public boolean isAutoActivateContentAssist() {
        return HTMLPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.CODE_ASSIST_AUTO_ACTIVATION");
    }

    public IUnifiedBracketInserter getLocalBracketInserter(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/html")) {
            EditorFileContext context = this.getFileContext();
            if (context != null) {
                this._inserter = new HTMLBracketInserter(sourceViewer, (IFileService)context);
                return this._inserter;
            }
            return null;
        }
        return null;
    }
}

