/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.editors.unified.ChildOffsetMapper;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.Token;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.ICodeLocation;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class HTMLOffsetMapper
extends ChildOffsetMapper {
    public HTMLOffsetMapper(IParentOffsetMapper parent) {
        super(parent);
    }

    public String getNameHash() {
        String name = "";
        int position = this.getCurrentLexemeIndex();
        while (position >= 0) {
            Lexeme curLexeme = this.getLexemeList().get(position);
            if (curLexeme.getText().equals(">")) {
                return "";
            }
            if (curLexeme.typeIndex == 0 && curLexeme.getText().equals("<")) {
                return "";
            }
            if (curLexeme.typeIndex == 41) {
                return curLexeme.getText().replaceAll("<", "");
            }
            --position;
        }
        return name;
    }

    public ICodeLocation findTarget(Lexeme lexeme) {
        if (lexeme.getToken().getLexerGroup().equals("attribute")) {
            LexemeList lexemeList = this.getFileService().getLexemeList();
            int index = this.getLexemeIndexFromDocumentOffset(lexeme.getStartingOffset() + 1);
            if (index < 2) {
                return null;
            }
            Lexeme srcLexeme = lexemeList.get(index - 2);
            if (srcLexeme.getText().equalsIgnoreCase("src")) {
                return this.findFile(lexeme.getText());
            }
            if (srcLexeme.getText().equalsIgnoreCase("href")) {
                return this.findFile(lexeme.getText());
            }
        }
        return null;
    }

    private ICodeLocation findFile(String name) {
        String possiblePath;
        IFile file;
        if (name.startsWith("\"") || name.startsWith("'")) {
            name = name.substring(1);
        }
        if (name.endsWith("\"") || name.endsWith("'")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.startsWith("http:") || name.startsWith("https:") || name.startsWith("ftp:") || name.startsWith("mailto:")) {
            return null;
        }
        Lexeme destLexeme = new Lexeme((IToken)new Token(null), "", 0);
        if (name.startsWith("file:")) {
            return new CodeLocation(name, destLexeme);
        }
        IProject project = this.getProject();
        String docRoot = this.getDocumentRoot(project);
        if (docRoot != null && docRoot.trim().length() > 0 && (file = project.getFile(possiblePath = String.valueOf(docRoot) + '/' + name)).exists()) {
            return new CodeLocation(file.getLocationURI().toString(), destLexeme);
        }
        String pathToCurrent = this.getFileService().getSourceProvider().getSourceURI();
        String parentPath = pathToCurrent.substring(0, pathToCurrent.lastIndexOf(47));
        return new CodeLocation(String.valueOf(parentPath) + '/' + name, destLexeme);
    }

    private String getDocumentRoot(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            return project.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.CONTEXT_ROOT"));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IProject getProject() {
        String leftever;
        Path leftoverPath;
        String firstSegment;
        IProject project;
        IWorkspaceRoot root;
        URI rootURI;
        String rootPath;
        String fileURI = this.getFileService().getSourceProvider().getSourceURI();
        if (fileURI.startsWith("file://")) {
            fileURI = "file:" + fileURI.substring(7);
        }
        if (fileURI.startsWith(rootPath = (rootURI = (root = ResourcesPlugin.getWorkspace().getRoot()).getLocationURI()).toString()) && (project = root.getProject(firstSegment = (leftoverPath = new Path(leftever = fileURI.substring(rootPath.length()))).segment(0))).exists()) {
            return project;
        }
        return null;
    }
}

