/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.IProblem;
import com.aptana.ide.core.builder.Warning;
import com.aptana.ide.editor.html.HTMLBuildParticipant;
import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editor.html.parsing.HTMLUtils;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeAttribute;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowerCaseTagAndAttributeNamesChecker
extends HTMLBuildParticipant {
    public void build(BuildContext context, IProgressMonitor monitor) {
        if (!this.isHTMLFile(context)) {
            return;
        }
        IParseState parseState = context.getParseState();
        if (!(parseState instanceof HTMLParseState)) {
            return;
        }
        HTMLParseState htmlParseState = (HTMLParseState)parseState;
        if (htmlParseState.getDocumentType() < 6) {
            return;
        }
        IParseNode root = context.getRootNode();
        List<IProblem> problems = this.walk(context, root);
        context.recordNewProblems(problems);
    }

    private List<IProblem> walk(BuildContext context, IParseNode root) {
        IParseNode[] children;
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        IParseNode[] iParseNodeArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode node = iParseNodeArray[n2];
            if (node instanceof HTMLElementNode) {
                IParseNodeAttribute[] attributes;
                HTMLElementNode elementNode = (HTMLElementNode)node;
                String name = elementNode.getName();
                if (!name.equals(name.toLowerCase())) {
                    problems.add((IProblem)new Warning(5, context.getFile().getFullPath().toPortableString(), this.getLineNumber(context, (IParseNode)elementNode), elementNode.getStartingOffset(), elementNode.getStartingOffset() + name.length() + 2, "Tagnames must be lowercase in XHTML: '" + name + "'"));
                }
                if ((attributes = elementNode.getAttributes()) != null && attributes.length > 0) {
                    int index = context.getLexemeList().getLexemeIndex(elementNode.getStartingLexeme());
                    Lexeme closeLex = HTMLUtils.getTagCloseLexeme(elementNode.getStartingLexeme(), context.getLexemeList());
                    int endIndex = context.getLexemeList().getLexemeIndex(closeLex);
                    Lexeme[] lexemes = context.getLexemeList().copyRange(index, endIndex);
                    IParseNodeAttribute[] iParseNodeAttributeArray = attributes;
                    int n3 = attributes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IParseNodeAttribute attribute = iParseNodeAttributeArray[n4];
                        String attributeName = attribute.getName();
                        Lexeme match = this.findMatching(lexemes, attributeName);
                        if (match != null && match.getText() != null && !match.getText().equals(attributeName)) {
                            problems.add((IProblem)new Warning(6, context.getFile().getFullPath().toPortableString(), this.getLineNumber(context, match), match.getStartingOffset(), match.getEndingOffset(), "Attribute names must be lowercase in XHTML: '" + match.getText() + "'"));
                        }
                        ++n4;
                    }
                }
            }
            problems.addAll(this.walk(context, node));
            ++n2;
        }
        return problems;
    }

    private Lexeme findMatching(Lexeme[] lexemes, String attributeName) {
        Lexeme[] lexemeArray = lexemes;
        int n = lexemes.length;
        int n2 = 0;
        while (n2 < n) {
            Lexeme lexeme = lexemeArray[n2];
            if (lexeme != null && lexeme.typeIndex == 43 && lexeme.getText() != null && lexeme.getText().equalsIgnoreCase(attributeName)) {
                return lexeme;
            }
            ++n2;
        }
        return null;
    }
}

