/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.Warning;
import com.aptana.ide.editor.html.HTMLBuildParticipant;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class MissingTitleTagBuildParticipant
extends HTMLBuildParticipant {
    public void build(BuildContext context, IProgressMonitor monitor) {
        if (!this.isHTMLFile(context)) {
            return;
        }
        IParseNode root = context.getRootNode();
        if (!this.containsTitleTag(context, root)) {
            ArrayList<Warning> problems = new ArrayList<Warning>();
            problems.add(new Warning(3, context.getFile().getFullPath().toPortableString(), -1, 0, 0, "Missing 'title' tag"));
            context.recordNewProblems(problems);
        }
    }

    private boolean containsTitleTag(BuildContext context, IParseNode root) {
        if (root == null) {
            return false;
        }
        IParseNode[] children = root.getChildren();
        if (children == null) {
            return false;
        }
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            boolean containsTitleTag;
            IParseNode node = iParseNodeArray[n2];
            if (node instanceof HTMLElementNode) {
                HTMLElementNode elementNode = (HTMLElementNode)node;
                String name = elementNode.getName();
                if (name.equalsIgnoreCase("title")) {
                    return true;
                }
                if (name.equalsIgnoreCase("body")) {
                    return false;
                }
            }
            if (containsTitleTag = this.containsTitleTag(context, node)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

