/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.html.BrowserExtensionLoader;
import com.aptana.ide.editor.html.HTMLEditor;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.HTMLSourceEditor;
import com.aptana.ide.editor.html.IHTMLEditorPart;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.html.preview.BasePreviewConfigurationPage;
import com.aptana.ide.editor.html.preview.ContributedPreviewPage;
import com.aptana.ide.editor.html.preview.DefaultPreviewConfigurationPage;
import com.aptana.ide.editor.html.preview.IBrowserTabAdder;
import com.aptana.ide.editor.html.preview.IPreviewConfigurationPage;
import com.aptana.ide.editor.html.preview.PreviewConfigurationPage;
import com.aptana.ide.editor.html.preview.PreviewTabManager;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.ContributedOutline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IElementStateListener;

public class MultiPageHTMLEditor
extends MultiPageEditorPart
implements IHTMLEditorPart {
    private HTMLSourceEditor editor;
    private IEditorInput _page0;
    private HTMLEditor wrapper;
    private boolean isDisposing = false;
    private SourceEditorSite _siteEditor;
    private boolean addPreviewCapable = true;
    private boolean removePreviewCapable = true;
    private boolean editPreviewCapable = true;
    private ToolItem addToolItem;
    private MenuItem addMenuItem;
    private ToolItem removeToolItem;
    private MenuItem removeMenuItem;
    private ToolItem editToolItem;
    private MenuItem editMenuItem;
    private ToolItem refreshToolItem;
    private MenuItem refreshMenuItem;
    private MenuItem copyURLMenuItem;
    private MenuItem openInBrowserMenuItem;
    private MenuItem viewSourceMenuItem;
    private IElementStateListener elementListener = new IElementStateListener(){

        public void elementMoved(Object originalElement, Object movedElement) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementDeleted(Object element) {
            if (element.equals(MultiPageHTMLEditor.this.getEditorInput())) {
                IWorkbenchPartSite site = MultiPageHTMLEditor.this.getSite();
                if (site == null) {
                    return;
                }
                IWorkbenchWindow window = site.getWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                page.closeEditor((IEditorPart)MultiPageHTMLEditor.this, true);
            }
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            IEditorInput newInput;
            if (propId == 258 && source instanceof HTMLSourceEditor && (newInput = ((HTMLSourceEditor)((Object)source)).getEditorInput()) != null) {
                MultiPageHTMLEditor.this.setInput(newInput);
                MultiPageHTMLEditor.this.setPartName(newInput.getName());
                MultiPageHTMLEditor.this.setTitleToolTip(newInput.getToolTipText());
                MultiPageHTMLEditor.this.updateSourceTabTooltip();
            }
        }
    };
    private Map<String, IPreviewConfigurationPage> previews = new TreeMap<String, IPreviewConfigurationPage>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int i1 = Integer.parseInt(o1);
            int i2 = Integer.parseInt(o2);
            return i1 - i2;
        }
    });
    private String url;

    public MultiPageHTMLEditor(HTMLEditor wrapper, HTMLSourceEditor editor) {
        if (wrapper == null) {
            throw new IllegalArgumentException(Messages.MultiPageHTMLEditor_WrapperCannotBeNull);
        }
        if (editor == null) {
            throw new IllegalArgumentException(Messages.MultiPageHTMLEditor_EditorCannotBeNull);
        }
        this.wrapper = wrapper;
        this.editor = editor;
    }

    public boolean isAddPreviewCapable() {
        return this.addPreviewCapable;
    }

    public void setAddPreviewCapable(boolean addPreviewCapable) {
        this.addPreviewCapable = addPreviewCapable;
    }

    public boolean isRemovePreviewCapable() {
        return this.removePreviewCapable;
    }

    public void setRemovePreviewCapable(boolean removePreviewCapable) {
        this.removePreviewCapable = removePreviewCapable;
    }

    public boolean isEditPreviewCapable() {
        return this.editPreviewCapable;
    }

    public void setEditPreviewCapable(boolean editPreviewCapable) {
        this.editPreviewCapable = editPreviewCapable;
    }

    public boolean run(String actionID) {
        if (("org.eclipse.ui.edit.cut".equals(actionID) || "org.eclipse.ui.edit.paste".equals(actionID) || "org.eclipse.ui.edit.copy".equals(actionID)) && this.getActivePage() != 0) {
            IPreviewConfigurationPage page = this.previews.get(Integer.toString(this.getActivePage()));
            return page.run(actionID);
        }
        return false;
    }

    public Browser getBrowser2() {
        return null;
    }

    public HTMLSourceEditor getSourceEditor() {
        return this.editor;
    }

    protected IEditorSite createSite(IEditorPart editor) {
        this._siteEditor = new SourceEditorSite(this, editor, this.getEditorSite());
        return this._siteEditor;
    }

    private void updateSourceTabTooltip() {
        if (this.getContainer() instanceof CTabFolder && !this.getContainer().isDisposed()) {
            IPath location;
            IFile file;
            CTabFolder tabs = (CTabFolder)this.getContainer();
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null && (location = file.getLocation()) != null && !CoreUIUtils.onMacOSX) {
                tabs.getItem(0).setToolTipText(location.makeAbsolute().toOSString());
            }
        }
    }

    private void createPage0() {
        try {
            this._page0 = this.getEditorInput();
            int index = this.addPage((IEditorPart)this.editor, this._page0);
            this.setPageText(index, " Source ");
            this.setPartName(this.getEditorInput().getName());
            this.updateSourceTabTooltip();
            this.editor.addPropertyListener(this.propertyListener);
            this.editor.getDocumentProvider().addElementStateListener(this.elementListener);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void createRefreshTabOption(ToolBar tb, Menu popupMenu) {
        this.refreshToolItem = new ToolItem(tb, 8);
        this.refreshToolItem.setImage(HTMLPlugin.getImage("icons/refresh.gif"));
        this.refreshToolItem.setToolTipText(Messages.MultiPageHTMLEditor_RefreshActivePreview);
        SelectionAdapter addSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String active = Integer.toString(MultiPageHTMLEditor.this.getActivePage());
                if (MultiPageHTMLEditor.this.previews.containsKey(active)) {
                    IPreviewConfigurationPage page = (IPreviewConfigurationPage)MultiPageHTMLEditor.this.previews.get(active);
                    if (MultiPageHTMLEditor.this.getContainer() instanceof CTabFolder) {
                        CTabFolder tabs = (CTabFolder)MultiPageHTMLEditor.this.getContainer();
                        if (page instanceof DefaultPreviewConfigurationPage) {
                            tabs.getItem(Integer.parseInt(active)).setImage(null);
                        } else if (page.getTabImage() != null) {
                            tabs.getItem(Integer.parseInt(active)).setImage(page.getTabImage());
                        } else {
                            tabs.getItem(Integer.parseInt(active)).setImage(HTMLPlugin.getImage("icons/add_tab_decorator.png"));
                        }
                    }
                    page.refresh();
                }
            }
        };
        this.refreshToolItem.addSelectionListener((SelectionListener)addSelectionAdapter);
        this.refreshToolItem.setEnabled(false);
        this.refreshMenuItem = new MenuItem(popupMenu, 8);
        this.refreshMenuItem.addSelectionListener((SelectionListener)addSelectionAdapter);
        this.refreshMenuItem.setText(Messages.MultiPageHTMLEditor_RefreshActivePreview);
        this.refreshMenuItem.setImage(HTMLPlugin.getImage("icons/refresh.gif"));
        this.refreshMenuItem.setEnabled(false);
    }

    private void createAddTabOption(ToolBar tb, Menu popupMenu) {
        this.addToolItem = new ToolItem(tb, 8);
        this.addToolItem.setImage(HTMLPlugin.getImage("icons/add_tab.gif"));
        this.addToolItem.setToolTipText(Messages.MultiPageHTMLEditor_AddNewPreview);
        SelectionAdapter addSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewConfigurationPage page = new PreviewConfigurationPage(MultiPageHTMLEditor.this);
                page.setType("com.aptana.ide.editor.html.preview.FILE_BASED_TYPE");
                page.setValue(null);
                page.createControl(MultiPageHTMLEditor.this.getContainer());
                int index = MultiPageHTMLEditor.this.addPage(page.getControl());
                Composite container = MultiPageHTMLEditor.this.getContainer();
                if (container instanceof CTabFolder) {
                    ((CTabFolder)container).getItem(index).setImage(HTMLPlugin.getImage("icons/add_tab_decorator.png"));
                }
                MultiPageHTMLEditor.this.previews.put(Integer.toString(index), page);
                page.setIndex(index);
                page.setTitle(page.generateNewPreviewName());
                MultiPageHTMLEditor.this.setPageText(index, " " + page.getTitle() + " ");
                MultiPageHTMLEditor.this.setActivePage(index);
                page.showEditArea();
                if (MultiPageHTMLEditor.this.isEditPreviewCapable()) {
                    MultiPageHTMLEditor.this.editToolItem.setEnabled(true);
                    MultiPageHTMLEditor.this.editMenuItem.setEnabled(true);
                }
                if (MultiPageHTMLEditor.this.isRemovePreviewCapable()) {
                    MultiPageHTMLEditor.this.removeToolItem.setEnabled(true);
                    MultiPageHTMLEditor.this.removeMenuItem.setEnabled(true);
                }
            }
        };
        this.addToolItem.addSelectionListener((SelectionListener)addSelectionAdapter);
        this.addMenuItem = new MenuItem(popupMenu, 8);
        this.addMenuItem.addSelectionListener((SelectionListener)addSelectionAdapter);
        this.addMenuItem.setText(Messages.MultiPageHTMLEditor_AddNewPreview);
        this.addMenuItem.setImage(HTMLPlugin.getImage("icons/add_tab.gif"));
    }

    private void createEditTabOption(ToolBar tb, Menu popupMenu) {
        this.editToolItem = new ToolItem(tb, 8);
        this.editToolItem.setImage(HTMLPlugin.getImage("icons/edit.png"));
        this.editToolItem.setToolTipText(Messages.MultiPageHTMLEditor_EditActivePreview);
        SelectionAdapter editSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String active = Integer.toString(MultiPageHTMLEditor.this.getActivePage());
                if (MultiPageHTMLEditor.this.previews.containsKey(active)) {
                    IPreviewConfigurationPage page = (IPreviewConfigurationPage)MultiPageHTMLEditor.this.previews.get(active);
                    if (page instanceof DefaultPreviewConfigurationPage) {
                        if (MultiPageHTMLEditor.this.getEditorInput() instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)MultiPageHTMLEditor.this.getEditorInput()).getFile();
                            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)Display.getDefault().getActiveShell(), (IAdaptable)file.getProject(), (String)"com.aptana.ide.editor.html.preview.htmlPreviewPropertyPage", (String[])new String[]{"com.aptana.ide.editor.html.preview.htmlPreviewPropertyPage"}, null);
                            dialog.open();
                        } else {
                            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.html.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.html.preferences.PreviewPreferencePage"}, null);
                            dialog.open();
                        }
                    } else if (!page.isReadOnly()) {
                        page.showEditArea();
                    }
                }
            }
        };
        this.editToolItem.addSelectionListener((SelectionListener)editSelectionAdapter);
        this.editToolItem.setEnabled(false);
        this.editMenuItem = new MenuItem(popupMenu, 8);
        this.editMenuItem.addSelectionListener((SelectionListener)editSelectionAdapter);
        this.editMenuItem.setImage(HTMLPlugin.getImage("icons/edit.png"));
        this.editMenuItem.setText(Messages.MultiPageHTMLEditor_EditActivePreview);
        this.editMenuItem.setEnabled(false);
    }

    private void createRemoveTabOption(ToolBar tb, Menu popupMenu) {
        this.removeToolItem = new ToolItem(tb, 8);
        this.removeToolItem.setImage(HTMLPlugin.getImage("icons/delete.gif"));
        this.removeToolItem.setToolTipText(Messages.MultiPageHTMLEditor_RemoveActivePreview);
        SelectionAdapter removeSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pageIndex = MultiPageHTMLEditor.this.getActivePage();
                String active = Integer.toString(pageIndex);
                MultiPageHTMLEditor.this.previews.remove(active);
                int i = pageIndex + 1;
                while (i < MultiPageHTMLEditor.this.getPageCount()) {
                    if (MultiPageHTMLEditor.this.previews.containsKey(Integer.toString(i))) {
                        IPreviewConfigurationPage obj = (IPreviewConfigurationPage)MultiPageHTMLEditor.this.previews.remove(Integer.toString(i));
                        MultiPageHTMLEditor.this.previews.put(Integer.toString(i - 1), obj);
                    }
                    ++i;
                }
                MultiPageHTMLEditor.this.removePage(pageIndex);
                MultiPageHTMLEditor.this.savePreviewsPages();
            }
        };
        this.removeToolItem.addSelectionListener((SelectionListener)removeSelectionAdapter);
        this.removeToolItem.setEnabled(false);
        this.removeMenuItem = new MenuItem(popupMenu, 8);
        this.removeMenuItem.addSelectionListener((SelectionListener)removeSelectionAdapter);
        this.removeMenuItem.setImage(HTMLPlugin.getImage("icons/delete.gif"));
        this.removeMenuItem.setText(Messages.MultiPageHTMLEditor_RemoveActivePreview);
        this.removeMenuItem.setEnabled(false);
    }

    private void createCopyURLTabOption(Menu popupMenu) {
        SelectionAdapter copySelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String active = Integer.toString(MultiPageHTMLEditor.this.getActivePage());
                if (MultiPageHTMLEditor.this.previews.containsKey(active)) {
                    IPreviewConfigurationPage page = (IPreviewConfigurationPage)MultiPageHTMLEditor.this.previews.get(active);
                    Clipboard cb = new Clipboard(e.display);
                    cb.setContents(new Object[]{page.getURL()}, new Transfer[]{TextTransfer.getInstance()});
                    cb.dispose();
                }
            }
        };
        this.copyURLMenuItem = new MenuItem(popupMenu, 8);
        this.copyURLMenuItem.addSelectionListener((SelectionListener)copySelectionAdapter);
        this.copyURLMenuItem.setImage(HTMLPlugin.getImage("icons/copy_edit.gif"));
        this.copyURLMenuItem.setText(Messages.MultiPageHTMLEditor_CopyPreviewURL);
        this.copyURLMenuItem.setEnabled(false);
    }

    private void createOpenInBrowserTabOption(Menu popupMenu) {
        SelectionAdapter openSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String active = Integer.toString(MultiPageHTMLEditor.this.getActivePage());
                if (MultiPageHTMLEditor.this.previews.containsKey(active)) {
                    IPreviewConfigurationPage page = (IPreviewConfigurationPage)MultiPageHTMLEditor.this.previews.get(active);
                    CoreUIUtils.openBrowserURL((String)page.getURL());
                }
            }
        };
        this.openInBrowserMenuItem = new MenuItem(popupMenu, 8);
        this.openInBrowserMenuItem.addSelectionListener((SelectionListener)openSelectionAdapter);
        this.openInBrowserMenuItem.setText(Messages.MultiPageHTMLEditor_OpenInExternalBrowser);
        this.openInBrowserMenuItem.setEnabled(false);
    }

    private void createViewSourceTabOption(Menu popupMenu) {
        SelectionAdapter viewSourceAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String active = Integer.toString(MultiPageHTMLEditor.this.getActivePage());
                if (MultiPageHTMLEditor.this.previews.containsKey(active)) {
                    IPreviewConfigurationPage page = (IPreviewConfigurationPage)MultiPageHTMLEditor.this.previews.get(active);
                    page.viewSource();
                }
            }
        };
        this.viewSourceMenuItem = new MenuItem(popupMenu, 8);
        this.viewSourceMenuItem.addSelectionListener((SelectionListener)viewSourceAdapter);
        this.viewSourceMenuItem.setText(Messages.MultiPageHTMLEditor_LBL_ViewSource);
        this.viewSourceMenuItem.setEnabled(false);
    }

    public int getActivePage() {
        return super.getActivePage();
    }

    protected void createPages() {
        if (this.getContainer() instanceof CTabFolder) {
            CTabFolder tabs = (CTabFolder)this.getContainer();
            MultiPageHTMLEditor.registerTabItemTraversal(this.getSite(), tabs);
            Menu popupMenu = new Menu((Control)tabs);
            Composite toolbar = new Composite((Composite)tabs, 0);
            toolbar.setLayoutData((Object)new GridData(4, 1, true, false));
            GridLayout layout = new GridLayout(2, false);
            ToolBar tb = new ToolBar(toolbar, 0x800000);
            tb.setMenu(popupMenu);
            tabs.setTabHeight(21);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            toolbar.setLayout((Layout)layout);
            tb.setLayout((Layout)layout);
            tb.setLayoutData((Object)new GridData(4, 4, true, false));
            if (this.isAddPreviewCapable()) {
                this.createAddTabOption(tb, popupMenu);
            }
            if (this.isEditPreviewCapable()) {
                this.createEditTabOption(tb, popupMenu);
            }
            if (this.isRemovePreviewCapable()) {
                this.createRemoveTabOption(tb, popupMenu);
            }
            this.createRefreshTabOption(tb, popupMenu);
            this.createCopyURLTabOption(popupMenu);
            this.createOpenInBrowserTabOption(popupMenu);
            this.createViewSourceTabOption(popupMenu);
            tabs.setMenu(popupMenu);
            tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String active = Integer.toString(MultiPageHTMLEditor.this.getActivePage());
                    if (MultiPageHTMLEditor.this.previews.containsKey(active)) {
                        IPreviewConfigurationPage page = (IPreviewConfigurationPage)MultiPageHTMLEditor.this.previews.get(active);
                        if (MultiPageHTMLEditor.this.isRemovePreviewCapable()) {
                            MultiPageHTMLEditor.this.removeToolItem.setEnabled(page.isDeletable());
                            MultiPageHTMLEditor.this.removeMenuItem.setEnabled(page.isDeletable());
                        }
                        if (MultiPageHTMLEditor.this.isEditPreviewCapable()) {
                            MultiPageHTMLEditor.this.editToolItem.setEnabled(page instanceof DefaultPreviewConfigurationPage || !page.isReadOnly());
                            MultiPageHTMLEditor.this.editMenuItem.setEnabled(true);
                        }
                        MultiPageHTMLEditor.this.copyURLMenuItem.setEnabled(true);
                        MultiPageHTMLEditor.this.openInBrowserMenuItem.setEnabled(true);
                        MultiPageHTMLEditor.this.viewSourceMenuItem.setEnabled(true);
                        MultiPageHTMLEditor.this.refreshMenuItem.setEnabled(true);
                        MultiPageHTMLEditor.this.refreshToolItem.setEnabled(true);
                    } else {
                        MultiPageHTMLEditor.this.viewSourceMenuItem.setEnabled(false);
                        if (MultiPageHTMLEditor.this.isRemovePreviewCapable()) {
                            MultiPageHTMLEditor.this.removeToolItem.setEnabled(false);
                            MultiPageHTMLEditor.this.removeMenuItem.setEnabled(false);
                        }
                        if (MultiPageHTMLEditor.this.isEditPreviewCapable()) {
                            MultiPageHTMLEditor.this.editToolItem.setEnabled(false);
                            MultiPageHTMLEditor.this.editMenuItem.setEnabled(false);
                        }
                        MultiPageHTMLEditor.this.copyURLMenuItem.setEnabled(false);
                        MultiPageHTMLEditor.this.openInBrowserMenuItem.setEnabled(false);
                        MultiPageHTMLEditor.this.refreshMenuItem.setEnabled(false);
                        MultiPageHTMLEditor.this.refreshToolItem.setEnabled(false);
                    }
                }
            });
            Composite config = new Composite(toolbar, 0);
            config.setLayoutData((Object)new GridData(4, 4, false, false));
            layout = new GridLayout(1, false);
            final ToolBar configTb = new ToolBar(config, 0x800000);
            GridData tbData = new GridData(128);
            configTb.setLayoutData((Object)tbData);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            config.setLayout((Layout)layout);
            configTb.setLayout((Layout)layout);
            final ToolItem configure = new ToolItem(configTb, 4);
            configure.setImage(CSSPlugin.getImage((String)"icons/configure.gif"));
            configure.setToolTipText(Messages.MultiPageHTMLEditor_ConfigureHTMLPreview);
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail != 4) {
                        if (MultiPageHTMLEditor.this.getEditorInput() instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)MultiPageHTMLEditor.this.getEditorInput()).getFile();
                            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)Display.getDefault().getActiveShell(), (IAdaptable)file.getProject(), (String)"com.aptana.ide.editor.html.preview.htmlPreviewPropertyPage", (String[])new String[]{"com.aptana.ide.editor.html.preview.htmlPreviewPropertyPage"}, null);
                            dialog.open();
                        } else {
                            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.html.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.html.preferences.PreviewPreferencePage"}, null);
                            dialog.open();
                        }
                    }
                }
            });
            final Menu menu = new Menu((Decorations)tabs.getShell(), 8);
            if (this.getEditorInput() instanceof IFileEditorInput) {
                MenuItem editProjectSettings = new MenuItem(menu, 8);
                editProjectSettings.setText(Messages.MultiPageHTMLEditor_ProjectPreviewSettings);
                editProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (MultiPageHTMLEditor.this.getEditorInput() instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)MultiPageHTMLEditor.this.getEditorInput()).getFile();
                            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)Display.getDefault().getActiveShell(), (IAdaptable)file.getProject(), (String)"com.aptana.ide.editor.html.preview.htmlPreviewPropertyPage", (String[])new String[]{"com.aptana.ide.editor.html.preview.htmlPreviewPropertyPage"}, null);
                            dialog.open();
                        }
                    }
                });
            }
            MenuItem editWorkspaceSettings = new MenuItem(menu, 8);
            editWorkspaceSettings.setText(Messages.MultiPageHTMLEditor_WorkspacePreviewSettings);
            editWorkspaceSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.html.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.html.preferences.PreviewPreferencePage"}, null);
                    dialog.open();
                }
            });
            MenuItem restoreDefaults = new MenuItem(menu, 8);
            restoreDefaults.setImage(HTMLPlugin.getImage("icons/restore_defaults.gif"));
            restoreDefaults.setText(Messages.MultiPageHTMLEditor_RestoreTabDefaults);
            restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    while (MultiPageHTMLEditor.this.getPageCount() > 1) {
                        MultiPageHTMLEditor.this.removePage(1);
                    }
                    IEditorInput input = MultiPageHTMLEditor.this.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)input).getFile();
                        try {
                            file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_BROWSERS"), "");
                            file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_URLS"), "");
                            file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_NAMES"), "");
                        }
                        catch (CoreException e1) {
                            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)"Error saving preview page add-ons", (Throwable)e1);
                        }
                    }
                    MultiPageHTMLEditor.this.previews.clear();
                    MultiPageHTMLEditor.this.loadPreviewPages();
                    MultiPageHTMLEditor.this.savePreviewsPages();
                }
            });
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        Rectangle rect = configure.getBounds();
                        Point pt = new Point(rect.x, rect.y + rect.height);
                        pt = configTb.toDisplay(pt);
                        menu.setLocation(pt.x, pt.y);
                        menu.setVisible(true);
                    }
                }
            });
            tabs.setTopRight((Control)toolbar, 4);
        }
        this.createPage0();
        UIJob job = new UIJob(Messages.MultiPageHTMLEditor_Job_LoadingPreview){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MultiPageHTMLEditor.this.loadPreviewPages();
                MultiPageHTMLEditor.this.wrapper.updatePreview();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(30);
        job.schedule();
    }

    private static void registerTabItemTraversal(IWorkbenchPartSite site, CTabFolder tabs) {
        ICommandService cfr_ignored_0 = (ICommandService)site.getService(ICommandService.class);
        IHandlerService cfr_ignored_1 = (IHandlerService)site.getService(IHandlerService.class);
        IBindingService cfr_ignored_2 = (IBindingService)site.getService(IBindingService.class);
        IContextService cfr_ignored_3 = (IContextService)site.getService(IContextService.class);
    }

    private void showFirefoxSafariConflictMessage() {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.MultiPageHTMLEditor_EmbeddedFirefoxLoadingIssue, (String)Messages.MultiPageHTMLEditor_FirefoxBrowserCantBeFirst);
    }

    private void showFirefoxSafariConflictMessageDuringSave(IPreviewConfigurationPage page) {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.MultiPageHTMLEditor_EmbeddedFirefoxLoadingIssue, (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_FirefoxBrowserCantBeFirstSave, (String)page.getTitle()));
    }

    private void loadPreviewPages() {
        block44: {
            Object ol;
            int index;
            Object outlineClass;
            IFile file;
            List<IConfigurationElement> browserList;
            block43: {
                browserList = null;
                file = null;
                if (this.getEditorInput() instanceof FileEditorInput) {
                    file = ((FileEditorInput)this.getEditorInput()).getFile();
                    try {
                        String override = file.getProject().getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE"));
                        if ("true".equals(override)) {
                            String browserString = file.getProject().getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE"));
                            if (browserString == null) {
                                browserString = "";
                            }
                            String[] browsers_names = browserString.split(",");
                            browserList = BrowserExtensionLoader.getBrowsers(browsers_names);
                            Collections.sort(browserList, new Comparator<IConfigurationElement>(){

                                @Override
                                public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                                    String name1 = BrowserExtensionLoader.getBrowserLabel(o1);
                                    String name2 = BrowserExtensionLoader.getBrowserLabel(o2);
                                    int compare = 0;
                                    if (name1 != null && name2 != null) {
                                        if (CoreUIUtils.onMacOSX) {
                                            return name2.compareTo(name1);
                                        }
                                        compare = name1.compareTo(name2);
                                    }
                                    return compare;
                                }
                            });
                            break block43;
                        }
                        browserList = BrowserExtensionLoader.loadBrowsers();
                    }
                    catch (CoreException coreException) {
                        browserList = BrowserExtensionLoader.loadBrowsers();
                    }
                } else {
                    browserList = BrowserExtensionLoader.loadBrowsers();
                }
            }
            int j = 0;
            while (j < browserList.size()) {
                IConfigurationElement element = browserList.get(j);
                String name = BrowserExtensionLoader.getBrowserLabel(element);
                IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_LoadingPreview, (String)name));
                outlineClass = element.getAttribute("outline");
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof ContributedBrowser) {
                        ContributedBrowser browser = (ContributedBrowser)obj;
                        if (CoreUIUtils.onMacOSX && j == 0 && browser.getBrowserType().indexOf("Firefox") != -1) {
                            this.showFirefoxSafariConflictMessage();
                            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_SkippingTab, (String)name));
                        } else {
                            DefaultPreviewConfigurationPage page = new DefaultPreviewConfigurationPage(this);
                            page.setTitle(name);
                            page.createControl(this.getContainer());
                            page.setBrowser(browser, name);
                            page.showBrowserArea();
                            index = this.addPage(page.getControl());
                            this.previews.put(Integer.toString(index), page);
                            page.setIndex(index);
                            this.setPageText(index, " " + page.getTitle() + " ");
                            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_LoadedPreview, (String)name));
                            if (outlineClass != null && (ol = element.createExecutableExtension("outline")) instanceof ContributedOutline) {
                                ContributedOutline outline = (ContributedOutline)ol;
                                browser.setOutline(outline);
                                outline.setBrowser(browser);
                                this.editor.getOutlinePage().addOutline(outline, name);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_UnableToCreateBrowserControl, (String)name), (Throwable)e);
                }
                catch (Error e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_UnableToCreateBrowserControl, (String)name), (Throwable)e);
                }
                ++j;
            }
            outlineClass = PreviewTabManager.getManager().getTabAdders();
            int name = ((IBrowserTabAdder[])outlineClass).length;
            int element = 0;
            while (element < name) {
                IBrowserTabAdder adder = outlineClass[element];
                try {
                    IPreviewConfigurationPage[] pages = adder.getAddOnTabs(this, this.getContainer());
                    if (pages != null) {
                        ol = pages;
                        index = pages.length;
                        int page = 0;
                        while (page < index) {
                            IPreviewConfigurationPage page2 = ol[page];
                            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_LoadingFromExt, (String)page2.getTitle()));
                            this.addPreviewTab(page2);
                            ++page;
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.MultiPageHTMLEditor_ERR_CreateTab, (Throwable)e);
                }
                catch (Error e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.MultiPageHTMLEditor_ERR_CreateTab, (Throwable)e);
                }
                ++element;
            }
            outlineClass = PreviewTabManager.getManager().getStaticTabs();
            name = ((ContributedPreviewPage[])outlineClass).length;
            element = 0;
            while (element < name) {
                Object page = outlineClass[element];
                IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_LoadingStaticContent, (String)((BasePreviewConfigurationPage)page).getTitle()));
                ((ContributedPreviewPage)page).setEditor(this);
                ((ContributedPreviewPage)page).createControl(this.getContainer());
                ((ContributedPreviewPage)page).showBrowserArea();
                int index2 = this.addPage(((ContributedPreviewPage)page).getControl());
                this.previews.put(Integer.toString(index2), (IPreviewConfigurationPage)page);
                ((BasePreviewConfigurationPage)page).setIndex(index2);
                Composite container = this.getContainer();
                if (container instanceof CTabFolder) {
                    if (((BasePreviewConfigurationPage)page).getTabImage() != null) {
                        ((CTabFolder)container).getItem(index2).setImage(((BasePreviewConfigurationPage)page).getTabImage());
                    } else {
                        ((CTabFolder)container).getItem(index2).setImage(HTMLPlugin.getImage("icons/add_tab_decorator.png"));
                    }
                }
                this.setPageText(index2, " " + ((BasePreviewConfigurationPage)page).getTitle() + " ");
                IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_LoadedStaticContent, (String)((BasePreviewConfigurationPage)page).getTitle()));
                ++element;
            }
            if (file != null) {
                try {
                    String addOnBrowsers = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_BROWSERS"));
                    String addOnURLs = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_URLS"));
                    String addOnNames = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_NAMES"));
                    String addOnTypes = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE"));
                    String addOnServers = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_SERVER_ID"));
                    String addOnConfigs = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_CONFIG_ID"));
                    if (addOnBrowsers == null || addOnURLs == null || addOnNames == null || addOnTypes == null || addOnServers == null || addOnConfigs == null) break block44;
                    String[] browsers = addOnBrowsers.split("___PREFERENCE___");
                    String[] names = addOnNames.split("___PREFERENCE___");
                    String[] types = addOnTypes.split("___PREFERENCE___");
                    String[] servers = addOnServers.split("___PREFERENCE___");
                    String[] configs = addOnConfigs.split("___PREFERENCE___");
                    String[] urls = addOnURLs.split("___PREFERENCE___");
                    if (browsers.length != names.length || browsers.length != urls.length || browsers.length != servers.length || browsers.length != configs.length || browsers.length != types.length) break block44;
                    browserList = BrowserExtensionLoader.getBrowsers(browsers);
                    int i = 0;
                    while (i < browsers.length) {
                        String name2 = names[i];
                        String browser = browsers[i];
                        String type = types[i];
                        String value = null;
                        if ("com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE".equals(type)) {
                            value = configs[i];
                        } else if ("com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE".equals(type) || "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(type)) {
                            value = servers[i];
                        } else if ("com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE".equals(type) || "com.aptana.ide.editor.html.preview.APPENDED_ABSOLUTE_BASED_TYPE".equals(type)) {
                            value = urls[i];
                        }
                        IConfigurationElement element2 = null;
                        int j2 = 0;
                        while (j2 < browserList.size()) {
                            IConfigurationElement curr = browserList.get(j2);
                            String browserName = BrowserExtensionLoader.getBrowserLabel(curr);
                            if (browser != null && browser.equals(browserName)) {
                                element2 = curr;
                                break;
                            }
                            ++j2;
                        }
                        if (element2 != null) {
                            try {
                                Object obj = element2.createExecutableExtension("class");
                                if (obj instanceof ContributedBrowser) {
                                    ContributedBrowser cb = (ContributedBrowser)obj;
                                    if (this.getPageCount() == 1 && CoreUIUtils.onMacOSX && i == 0 && cb.getBrowserType().indexOf("Firefox") != -1) {
                                        this.showFirefoxSafariConflictMessage();
                                    } else {
                                        PreviewConfigurationPage page = new PreviewConfigurationPage(this);
                                        IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_LoadingFile, (String)page.getTitle()));
                                        page.setType(type);
                                        page.setValue(value);
                                        page.setTitle(name2);
                                        page.createControl(this.getContainer());
                                        page.setBrowser(cb, browser);
                                        page.showBrowserArea();
                                        int index3 = this.addPage(page.getControl());
                                        Composite container = this.getContainer();
                                        if (container instanceof CTabFolder) {
                                            ((CTabFolder)container).getItem(index3).setImage(HTMLPlugin.getImage("icons/add_tab_decorator.png"));
                                        }
                                        this.previews.put(Integer.toString(index3), page);
                                        page.setIndex(index3);
                                        this.setPageText(index3, String.valueOf(page.getTitle()) + " ");
                                        IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_LoadedFile, (String)page.getTitle()));
                                    }
                                }
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_UnableToCreateBrowserControl, (String)name2), (Throwable)e);
                            }
                            catch (Error e) {
                                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_UnableToCreateBrowserControl, (String)name2), (Throwable)e);
                            }
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.MultiPageHTMLEditor_ERR_CreateFileTab, (Throwable)e);
                }
            }
        }
    }

    public void addPreviewTab(IPreviewConfigurationPage page) {
        if (page != null) {
            int index = this.addPage(page.getControl());
            this.previews.put(Integer.toString(index), page);
            page.setIndex(index);
            Composite container = this.getContainer();
            if (container instanceof CTabFolder) {
                if (page.getTabImage() != null) {
                    ((CTabFolder)container).getItem(index).setImage(page.getTabImage());
                } else {
                    ((CTabFolder)container).getItem(index).setImage(HTMLPlugin.getImage("icons/add_tab_decorator.png"));
                }
            }
            this.setPageText(index, " " + page.getTitle() + " ");
        }
    }

    public Composite getContainer() {
        return super.getContainer();
    }

    public IPreviewConfigurationPage[] getPreviewPages() {
        return this.previews.values().toArray(new IPreviewConfigurationPage[0]);
    }

    public void savePreviewsPages() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            Iterator<IPreviewConfigurationPage> iter = this.previews.values().iterator();
            ArrayList<PreviewConfigurationPage> previews = new ArrayList<PreviewConfigurationPage>();
            ArrayList<PreviewConfigurationPage> addPreviews = new ArrayList<PreviewConfigurationPage>();
            while (iter.hasNext()) {
                IPreviewConfigurationPage page = iter.next();
                if (page instanceof PreviewConfigurationPage) {
                    if (CoreUIUtils.onMacOSX && this.isFirefoxBrowser(page)) {
                        addPreviews.add((PreviewConfigurationPage)page);
                        IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_MovingTab, (String)page.getTitle()));
                        continue;
                    }
                    previews.add((PreviewConfigurationPage)page);
                    IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_SavingTab, (String)page.getTitle()));
                    continue;
                }
                IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_INF_SkippingSave, (String)page.getTitle()));
            }
            previews.addAll(addPreviews);
            IFile file = ((IFileEditorInput)input).getFile();
            StringBuffer names = new StringBuffer("");
            StringBuffer browser = new StringBuffer("");
            StringBuffer types = new StringBuffer("");
            StringBuffer servers = new StringBuffer("");
            StringBuffer configs = new StringBuffer("");
            StringBuffer absolutes = new StringBuffer("");
            for (PreviewConfigurationPage pcp : previews) {
                String type = pcp.getType();
                String value = pcp.getValue();
                if ("com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE".equals(type) || "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(type)) {
                    servers.append(String.valueOf(value) + "___PREFERENCE___");
                    configs.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                    absolutes.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                } else if ("com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE".equals(type)) {
                    servers.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                    configs.append(String.valueOf(value) + "___PREFERENCE___");
                    absolutes.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                } else if ("com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE".equals(type)) {
                    servers.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                    configs.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                    absolutes.append(String.valueOf(value) + "___PREFERENCE___");
                } else {
                    servers.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                    configs.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                    absolutes.append("com.aptana.ide.editor.html.preview.INVALID___PREFERENCE___");
                }
                types.append(String.valueOf(type) + "___PREFERENCE___");
                names.append(String.valueOf(pcp.getTitle()) + "___PREFERENCE___");
                browser.append(String.valueOf(pcp.getBrowserLabel()) + "___PREFERENCE___");
            }
            try {
                file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_BROWSERS"), browser.toString());
                file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_NAMES"), names.toString());
                file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE"), types.toString());
                file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_URLS"), absolutes.toString());
                file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_CONFIG_ID"), configs.toString());
                file.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_SERVER_ID"), servers.toString());
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)"Error saving preview page add-ons", (Throwable)e);
            }
        }
    }

    private boolean isFirefoxBrowser(IPreviewConfigurationPage page) {
        String type = page.getBrowserLabel();
        String classType = page.getBrowserType();
        return "Firefox".equals(type) || classType != null && classType.indexOf("Firefox") != -1;
    }

    public void setPreviewPageText(int index, String title) {
        this.setPageText(index, title);
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        if (this.wrapper != null) {
            this.wrapper.dispose();
        }
        if (this._siteEditor != null) {
            this._siteEditor.dispose();
        }
        if (this.editor != null) {
            if (this.editor.getDocumentProvider() != null) {
                this.editor.getDocumentProvider().removeElementStateListener(this.elementListener);
            }
            this.editor.removePropertyListener(this.propertyListener);
            this.editor.dispose();
        }
        if (this.previews != null && this.previews.size() != 0) {
            this.disposePreviews();
            this.previews = null;
        }
        this._page0 = null;
        this.editor = null;
        this.wrapper = null;
        this._siteEditor = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorPart editor = this.getEditor(0);
        editor.doSave(monitor);
        this.setInput(editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
        Command nextMultipageEditorTabCommand = commandService.getCommand("com.aptana.ide.editors.nextMultipageEditorTab");
        Command previousMultipageEditorTabCommand = commandService.getCommand("com.aptana.ide.editors.previousMultipageEditorTab");
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        handlerService.activateHandler(nextMultipageEditorTabCommand.getId(), (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                MultiPageHTMLEditor.this.gotoNextMultipageEditorTab();
                return null;
            }
        });
        handlerService.activateHandler(previousMultipageEditorTabCommand.getId(), (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                MultiPageHTMLEditor.this.gotoPreviousMultipageEditorTab();
                return null;
            }
        });
    }

    private void gotoNextMultipageEditorTab() {
        CTabFolder tabFolder;
        int itemCount;
        Composite comp = this.getContainer();
        if (comp instanceof CTabFolder && (itemCount = (tabFolder = (CTabFolder)comp).getItemCount()) > 1) {
            int selectionIndex = tabFolder.getSelectionIndex();
            if (++selectionIndex >= itemCount) {
                selectionIndex = 0;
            }
            this.setActivePage(selectionIndex);
        }
    }

    private void gotoPreviousMultipageEditorTab() {
        CTabFolder tabFolder;
        int itemCount;
        Composite comp = this.getContainer();
        if (comp instanceof CTabFolder && (itemCount = (tabFolder = (CTabFolder)comp).getItemCount()) > 1) {
            int selectionIndex = tabFolder.getSelectionIndex();
            if (--selectionIndex < 0) {
                selectionIndex = itemCount - 1;
            }
            this.setActivePage(selectionIndex);
        }
    }

    public boolean isFileEditorInput() {
        return this.editor.isFileEditorInput();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 0) {
            this.wrapper.getSite().setSelectionProvider(this.editor.getSelectionProvider());
            this.wrapper.updateSource();
            this.wrapper.setToolbarVisible(true);
            Iterator<IPreviewConfigurationPage> pages = this.previews.values().iterator();
            while (pages.hasNext()) {
                pages.next().clearBrowser();
            }
        } else {
            this.getSite().setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
            this.wrapper.updatePreview();
            this.wrapper.setToolbarVisible(false);
        }
    }

    public void setOffset(int offset) {
        this.setActivePage(0);
        this.editor.selectAndReveal(offset, 0);
    }

    public Object getAdapter(Class adapter) {
        if (this.editor != null) {
            return this.editor.getAdapter(adapter);
        }
        IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.MultiPageHTMLEditor_EditorIsNull, (String)adapter.toString()));
        return null;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.wrapper.firePropertyChange2(propertyId);
    }

    public void setBrowserURL(String url) {
        String index = Integer.toString(this.getActivePage());
        if (this.previews.containsKey(index)) {
            IPreviewConfigurationPage page;
            boolean autoSave;
            if (!HTMLPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.html.AUTO_SAVE_PROMPTED")) {
                HTMLPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editor.html.AUTO_SAVE_PROMPTED", true);
                autoSave = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Messages.MultiPageHTMLEditor_AutoSaveTitlte, (String)Messages.MultiPageHTMLEditor_AutoSaveMessage);
                HTMLPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editor.html.AUTO_SAVE_BEFORE_PREVIEWING", autoSave);
            }
            if (this.editor.isDirty() && (autoSave = HTMLPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.html.AUTO_SAVE_BEFORE_PREVIEWING"))) {
                this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            if ((page = this.previews.get(index)) instanceof DefaultPreviewConfigurationPage) {
                this.setTabIcon(page, null);
            } else if (page.getTabImage() != null) {
                this.setTabIcon(page, page.getTabImage());
            } else {
                this.setTabIcon(page, HTMLPlugin.getImage("icons/add_tab_decorator.png"));
            }
            page.setURL(url);
            for (IPreviewConfigurationPage curr : this.previews.values()) {
                if (curr == page) continue;
                curr.clearBrowser();
            }
        }
        this.url = url;
    }

    public void setTabIcon(IPreviewConfigurationPage page, Image icon) {
        for (String key : this.previews.keySet()) {
            CTabFolder tabs;
            if (page == null || page != this.previews.get(key)) continue;
            int index = Integer.parseInt(key.toString());
            if (!(this.getContainer() instanceof CTabFolder) || index >= (tabs = (CTabFolder)this.getContainer()).getItemCount()) break;
            tabs.getItem(index).setImage(icon);
            break;
        }
    }

    public void setTabTooltip(IPreviewConfigurationPage page, String text) {
        for (String key : this.previews.keySet()) {
            CTabFolder tabs;
            if (page == null || page != this.previews.get(key)) continue;
            int index = Integer.parseInt(key.toString());
            if (!(this.getContainer() instanceof CTabFolder) || index >= (tabs = (CTabFolder)this.getContainer()).getItemCount()) break;
            tabs.getItem(index).setToolTipText(text);
            break;
        }
    }

    public String getURL() {
        return this.url;
    }

    private void disposePreviews() {
        Object[] _previews = this.previews.values().toArray();
        int i = 0;
        while (i < _previews.length) {
            ((IPreviewConfigurationPage)_previews[i]).dispose();
            ++i;
        }
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    public int findPageIndex(String pageName) {
        Set<String> s = this.previews.keySet();
        for (String object : s) {
            IPreviewConfigurationPage page = this.previews.get(object);
            if (!page.getTitle().equals(pageName)) continue;
            return Integer.parseInt(object);
        }
        return -1;
    }

    private static class SourceEditorSite
    extends MultiPageEditorSite {
        private HTMLSourceEditor _editor = null;
        private IEditorSite _site;
        private ArrayList _menuExtenders;
        private boolean isDisposing = false;

        public SourceEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor, IEditorSite site) {
            super(multiPageEditor, editor);
            this._site = site;
            this._editor = (HTMLSourceEditor)editor;
        }

        public String getId() {
            return this._site.getId();
        }

        public IEditorActionBarContributor getActionBarContributor() {
            return this._site.getActionBarContributor();
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            if (this._editor != null) {
                if (this._menuExtenders == null) {
                    this._menuExtenders = new ArrayList(1);
                }
                this._menuExtenders.add(new PopupMenuExtender(menuId, menuManager, selectionProvider, (IWorkbenchPart)this._editor));
            }
        }

        public void dispose() {
            if (this.isDisposing) {
                return;
            }
            this.isDisposing = true;
            super.dispose();
            if (this._menuExtenders != null) {
                int i = 0;
                while (i < this._menuExtenders.size()) {
                    ((PopupMenuExtender)this._menuExtenders.get(i)).dispose();
                    ++i;
                }
                this._menuExtenders = null;
            }
            this._editor = null;
            if (this._site != null && this._site instanceof EditorSite) {
                ((EditorSite)this._site).dispose();
            }
            this._site = null;
        }

        public IKeyBindingService getKeyBindingService() {
            return this._site.getKeyBindingService();
        }

        public String getPluginId() {
            return this._site.getPluginId();
        }

        public String getRegisteredName() {
            return this._site.getRegisteredName();
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
            this._site.registerContextMenu(menuManager, selProvider);
        }
    }
}

