/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.outline;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.outline.WarningItem;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLSpecialNode;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class HTMLLabelProvider
extends LabelProvider
implements IPropertyChangeListener {
    private static final Image ELEMENT_ICON = HTMLPlugin.getImage("icons/element_icon.gif");
    private static final Image WARNING_ICON = UnifiedEditorsPlugin.getImage((String)"icons/warning.png");
    private static final Image ERROR_ICON = UnifiedEditorsPlugin.getImage((String)"icons/error.png");
    private String[] _attributeNames;

    public HTMLLabelProvider() {
        IPreferenceStore prefStore = HTMLPlugin.getDefault().getPreferenceStore();
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.getAttributeNameList();
    }

    private void getAttributeNameList() {
        IPreferenceStore prefStore = HTMLPlugin.getDefault().getPreferenceStore();
        String result = prefStore.getString("com.aptana.ide.editor.html.HTMLEDITOR_OUTLINER_ATTRIBUTE_LIST");
        this._attributeNames = result.split("\\s+,\\s*|\\s*,\\s+|,|\\s+");
    }

    public Image getImage(Object element) {
        Image result;
        if (element instanceof WarningItem) {
            WarningItem w = (WarningItem)element;
            Image result2 = w.isError() ? ERROR_ICON : WARNING_ICON;
            return result2;
        }
        if (element instanceof HTMLElementNode) {
            result = ELEMENT_ICON;
        } else if (element instanceof HTMLSpecialNode) {
            HTMLSpecialNode node = (HTMLSpecialNode)((Object)element);
            result = HTMLPlugin.getImage("icons/" + node.getIconBaseName() + ".gif");
        } else {
            result = super.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String result;
        if (element instanceof WarningItem) {
            WarningItem w = (WarningItem)element;
            return w.getMessage();
        }
        if (element instanceof HTMLElementNode) {
            HTMLElementNode node = (HTMLElementNode)((Object)element);
            result = node.getName();
            if (this._attributeNames.length > 0) {
                ArrayList<String> values = new ArrayList<String>();
                int i = 0;
                while (i < this._attributeNames.length) {
                    String attributeName = this._attributeNames[i];
                    if (node.hasAttribute(attributeName)) {
                        values.add(node.getAttribute(attributeName));
                    }
                    ++i;
                }
                if (values.size() > 0) {
                    String[] valueStrings = values.toArray(new String[values.size()]);
                    result = String.valueOf(result) + " : " + StringUtils.join((String)" | ", (String[])valueStrings);
                }
            }
        } else {
            result = element instanceof HTMLSpecialNode ? ((HTMLSpecialNode)((Object)element)).getText() : super.getText(element);
        }
        if (result != null) {
            try {
                result = result.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.aptana.ide.editor.html.HTMLEDITOR_OUTLINER_ATTRIBUTE_LIST")) {
            this.getAttributeNameList();
            UnifiedOutlineProvider.getInstance().refresh();
        }
    }
}

