/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.parsing.nodes;

import com.aptana.ide.editor.html.parsing.nodes.HTMLParseNode;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;

public class HTMLSpecialNode
extends HTMLParseNode {
    private String _nestedLanguage;
    private String _iconBaseName = "html_tag";
    private LexemeList _lexemeList;

    public HTMLSpecialNode(Lexeme startLexeme) {
        super(4, startLexeme);
    }

    public String getIconBaseName() {
        return this._iconBaseName;
    }

    public String getNestedLanguage() {
        return this._nestedLanguage;
    }

    public String getText() {
        StringBuffer result = new StringBuffer();
        LexemeList lexemes = this._lexemeList;
        int currentIndex = lexemes.getLexemeIndex(this.getStartingLexeme());
        boolean hasMore = true;
        if (currentIndex >= 0) {
            int lastOffset = -1;
            int currentCount = 0;
            int includeCount = 3;
            int length = lexemes.size();
            ++currentIndex;
            while (currentIndex < length) {
                Lexeme currentLexeme = lexemes.get(currentIndex);
                if (!currentLexeme.getLanguage().equals(this._nestedLanguage)) {
                    hasMore = false;
                    break;
                }
                if (!currentLexeme.getCategory().equals("WHITESPACE")) {
                    if (lastOffset != -1 && lastOffset != currentLexeme.offset) {
                        result.append(" ");
                    }
                    result.append(currentLexeme.getText());
                    lastOffset = currentLexeme.getEndingOffset();
                    if (++currentCount >= includeCount) {
                        result.append(" ");
                        break;
                    }
                }
                ++currentIndex;
            }
        }
        if (hasMore) {
            result.append("...");
        }
        return result.toString();
    }

    public void setNestedLanguage(String language) {
        this._nestedLanguage = language;
        int slashIndex = language.indexOf(47);
        this._iconBaseName = slashIndex != -1 && slashIndex < language.length() - 2 ? language.substring(slashIndex + 1) : language;
    }

    public void setLexemeList(LexemeList lexemeList) {
        this._lexemeList = lexemeList;
    }
}

