/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.BrowserExtensionLoader;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preferences.Messages;
import com.aptana.ide.editor.html.preview.PreviewTypeSelectionBlock;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.server.core.IServer;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreviewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer previewViewer;
    private Label description;
    private Composite displayArea;
    private Group browsers;
    private PreviewTypeSelectionBlock block;
    private Button autoSave;
    private Button cacheBust;
    private Button useTempFiles;

    public PreviewPreferencePage() {
        this.setDescription(Messages.PreviewPreferencePage_LBL_DefaultSettings);
    }

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        this.displayArea.setLayout((Layout)layout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.autoSave = new Button(this.displayArea, 32);
        this.autoSave.setText(Messages.PreviewPreferencePage_LBL_AutoSave);
        this.autoSave.setSelection(this.getPreferenceStore().getBoolean("com.aptana.ide.editor.html.AUTO_SAVE_BEFORE_PREVIEWING"));
        this.cacheBust = new Button(this.displayArea, 32);
        this.cacheBust.setText(Messages.PreviewPreferencePage_LBL_PreventCache);
        this.cacheBust.setSelection(UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.CACHE_BUST_BROWSERS"));
        this.useTempFiles = new Button(this.displayArea, 32);
        this.useTempFiles.setText(Messages.PreviewPreferencePage_LBL_GenerateTemp);
        this.useTempFiles.setSelection(this.getPreferenceStore().getBoolean("com.aptana.ide.editor.html.USE_TEMP_FILES_FOR_PREVIEW"));
        String type = this.getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE");
        String value = this.getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE");
        this.block = new PreviewTypeSelectionBlock();
        this.block.useSampleURL();
        this.block.createStartActionSection(this.displayArea, type, value);
        this.block.setCurrentURLLabel(Messages.PreviewPreferencePage_LBL_SampleURL);
        this.block.setEnabled(true);
        this.block.updateControls();
        this.block.updateCurrentURL();
        this.description = new Label(this.displayArea, 64);
        this.description.setText(Messages.PreviewPreferencePage_PreviewBrowserDescription);
        this.browsers = new Group(this.displayArea, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.browsers.setLayout((Layout)gridLayout);
        this.browsers.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browsers.setText(Messages.PreviewPreferencePage_PreviewBrowsers);
        Table table = new Table((Composite)this.browsers, 2084);
        table.setFont(parent.getFont());
        this.previewViewer = new CheckboxTableViewer(table);
        this.previewViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.previewViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return BrowserExtensionLoader.getBrowserImage(element.toString());
            }

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.previewViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (Platform.getOS().equals("macosx") && PreviewPreferencePage.this.previewViewer.getChecked((Object)"Firefox") && !PreviewPreferencePage.this.previewViewer.getChecked((Object)"Safari")) {
                    MessageDialog.openInformation((Shell)PreviewPreferencePage.this.getShell(), (String)Messages.PreviewPreferencePage_FirefoxPreviewIssueTitle, (String)Messages.PreviewPreferencePage_FirefoxPreviewIssueMessage);
                    PreviewPreferencePage.this.previewViewer.setChecked((Object)"Firefox", false);
                }
            }
        });
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPreviewBrowsers();
        this.addCheckedBrowsers();
        return this.displayArea;
    }

    private void addPreviewBrowsers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
        IExtension[] extensions = ep.getExtensions();
        ArrayList<String> browserPreviews = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String browserClass = ce[j].getAttribute("class");
                String name = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                if (browserClass != null && name != null) {
                    browserPreviews.add(name);
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(browserPreviews);
        this.previewViewer.setInput((Object)browserPreviews.toArray());
    }

    private void addCheckedBrowsers() {
        String all_browsers = this.getPreferenceStore().getString("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE");
        String[] browsers = all_browsers.split(",");
        int i = 0;
        while (i < browsers.length) {
            this.previewViewer.setChecked((Object)browsers[i], true);
            ++i;
        }
    }

    public boolean performOk() {
        ArrayList<String> al = new ArrayList<String>();
        Object[] elements = this.previewViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            al.add(elements[i].toString());
            ++i;
        }
        this.getPreferenceStore().setValue("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE", StringUtils.join((String)",", (String[])al.toArray(new String[0])));
        String type = "";
        type = this.block.getServerButton().getSelection() ? (this.block.getServerAppendButton().getSelection() ? "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE" : "com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE") : (this.block.getConfigurationButton().getSelection() ? "com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE" : (this.block.getStartURLButton().getSelection() ? (this.block.getStartURLAppendButton().getSelection() ? "com.aptana.ide.editor.html.preview.APPENDED_ABSOLUTE_BASED_TYPE" : "com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE") : "com.aptana.ide.editor.html.preview.FILE_BASED_TYPE"));
        String value = "";
        if (this.block.getServerButton().getSelection()) {
            Object obj = this.block.getServerText().getData();
            value = obj != null && obj instanceof IServer ? ((IServer)obj).getId() : this.block.getServerText().getText();
        } else if (this.block.getConfigurationButton().getSelection()) {
            value = this.block.getConfigurationText().getText();
        } else if (this.block.getStartURLButton().getSelection()) {
            value = this.block.getStartURLText().getText().trim();
        }
        this.getPreferenceStore().setValue("com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE", type);
        this.getPreferenceStore().setValue("com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE", value);
        this.getPreferenceStore().setValue("com.aptana.ide.editor.html.AUTO_SAVE_BEFORE_PREVIEWING", this.autoSave.getSelection());
        this.getPreferenceStore().setValue("com.aptana.ide.editor.html.USE_TEMP_FILES_FOR_PREVIEW", this.useTempFiles.getSelection());
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editors.CACHE_BUST_BROWSERS", this.cacheBust.getSelection());
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        String prefs = this.getPreferenceStore().getDefaultString("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE");
        this.previewViewer.setCheckedElements((Object[])prefs.split(","));
        String type = HTMLPlugin.getDefault().getPreferenceStore().getDefaultString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE");
        String value = HTMLPlugin.getDefault().getPreferenceStore().getDefaultString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE");
        this.block.setType(type);
        this.block.setValue(value);
        this.block.updateControls();
        this.autoSave.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.editor.html.AUTO_SAVE_BEFORE_PREVIEWING"));
        this.cacheBust.setSelection(UnifiedEditorsPlugin.getDefault().getPreferenceStore().getDefaultBoolean("com.aptana.ide.editors.CACHE_BUST_BROWSERS"));
        this.useTempFiles.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.editor.html.USE_TEMP_FILES_FOR_PREVIEW"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
    }
}

