/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.debug.core.JSLaunchConfigurationHelper;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.server.core.IServer;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public final class HTMLPreviewHelper {
    private HTMLPreviewHelper() {
    }

    public static String getConfigURL(ILaunchConfiguration config, IEditorInput input) {
        URL url = null;
        IFile file = null;
        if (input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        }
        try {
            url = JSLaunchConfigurationHelper.getLaunchURL((ILaunchConfiguration)config, (IResource)file);
            if (url != null) {
                return url.toExternalForm();
            }
        }
        catch (CoreException e) {
            HTMLPlugin.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    public static String getServerURL(IServer server, IEditorInput input, boolean appendProjectName) {
        return HTMLPreviewHelper.getServerURL(server, input, appendProjectName, null);
    }

    public static String getServerURL(IServer server, IEditorInput input, boolean appendProjectName, String pathHeader) {
        String url = null;
        String externalBaseUrl = HTMLPreviewHelper.getServerHostURL(server);
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            url = HTMLPreviewHelper.getServerURLFromFile(server, (IResource)file, appendProjectName, pathHeader);
        } else {
            url = externalBaseUrl;
        }
        return url;
    }

    public static String getAbsoluteURL(String baseURL, IEditorInput input, boolean appendProjectName) {
        IFile file;
        String url = baseURL;
        if (url != null && appendProjectName && input instanceof FileEditorInput && (file = ((FileEditorInput)input).getFile()) != null) {
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            url = String.valueOf(url) + file.getProjectRelativePath();
        }
        return url;
    }

    public static String getServerURLFromFile(IServer server, IResource file, boolean appendProjectName) {
        return HTMLPreviewHelper.getServerURLFromFile(server, file, appendProjectName, null);
    }

    private static String getServerURLFromFile(IServer server, IResource file, boolean appendProjectName, String pathHeader) {
        String url = null;
        String externalBaseUrl = HTMLPreviewHelper.getServerHostURL(server);
        if (pathHeader != null) {
            externalBaseUrl = String.valueOf(externalBaseUrl) + pathHeader + "/";
        }
        try {
            URL baseURL = new URL(externalBaseUrl);
            IProject project = file.getProject();
            baseURL = appendProjectName ? new URL(baseURL, String.valueOf(project.getName()) + '/' + file.getProjectRelativePath()) : new URL(baseURL, file.getProjectRelativePath().toString());
            url = baseURL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            url = externalBaseUrl;
        }
        return url;
    }

    public static String getServerHostURL(IServer server) {
        String host = server.getHost() == null ? "localhost" : server.getHost();
        String externalBaseUrl = "http://" + host + "/";
        return externalBaseUrl;
    }

    public static String getConfigSampleURL(ILaunchConfiguration config, String projectName) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(projectName) + "/file.html"));
        try {
            URL url = JSLaunchConfigurationHelper.getLaunchURL((ILaunchConfiguration)config, (IResource)file);
            if (url != null) {
                return url.toExternalForm();
            }
        }
        catch (CoreException e) {
            HTMLPlugin.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }
}

