/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.editor.html.BrowserExtensionLoader;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.MultiPageHTMLEditor;
import com.aptana.ide.editor.html.preview.BasePreviewConfigurationPage;
import com.aptana.ide.editor.html.preview.HTMLPreviewHelper;
import com.aptana.ide.editor.html.preview.Messages;
import com.aptana.ide.editor.html.preview.PreviewTypeSelectionBlock;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.server.core.IServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PreviewConfigurationPage
extends BasePreviewConfigurationPage {
    public static final String DEFAULT_PREVIEW_NAME = "New Preview";
    private Map<String, Button> buttons = new HashMap<String, Button>();
    private Composite displayArea;
    private Composite browserArea;
    private Composite editArea;
    private PreviewTypeSelectionBlock block;
    private Button save;
    private Button cancel;
    private Label status;
    private Label nameLabel;
    private Text nameText;
    private ProgressListener listener;
    private Listener locListener;
    private Event lastEvent = null;

    public PreviewConfigurationPage(MultiPageHTMLEditor editor) {
        super(editor);
        this.title = DEFAULT_PREVIEW_NAME;
        this.url = this.editor.getURL();
        this.type = "com.aptana.ide.editor.html.preview.FILE_BASED_TYPE";
        this.value = null;
        this.block = new PreviewTypeSelectionBlock();
        this.block.setEditor((IEditorPart)editor);
        this.locListener = new Listener(){

            public void handleEvent(Event event) {
                if (PreviewConfigurationPage.this.lastEvent == null || event.time > ((PreviewConfigurationPage)PreviewConfigurationPage.this).lastEvent.time) {
                    PreviewConfigurationPage.this.lastEvent = event;
                    if (event.data instanceof Image) {
                        PreviewConfigurationPage.this.editor.setTabIcon(PreviewConfigurationPage.this, (Image)event.data);
                        String addOn = event.text;
                        if (addOn != null) {
                            PreviewConfigurationPage.this.editor.setTabTooltip(PreviewConfigurationPage.this, String.valueOf(PreviewConfigurationPage.this.url) + " " + event.text);
                        }
                    }
                }
            }
        };
        this.listener = new ProgressListener(){

            public void completed(ProgressEvent event) {
                BrowserExtensionLoader.getDecorator(PreviewConfigurationPage.this.browser, PreviewConfigurationPage.this.locListener);
            }

            public void changed(ProgressEvent event) {
            }
        };
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editArea = new Composite(this.displayArea, 0);
        GridLayout eaLayout = new GridLayout(1, false);
        eaLayout.marginWidth = 10;
        eaLayout.marginHeight = 10;
        this.editArea.setLayout((Layout)eaLayout);
        this.editArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserArea = new Composite(this.displayArea, 0);
        GridData baData = new GridData(4, 4, true, true);
        baData.exclude = true;
        GridLayout baLayout = new GridLayout(1, false);
        baLayout.marginHeight = 0;
        baLayout.marginWidth = 0;
        this.browserArea.setLayout((Layout)baLayout);
        this.browserArea.setLayoutData((Object)baData);
        this.browserArea.setVisible(false);
        Composite optionsArea = this.createConfigurationSection(this.editArea);
        this.createStartActionSection(optionsArea);
        this.createBrowserSection(optionsArea);
        this.createButtonSection(this.editArea);
        this.block.updateControls();
        this.validate();
    }

    public boolean run(String actionID) {
        boolean run = false;
        try {
            if ("org.eclipse.ui.edit.cut".equals(actionID)) {
                if (this.nameText.isFocusControl()) {
                    this.nameText.cut();
                    run = true;
                } else if (this.block.getStartURLText().isFocusControl()) {
                    this.block.getStartURLText().cut();
                    run = true;
                } else if (this.block.getCurrentURLText().isFocusControl()) {
                    run = true;
                }
            } else if ("org.eclipse.ui.edit.paste".equals(actionID)) {
                if (this.nameText.isFocusControl()) {
                    this.nameText.paste();
                    run = true;
                } else if (this.block.getStartURLText().isFocusControl()) {
                    this.block.getStartURLText().paste();
                    run = true;
                } else if (this.block.getCurrentURLText().isFocusControl()) {
                    run = true;
                }
            } else if ("org.eclipse.ui.edit.copy".equals(actionID)) {
                if (this.nameText.isFocusControl()) {
                    this.nameText.copy();
                    run = true;
                } else if (this.block.getStartURLText().isFocusControl()) {
                    this.block.getStartURLText().copy();
                    run = true;
                } else if (this.block.getCurrentURLText().isFocusControl()) {
                    this.block.getCurrentURLText().copy();
                    run = true;
                }
            }
        }
        catch (Exception exception) {
            run = false;
        }
        catch (Error error) {
            run = false;
        }
        return run;
    }

    public void setBrowser(ContributedBrowser browser, String label) {
        Button button = this.buttons.get(label);
        if (button != null && !button.isDisposed()) {
            button.setSelection(true);
            for (Button other : this.buttons.values()) {
                if (other == button || other == null) continue;
                other.setSelection(false);
            }
        }
        if (this.browser != null) {
            this.browser.dispose();
            this.browser.removeProgressListener(this.listener);
        }
        this.browserLabel = label;
        this.browser = browser;
        this.created = false;
    }

    public void setTitle(String title) {
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.nameText.setText(title);
        }
        super.setTitle(title);
    }

    public void showEditArea() {
        GridData eaData = (GridData)this.editArea.getLayoutData();
        eaData.exclude = false;
        GridData baData = (GridData)this.browserArea.getLayoutData();
        baData.exclude = true;
        this.browserArea.setVisible(false);
        this.editArea.setVisible(true);
        this.displayArea.layout(true, true);
    }

    public void showBrowserArea() {
        GridData eaData = (GridData)this.editArea.getLayoutData();
        eaData.exclude = true;
        GridData baData = (GridData)this.browserArea.getLayoutData();
        baData.exclude = false;
        this.browserArea.setVisible(true);
        this.editArea.setVisible(false);
        this.displayArea.layout(true, true);
        Button button = this.buttons.get(this.browserLabel);
        if (button != null && !button.isDisposed()) {
            button.setSelection(true);
            for (Button other : this.buttons.values()) {
                if (other == button || other == null) continue;
                other.setSelection(false);
            }
        }
        this.block.refreshURLs();
        this.block.updateControls();
        this.block.updateCurrentURL();
        this.validate();
    }

    public String getURL() {
        return this.block.getCurrentURLText().getText();
    }

    public void setURL(String url) {
        if (this.browser != null) {
            if (!this.created) {
                this.created = true;
                this.browser.createControl(this.browserArea);
                this.browser.addProgressListener(this.listener);
                this.browserArea.layout(true, true);
            }
            if (this.block.getFileButton().getSelection()) {
                this.url = url;
            } else if (this.block.getServerButton().getSelection()) {
                String serverURL;
                Object data = this.block.getServerText().getData();
                if (data != null && data instanceof IServer && (serverURL = HTMLPreviewHelper.getServerURL((IServer)data, this.editor.getEditorInput(), this.block.getServerAppendButton().getSelection())) != null) {
                    this.url = serverURL;
                }
            } else if (this.block.getServerButton().getSelection()) {
                String configURL;
                Object data = this.block.getServerText().getData();
                if (data != null && data instanceof ILaunchConfiguration && (configURL = HTMLPreviewHelper.getConfigURL((ILaunchConfiguration)data, this.editor.getEditorInput())) != null) {
                    this.url = configURL;
                }
            } else {
                this.url = this.block.getStartURLText().getText();
                if (this.block.getStartURLAppendButton().getSelection()) {
                    IEditorInput input = this.editor.getEditorInput();
                    this.url = HTMLPreviewHelper.getAbsoluteURL(this.value, input, "com.aptana.ide.editor.html.preview.APPENDED_ABSOLUTE_BASED_TYPE".equals(this.type));
                }
                if (this.url == null || this.url.length() == 0) {
                    this.url = url;
                }
            }
            this.block.getCurrentURLText().setText(this.url);
            this.editor.setTabTooltip(this, this.url);
            this.browser.setURL(this.url);
        }
    }

    public void saveBrowserSettings() {
        for (Button b : this.buttons.values()) {
            if (!b.getSelection()) continue;
            this.browserLabel = b.getText();
            break;
        }
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
        IExtension[] extensions = ep.getExtensions();
        boolean found = false;
        int i = 0;
        while (i < extensions.length && !found) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length && !found) {
                String browserClass = ce[j].getAttribute("class");
                String name = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                if (browserClass != null && name != null && name.equals(this.browserLabel)) {
                    found = true;
                    try {
                        Object obj = ce[j].createExecutableExtension("class");
                        if (obj instanceof ContributedBrowser) {
                            this.setBrowser((ContributedBrowser)obj, name);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++j;
            }
            ++i;
        }
    }

    public void save() {
        this.type = this.block.getServerButton().getSelection() ? (this.block.getServerAppendButton().getSelection() ? "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE" : "com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE") : (this.block.getConfigurationButton().getSelection() ? "com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE" : (this.block.getStartURLButton().getSelection() ? (this.block.getStartURLAppendButton().getSelection() ? "com.aptana.ide.editor.html.preview.APPENDED_ABSOLUTE_BASED_TYPE" : "com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE") : "com.aptana.ide.editor.html.preview.FILE_BASED_TYPE"));
        if (this.block.getServerButton().getSelection()) {
            Object obj = this.block.getServerText().getData();
            this.value = obj != null && obj instanceof IServer ? ((IServer)obj).getId() : this.block.getServerText().getText();
        } else if (this.block.getConfigurationButton().getSelection()) {
            this.value = this.block.getConfigurationText().getText();
        } else if (this.block.getStartURLButton().getSelection()) {
            this.value = this.block.getStartURLText().getText().trim();
        } else {
            IEditorInput input = this.editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                this.value = ((IFileEditorInput)input).getFile().getLocation().makeAbsolute().toOSString();
            }
        }
        if (this.block.getStartURLButton().getSelection()) {
            this.block.saveURLs();
        }
        this.saveBrowserSettings();
        this.title = this.nameText.getText();
        this.editor.setPreviewPageText(this.index, this.title);
        this.setURL(this.url);
        this.block.setType(this.type);
        this.block.setValue(this.value);
        this.editor.savePreviewsPages();
        this.showBrowserArea();
    }

    private void createButtonSection(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout bLayout = new GridLayout(3, false);
        bLayout.marginHeight = 0;
        bLayout.marginWidth = 0;
        buttons.setLayout((Layout)bLayout);
        GridData bData = new GridData(4, 4, true, false);
        buttons.setLayoutData((Object)bData);
        this.save = new Button(buttons, 8);
        this.save.setText(Messages.PreviewConfigurationPage_LBL_Save);
        this.save.setToolTipText(Messages.PreviewConfigurationPage_TTP_Save);
        this.save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewConfigurationPage.this.save();
            }
        });
        this.save.setLayoutData((Object)new GridData(4, 4, false, false));
        this.cancel = new Button(buttons, 8);
        this.cancel.setText(Messages.PreviewConfigurationPage_LBL_Cancel);
        this.cancel.setToolTipText(Messages.PreviewConfigurationPage_TTP_Cancel);
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreviewConfigurationPage.this.created) {
                    PreviewConfigurationPage.this.showBrowserArea();
                } else if (PreviewConfigurationPage.this.editor != null && PreviewConfigurationPage.this.index >= 0 && PreviewConfigurationPage.this.index < PreviewConfigurationPage.this.editor.getPageCount()) {
                    PreviewConfigurationPage.this.editor.removePage(PreviewConfigurationPage.this.index);
                }
            }
        });
        this.cancel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.status = new Label(buttons, 16384);
        this.status.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(255, 0, 0)));
        this.status.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private Composite createConfigurationSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.PreviewConfigurationPage_LBL_OptionsGroup);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight *= 2;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        this.nameLabel = new Label((Composite)group, 16384);
        this.nameLabel.setText(Messages.PreviewConfigurationPage_LBL_PreviewName);
        this.nameText = new Text((Composite)group, 2052);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nameText.setText(this.title);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreviewConfigurationPage.this.validate();
            }
        });
        return group;
    }

    public String generateNewPreviewName() {
        IFile file = this.getFile();
        String name = null;
        if (file != null) {
            try {
                String names = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_NAMES"));
                if (names != null) {
                    String[] splitNames = names.split("___PREFERENCE___");
                    boolean foundName = false;
                    name = DEFAULT_PREVIEW_NAME;
                    int tries = 1;
                    block2: while (!foundName) {
                        int i = 0;
                        while (i < splitNames.length) {
                            if (name.equals(splitNames[i])) {
                                name = "New Preview " + tries;
                                ++tries;
                                continue block2;
                            }
                            if (i + 1 == splitNames.length) {
                                foundName = true;
                                continue block2;
                            }
                            ++i;
                        }
                    }
                } else {
                    name = DEFAULT_PREVIEW_NAME;
                }
            }
            catch (CoreException coreException) {
                name = DEFAULT_PREVIEW_NAME;
            }
        } else {
            name = DEFAULT_PREVIEW_NAME;
        }
        return name;
    }

    private void validate() {
        boolean error;
        block11: {
            IFile file = this.getFile();
            String name = this.nameText.getText();
            error = false;
            if (name.trim().length() == 0) {
                error = true;
                this.status.setText(Messages.PreviewConfigurationPage_LBL_Status_Name);
            } else if (this.block.getStartURLButton().getSelection()) {
                if (this.block.getStartURLText().getText().trim().length() == 0) {
                    this.status.setText(Messages.PreviewConfigurationPage_LBL_Status_URL);
                    error = true;
                }
            } else if (file != null) {
                try {
                    String names = file.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_NAMES"));
                    if (names == null) break block11;
                    String[] splitNames = names.split("___PREFERENCE___");
                    int i = 0;
                    while (i < splitNames.length) {
                        if (!splitNames[i].equals(this.title) && name.equals(splitNames[i])) {
                            this.status.setText(Messages.PreviewConfigurationPage_LBL_Status_NameExists);
                            error = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        this.save.setEnabled(!error);
        if (!error) {
            this.status.setText("");
        }
    }

    private IFile getFile() {
        IFile file = null;
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        }
        return file;
    }

    private IProject getProject() {
        IProject project = null;
        IFile file = this.getFile();
        if (file != null) {
            project = file.getProject();
        }
        return project;
    }

    private void createBrowserSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.PreviewConfigurationPage_LBL_BrowserGroup);
        group.setFont(parent.getFont());
        GridData gData = new GridData(4, 4, true, false);
        gData.horizontalSpan = 2;
        group.setLayoutData((Object)gData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight *= 2;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        List labels = BrowserExtensionLoader.getAllBrowserLabels();
        int i = 0;
        while (i < labels.size()) {
            String label = (String)labels.get(i);
            Button browserButton = new Button((Composite)group, 16);
            Image image = BrowserExtensionLoader.getBrowserImage(label);
            if (image != null) {
                browserButton.setImage(image);
            }
            browserButton.setText(label);
            if (i == 0) {
                this.browserLabel = label;
                browserButton.setSelection(true);
            }
            this.buttons.put(label, browserButton);
            ++i;
        }
    }

    private void createStartActionSection(Composite parent) {
        this.block.createStartActionSection(parent, this.type, this.value);
        ModifyListener validator = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreviewConfigurationPage.this.validate();
            }
        };
        this.block.getStartURLButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewConfigurationPage.this.validate();
            }
        });
        this.block.getStartURLText().addModifyListener(validator);
    }

    public Control getControl() {
        return this.displayArea;
    }

    private ILaunchConfiguration getWorkspaceConfig() {
        ILaunchConfiguration config;
        block4: {
            config = null;
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            String configName = store.getString("com.aptana.ide.editor.html.HTMLEDITOR_RUNCONFIG_PREVIEW_PREFERENCE");
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("com.aptana.ide.debug.core.jsLaunchConfigurationType");
            try {
                ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(type);
                if (configs == null) break block4;
                int i = 0;
                while (i < configs.length) {
                    if (configs[i].getName().equals(configName)) {
                        config = configs[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                config = null;
            }
        }
        return config;
    }

    public ILaunchConfiguration getConfig() {
        ILaunchConfiguration config;
        block7: {
            config = null;
            IProject project = this.getProject();
            if (project != null) {
                try {
                    String override = project.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE"));
                    if ("true".equals(override)) {
                        ILaunchConfigurationType type;
                        ILaunchManager launchManager;
                        ILaunchConfiguration[] configs;
                        String configName = project.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.HTMLEDITOR_RUNCONFIG_PREVIEW_PREFERENCE"));
                        if (configName == null || (configs = (launchManager = DebugPlugin.getDefault().getLaunchManager()).getLaunchConfigurations(type = launchManager.getLaunchConfigurationType("com.aptana.ide.debug.core.jsLaunchConfigurationType"))) == null) break block7;
                        int i = 0;
                        while (i < configs.length) {
                            if (configs[i].getName().equals(configName)) {
                                config = configs[i];
                                break block7;
                            }
                            ++i;
                        }
                        break block7;
                    }
                    config = this.getWorkspaceConfig();
                }
                catch (CoreException coreException) {
                    config = null;
                }
            } else {
                config = this.getWorkspaceConfig();
            }
        }
        return config;
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }
}

