/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.toolbar;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.formatting.HTMLCodeFormatter;
import com.aptana.ide.editor.html.toolbar.Messages;
import com.aptana.ide.io.SourceWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InsertTableDialog
extends TitleAreaDialog {
    private Text t_rows;
    private Text t_cols;
    private Text t_width;
    private Combo cmb_size;
    private Text t_thickness;
    private Text t_padding;
    private Text t_spacing;
    private Button b_alignNone;
    private Button b_alignLeft;
    private Button b_alignTop;
    private Button b_alignBoth;
    private Text t_caption;
    private StyledText t_summary;
    private String result;
    private Combo cmb_alignCaption;
    private String lineDelimeter;
    private IProject project;

    protected Control createDialogArea(Composite parent) {
        Composite createDialogArea = (Composite)super.createDialogArea(parent);
        Composite cl = new Composite(createDialogArea, 0);
        GridLayout grl0 = new GridLayout(1, false);
        grl0.marginHeight = 5;
        grl0.marginWidth = 5;
        cl.setLayout((Layout)grl0);
        Group gr = new Group(cl, 0);
        gr.setText(Messages.InsertTableDialog_TableSize);
        this.createLabel((Composite)gr, Messages.InsertTableDialog_Rows);
        this.t_rows = new Text((Composite)gr, 2048);
        this.setFillHorizontal((Control)this.t_rows);
        this.createLabel((Composite)gr, Messages.InsertTableDialog_Columns);
        this.t_cols = new Text((Composite)gr, 2048);
        this.setFillHorizontal((Control)this.t_cols);
        gr.setLayout((Layout)new GridLayout(4, false));
        cl.setLayoutData((Object)new GridData(1808));
        this.createLabel((Composite)gr, Messages.InsertTableDialog_Width);
        Composite cm = new Composite((Composite)gr, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cm.setLayout((Layout)gridLayout);
        this.t_width = new Text(cm, 2048);
        this.setFillHorizontal((Control)this.t_width);
        this.cmb_size = new Combo(cm, 2048);
        this.setFillHorizontal((Control)cm);
        this.cmb_size.setItems(new String[]{Messages.InsertTableDialog_Pixels, Messages.InsertTableDialog_Percents});
        this.cmb_size.select(0);
        this.createLabel((Composite)gr, Messages.InsertTableDialog_Thickness);
        Composite cm1 = new Composite((Composite)gr, 0);
        GridLayout gridLayout1 = new GridLayout(2, false);
        gridLayout1.marginWidth = 0;
        gridLayout1.marginHeight = 0;
        cm1.setLayout((Layout)gridLayout1);
        this.t_thickness = new Text(cm1, 2048);
        this.setFillHorizontal((Control)this.t_thickness);
        this.createLabel(cm1, Messages.InsertTableDialog_PX);
        this.setFillHorizontal((Control)cm1);
        this.createLabel((Composite)gr, Messages.InsertTableDialog_CellPadding);
        this.t_padding = new Text((Composite)gr, 2048);
        this.setFillHorizontal((Control)this.t_padding);
        this.createLabel((Composite)gr, Messages.InsertTableDialog_CellSpacing);
        this.t_spacing = new Text((Composite)gr, 2048);
        this.setFillHorizontal((Control)this.t_spacing);
        this.setFillHorizontal((Control)gr);
        Group gr1 = new Group(cl, 0);
        this.setFillHorizontal((Control)gr1);
        gr1.setText(Messages.InsertTableDialog_Header);
        FillLayout fillLayout = new FillLayout(256);
        gr1.setLayout((Layout)fillLayout);
        this.b_alignNone = new Button((Composite)gr1, 16);
        this.b_alignNone.setSelection(true);
        this.b_alignNone.setText(Messages.InsertTableDialog_None);
        this.b_alignLeft = new Button((Composite)gr1, 16);
        this.b_alignLeft.setText(Messages.InsertTableDialog_Left);
        this.b_alignTop = new Button((Composite)gr1, 16);
        this.b_alignTop.setText(Messages.InsertTableDialog_Top);
        this.b_alignBoth = new Button((Composite)gr1, 16);
        this.b_alignBoth.setText(Messages.InsertTableDialog_Both);
        Group gr2 = new Group(cl, 0);
        this.setFillHorizontal((Control)gr1);
        gr2.setText(Messages.InsertTableDialog_Accessibility);
        this.setFillHorizontal((Control)gr2);
        fillLayout = new FillLayout(256);
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        gr1.setLayout((Layout)fillLayout);
        gr2.setLayout((Layout)new GridLayout(4, false));
        this.createLabel((Composite)gr2, Messages.InsertTableDialog_Caption);
        this.t_caption = new Text((Composite)gr2, 2048);
        this.createLabel((Composite)gr2, Messages.InsertTableDialog_AlignCaption);
        this.cmb_alignCaption = new Combo((Composite)gr2, 2048);
        this.setFillHorizontal((Control)this.t_caption);
        this.cmb_alignCaption.setItems(new String[]{Messages.InsertTableDialog_Default, Messages.InsertTableDialog_left, Messages.InsertTableDialog_right, Messages.InsertTableDialog_Top, Messages.InsertTableDialog_Bottom});
        this.cmb_alignCaption.select(0);
        this.setTitle(Messages.InsertTableDialog_InsertTable);
        Group gr3 = new Group((Composite)gr2, 0);
        gr3.setLayout((Layout)new FillLayout());
        gr3.setText(Messages.InsertTableDialog_Summary);
        this.t_summary = new StyledText((Composite)gr3, 768);
        GridData gridData5 = new GridData(1808);
        gridData5.minimumHeight = 100;
        gridData5.horizontalSpan = 4;
        gr3.setLayoutData((Object)gridData5);
        this.setMessage(Messages.InsertTableDialog_Description);
        this.getShell().setText(Messages.InsertTableDialog_Title);
        this.setIntValue(this.t_cols, 5);
        this.setIntValue(this.t_rows, 5);
        this.setIntValue(this.t_width, 200);
        this.setIntValue(this.t_thickness, 1);
        this.addValidation(this.t_caption);
        this.addValidation(this.t_cols);
        this.addValidation(this.t_padding);
        this.addValidation(this.t_rows);
        this.addValidation(this.t_spacing);
        this.addValidation(this.t_thickness);
        this.addValidation(this.t_width);
        this.validate();
        return createDialogArea;
    }

    private void setFillHorizontal(Control t1) {
        t1.setLayoutData((Object)new GridData(768));
    }

    private void setIntValue(Text t, int value) {
        t.setText(Integer.toString(value));
    }

    private void createLabel(Composite gr, String string) {
        Label l1 = new Label(gr, 0);
        l1.setText(string);
    }

    public void addValidation(Text t) {
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertTableDialog.this.validate();
            }
        });
    }

    public void validate() {
        Button button = this.getOKButton();
        if (button != null) {
            button.setEnabled(true);
        }
        this.setErrorMessage(null);
        this.validateInt(this.t_rows, Messages.InsertTableDialog_RowsV, 0);
        this.validateInt(this.t_cols, Messages.InsertTableDialog_ColumnsV, 0);
        this.validateIntOrSpace(this.t_padding, Messages.InsertTableDialog_PaddingV);
        this.validateIntOrSpace(this.t_spacing, Messages.InsertTableDialog_SpacingV);
        this.validateIntOrSpace(this.t_thickness, Messages.InsertTableDialog_ThicknessV);
        this.validateInt(this.t_width, Messages.InsertTableDialog_WidthV, 0);
    }

    public void validateInt(Text t, String string, int min) {
        block4: {
            String text = t.getText();
            Button button = this.getOKButton();
            try {
                int parseInt = Integer.parseInt(text);
                if (parseInt <= min) {
                    this.setErrorMessage(StringUtils.format((String)Messages.InsertTableDialog_GreaterErrorMessage, (Object[])new Object[]{string, new Integer(min)}));
                    if (button != null) {
                        button.setEnabled(false);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(StringUtils.format((String)Messages.InsertTableDialog_NumberValidationMessage, (String)string));
                if (button == null) break block4;
                button.setEnabled(false);
            }
        }
    }

    public void validateIntOrSpace(Text t, String string) {
        block4: {
            String text = t.getText();
            Button button = this.getOKButton();
            try {
                int parseInt = Integer.parseInt(text);
                if (parseInt < 0) {
                    this.setErrorMessage(StringUtils.format((String)Messages.InsertTableDialog_GreaterErrorMessage, (Object[])new Object[]{string, new Integer(0)}));
                    if (button != null) {
                        button.setEnabled(false);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (text.trim().length() <= 0) break block4;
                this.setErrorMessage(StringUtils.format((String)Messages.InsertTableDialog_NumberValidationMessage, (String)string));
                if (button == null) break block4;
                button.setEnabled(false);
            }
        }
    }

    public InsertTableDialog(Shell parentShell, String lineDelimeter, IProject project) {
        super(parentShell);
        this.lineDelimeter = lineDelimeter;
        this.project = project;
    }

    protected void okPressed() {
        SourceWriter wr = new SourceWriter();
        wr.print("<table ");
        String width = this.t_width.getText();
        if (this.cmb_size.getSelectionIndex() == 0) {
            wr.print(StringUtils.format((String)"width=\"{0}\" ", (String)width));
        } else {
            wr.print(StringUtils.format((String)"width=\"{0}%\" ", (String)width));
        }
        String text = this.t_thickness.getText();
        if (text.trim().length() > 0) {
            wr.print(StringUtils.format((String)"border=\"{0}\" ", (String)text));
        }
        if ((text = this.t_spacing.getText()).trim().length() > 0) {
            wr.print(StringUtils.format((String)"cellspacing=\"{0}\" ", (String)text));
        }
        if ((text = this.t_padding.getText()).trim().length() > 0) {
            wr.print(StringUtils.format((String)"cellpadding=\"{0}\" ", (String)text));
        }
        if ((text = this.t_summary.getText()).trim().length() > 0) {
            wr.print(StringUtils.format((String)"summary=\"{0}\" ", (String)text));
        }
        wr.println(">");
        text = this.t_caption.getText();
        wr.increaseIndent();
        if (text.trim().length() > 0) {
            wr.printIndent();
            wr.print("<caption");
            int k = this.cmb_alignCaption.getSelectionIndex();
            if (k > 0) {
                String vl = "";
                switch (k) {
                    case 1: {
                        vl = "left";
                        break;
                    }
                    case 2: {
                        vl = "right";
                        break;
                    }
                    case 3: {
                        vl = "top";
                        break;
                    }
                    case 4: {
                        vl = "bottom";
                        break;
                    }
                }
                wr.print(StringUtils.format((String)" align=\"{0}\" ", (String)vl));
            }
            wr.print(">");
            wr.print(text);
            wr.println("</caption>");
        }
        int rows = Integer.parseInt(this.t_rows.getText());
        int cols = Integer.parseInt(this.t_cols.getText());
        int a = 0;
        while (a < rows) {
            wr.printlnWithIndent("<tr>");
            wr.increaseIndent();
            int b = 0;
            while (b < cols) {
                boolean c = this.getCellOrHeader(a, b);
                if (c) {
                    wr.printlnWithIndent("<td>");
                    wr.printlnWithIndent("</td>");
                } else {
                    wr.printlnWithIndent("<th>");
                    wr.printlnWithIndent("</th>");
                }
                ++b;
            }
            wr.decreaseIndent();
            wr.printlnWithIndent("</tr>");
            ++a;
        }
        wr.decreaseIndent();
        wr.println("</table>");
        this.result = wr.toString();
        HTMLCodeFormatter fr = new HTMLCodeFormatter();
        this.result = fr.format(this.result, false, null, this.project, this.lineDelimeter);
        super.okPressed();
    }

    private boolean getCellOrHeader(int a, int b) {
        if (this.b_alignNone.getSelection()) {
            return true;
        }
        if (this.b_alignLeft.getSelection()) {
            return b != 0;
        }
        if (this.b_alignTop.getSelection()) {
            return a != 0;
        }
        if (this.b_alignBoth.getSelection()) {
            return a != 0 && b != 0;
        }
        return false;
    }

    public String getHTMLText() {
        return this.result;
    }
}

