/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core;

import com.aptana.ide.debug.core.DetailFormatter;
import com.aptana.ide.debug.core.IDetailFormattersChangeListener;
import com.aptana.ide.debug.core.JSDebugOptionsManager;
import com.aptana.ide.debug.core.JSDebugPlugin;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;

public final class JSDetailFormattersManager
implements Preferences.IPropertyChangeListener {
    public static final String DETAIL_FORMATTER_IS_ENABLED = "1";
    public static final String DETAIL_FORMATTER_IS_DISABLED = "0";
    private static JSDetailFormattersManager fgDefault;
    private ListenerList changeListeners = new ListenerList();
    private HashMap<String, DetailFormatter> fDetailFormattersMap;

    private JSDetailFormattersManager() {
        this.populateDetailFormattersMap();
        JSDebugPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public static JSDetailFormattersManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new JSDetailFormattersManager();
        }
        return fgDefault;
    }

    private void populateDetailFormattersMap() {
        String[] detailFormattersList = JSDebugOptionsManager.parseList(JSDebugPlugin.getDefault().getPluginPreferences().getString("com.aptana.ide.debug.core.detail_formatters"));
        this.fDetailFormattersMap = new HashMap(detailFormattersList.length / 3);
        int i = 0;
        int length = detailFormattersList.length;
        while (i < length) {
            String typeName = detailFormattersList[i++];
            String snippet = detailFormattersList[i++].replace('\u0000', ',');
            boolean enabled = !DETAIL_FORMATTER_IS_DISABLED.equals(detailFormattersList[i++]);
            this.fDetailFormattersMap.put(typeName, new DetailFormatter(typeName, snippet, enabled));
        }
    }

    public Collection getDetailFormatters() {
        return this.fDetailFormattersMap.values();
    }

    public void setDetailFormatters(Collection formatters) {
        this.fDetailFormattersMap.clear();
        for (DetailFormatter formatter : formatters) {
            this.fDetailFormattersMap.put(formatter.getTypeName(), formatter);
        }
        this.savePreference();
    }

    public void setAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.put(detailFormatter.getTypeName(), detailFormatter);
        this.savePreference();
    }

    public void removeAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.remove(detailFormatter.getTypeName());
        this.savePreference();
    }

    public boolean hasAssociatedDetailFormatter(String typeName) {
        return this.fDetailFormattersMap.containsKey(typeName);
    }

    public DetailFormatter getAssociatedDetailFormatter(String typeName) {
        return this.fDetailFormattersMap.get(typeName);
    }

    private void savePreference() {
        Collection<DetailFormatter> valuesList = this.fDetailFormattersMap.values();
        String[] values = new String[valuesList.size() * 3];
        int i = 0;
        for (DetailFormatter detailFormatter : valuesList) {
            values[i++] = detailFormatter.getTypeName();
            values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
            String string = values[i++] = detailFormatter.isEnabled() ? DETAIL_FORMATTER_IS_ENABLED : DETAIL_FORMATTER_IS_DISABLED;
        }
        String pref = JSDebugOptionsManager.serializeList(values);
        JSDebugPlugin.getDefault().getPluginPreferences().setValue("com.aptana.ide.debug.core.detail_formatters", pref);
        JSDebugPlugin.getDefault().savePluginPreferences();
    }

    public void addChangeListener(IDetailFormattersChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(IDetailFormattersChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    private void notifyChangeListeners() {
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDetailFormattersChangeListener)listeners[i]).detailFormattersChanged();
            ++i;
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if ("com.aptana.ide.debug.core.detail_formatters".equals(event.getProperty())) {
            this.populateDetailFormattersMap();
            this.notifyChangeListeners();
        }
    }
}

