/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.internal.core.CompositeResourceResolver;
import com.aptana.ide.debug.internal.core.model.Messages;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.http.HttpServerException;
import com.aptana.ide.server.http.RequestLineParser;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import com.aptana.ide.server.resources.IHttpResource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public class HttpServerProcess
extends PlatformObject
implements IProcess,
IDebugEventSetListener {
    private ILaunch launch;
    private ILaunchListener launchListener;
    private IDebugTarget debugTarget;
    private String label;
    private HttpServer server;
    private URL baseUrl;
    private CompositeResourceResolver resourceResolver;

    public HttpServerProcess(ILaunch launch) throws DebugException {
        this.launch = launch;
        this.launchListener = new ILaunchListener(){

            public void launchRemoved(ILaunch launch) {
                if (HttpServerProcess.this.launch == launch) {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
                }
            }

            public void launchAdded(ILaunch launch) {
                if (!"run".equals(launch.getLaunchMode())) {
                    return;
                }
                IProcess[] processes = HttpServerProcess.this.launch.getProcesses();
                boolean terminated = true;
                int i = 0;
                while (i < processes.length) {
                    if (processes[i] != HttpServerProcess.this && !processes[i].isTerminated()) {
                        terminated = false;
                        break;
                    }
                    ++i;
                }
                if (terminated) {
                    HttpServerProcess.this.handleTerminate();
                }
            }

            public void launchChanged(ILaunch launch) {
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.launchListener);
        String serverAddress = HttpServer.getServerAddress();
        int[] portRange = HttpServer.getPortRange();
        this.server = new HttpServer(new IHttpResourceResolver(){

            public IHttpResource getResource(RequestLineParser requestLine) throws HttpServerException {
                return HttpServerProcess.this.resourceResolver.getResource(requestLine);
            }
        }, portRange[0], portRange[1]);
        try {
            this.server.start();
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
        try {
            this.baseUrl = new URL("http", serverAddress, this.server.getPort(), "/");
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        this.label = StringUtils.format((String)Messages.HttpServerProcess_LocalHTTPServer_0, (String)this.baseUrl.toExternalForm());
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public URL getBaseURL() {
        return this.baseUrl;
    }

    public void setServerRoot(File rootDir) {
        this.resourceResolver = new CompositeResourceResolver();
        this.resourceResolver.addPath("/", rootDir);
    }

    public void addServerPath(String path, File dir) {
        this.resourceResolver.addPath(path, dir);
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.server == null;
    }

    public void terminate() throws DebugException {
        try {
            this.shutdownServer();
        }
        finally {
            this.fireTerminateEvent();
        }
    }

    private void shutdownServer() throws DebugException {
        if (this.server == null) {
            return;
        }
        try {
            try {
                this.server.stop();
            }
            catch (IOException e) {
                this.throwDebugException(e);
                this.server = null;
            }
        }
        finally {
            this.server = null;
        }
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireTerminateEvent() {
        if (DebugPlugin.getDefault() != null) {
            this.fireEvent(new DebugEvent((Object)this, 8));
        }
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    protected void throwDebugException(Exception exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "com.aptana.ide.debug.core", 5012, "", (Throwable)exception));
    }

    protected void setDebugTarget(IDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    private IDebugTarget getDebugTarget() {
        if (this.debugTarget == null) {
            this.debugTarget = this.launch.getDebugTarget();
        }
        return this.debugTarget;
    }

    private void handleTerminate() {
        try {
            this.shutdownServer();
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        this.fireTerminateEvent();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.launchListener);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 8: {
                    Object source = event.getSource();
                    if (!source.equals(this.getDebugTarget())) break;
                    this.handleTerminate();
                }
            }
            ++i;
        }
    }
}

