/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PathUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.MarkerUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.model.IJSExceptionBreakpoint;
import com.aptana.ide.debug.internal.core.model.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public class JSDebugExceptionBreakpoint
extends Breakpoint
implements IJSExceptionBreakpoint {
    public JSDebugExceptionBreakpoint() {
    }

    public JSDebugExceptionBreakpoint(IResource resource, String exceptionTypeName) throws CoreException {
        this(resource, exceptionTypeName, new HashMap(), true);
    }

    public JSDebugExceptionBreakpoint(IUniformResource resource, String exceptionTypeName) throws CoreException {
        this(resource, exceptionTypeName, new HashMap(), true);
    }

    public JSDebugExceptionBreakpoint(final IResource resource, final String exceptionTypeName, final Map attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.aptana.ide.debug.core.exceptionBreakpointMarker");
                JSDebugExceptionBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("com.aptana.ide.debug.core.exceptionTypeName", exceptionTypeName);
                attributes.put("org.eclipse.debug.core.id", JSDebugExceptionBreakpoint.this.getModelIdentifier());
                attributes.put("message", StringUtils.format((String)Messages.JSDebugExceptionBreakpoint_JSExceptionBreakpoint_0_1, (Object[])new String[]{resource.getFullPath().lastSegment(), exceptionTypeName}));
                JSDebugExceptionBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugExceptionBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public JSDebugExceptionBreakpoint(final IUniformResource resource, final String exceptionTypeName, final Map attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = MarkerUtils.createMarker((IUniformResource)resource, (Map)attributes, (String)"com.aptana.ide.debug.core.exceptionBreakpointMarker");
                JSDebugExceptionBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("com.aptana.ide.debug.core.exceptionTypeName", exceptionTypeName);
                attributes.put("org.eclipse.debug.core.id", JSDebugExceptionBreakpoint.this.getModelIdentifier());
                attributes.put("message", StringUtils.format((String)Messages.JSDebugExceptionBreakpoint_JSExceptionBreakpoint_0_1, (Object[])new String[]{PathUtils.getPath((Object)resource), exceptionTypeName}));
                JSDebugExceptionBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugExceptionBreakpoint.this.register(register);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)Messages.JSDebugExceptionBreakpoint_BreakpointMarkerCreationFailed, (Throwable)e);
        }
    }

    public String getModelIdentifier() {
        return "com.aptana.ide.debug.core";
    }

    private void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public String getExceptionTypeName() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.ide.debug.core.exceptionTypeName", "");
        }
        return "";
    }
}

