/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.sourcelookup;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.UniformResourceStorage;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.internal.core.IFileContentRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public class RemoteFileStorage
extends UniformResourceStorage {
    private URI fURI;
    private IFileContentRetriever fRetriever;
    private InputStream fIn;

    public RemoteFileStorage(URI uri, IFileContentRetriever retriever) {
        this.fURI = uri;
        this.fRetriever = retriever;
    }

    protected void setFileContentRetriever(IFileContentRetriever retriever) {
        this.fRetriever = retriever;
        if (retriever != null) {
            this.fIn = null;
        }
    }

    protected IFileContentRetriever getFileContentRetriever() {
        return this.fRetriever;
    }

    public boolean isValid() {
        return this.fIn != null || super.isValid();
    }

    public InputStream getContents() throws CoreException {
        if (this.fIn == null && this.fRetriever != null) {
            this.fIn = this.fRetriever.getContents(this.fURI);
        }
        if (this.fIn != null) {
            try {
                if (this.fIn.markSupported()) {
                    this.fIn.reset();
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
            return this.fIn;
        }
        return super.getContents();
    }

    public boolean exists() {
        if (this.fRetriever != null) {
            return true;
        }
        return super.exists();
    }

    public URI getURI() {
        return this.fURI;
    }

    public String getName() {
        URI uri;
        String name = super.getName();
        if (name.length() == 0 && (uri = this.getURI()) != null) {
            int index;
            String scheme = uri.getScheme();
            if (scheme.startsWith("http")) {
                name = "default.html";
            } else if ("dbgsource".equals(scheme) && (index = (name = uri.getSchemeSpecificPart()).lastIndexOf(47)) >= 0) {
                name = name.substring(index + 1);
            }
        }
        return name;
    }
}

