/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.xhr;

import com.aptana.ide.debug.core.xhr.IHeader;
import com.aptana.ide.debug.core.xhr.IXHRTransfer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class XHRTransfer
implements IXHRTransfer {
    private String method;
    private String url;
    private boolean auth;
    private List<IHeader> requestHeaders = new ArrayList<IHeader>();
    private List<IHeader> responseHeaders = new ArrayList<IHeader>();
    private String requestBody;
    private String responseBody;
    private Date requestDate;
    private Date responseDate;
    private int statusCode;
    private String statusText;
    private boolean error;

    public XHRTransfer(String method, String url, boolean auth) {
        this.method = method;
        this.url = url;
        this.auth = auth;
    }

    public String getURL() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public IHeader[] getRequestHeaders() {
        return this.requestHeaders.toArray(new IHeader[this.requestHeaders.size()]);
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public IHeader[] getResponseHeaders() {
        return this.responseHeaders.toArray(new IHeader[this.responseHeaders.size()]);
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public boolean hasError() {
        return this.error;
    }

    public boolean isAuthenticated() {
        return this.auth;
    }

    protected void addRequestHeader(String name, String value) {
        this.requestHeaders.add(new Header(name, value));
    }

    protected void addResponseHeader(String name, String value) {
        this.responseHeaders.add(new Header(name, value));
    }

    protected void setRequestBody(String body) {
        this.requestBody = body;
        this.requestDate = new Date();
    }

    protected void setResponseBody(String body) {
        this.responseBody = body;
        this.responseDate = new Date();
    }

    protected void setResponseStatus(int statusCode, String statusText) {
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    protected void setError(boolean error) {
        this.error = error;
    }

    private class Header
    implements IHeader {
        private String name;
        private String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

