/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.desktop.integration.protocolhandler;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.SetExecutableBits;
import com.aptana.ide.desktop.integration.protocolhandler.Messages;
import com.aptana.ide.desktop.integration.protocolhandler.ProtocolHandlerActivator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;

public class ProtocolHandlerStartup
implements IStartup {
    private static final String ECLIPSE_LAUNCHER_TOKEN = Pattern.quote("@eclipse.launcher@");

    public void earlyStartup() {
        IPreferenceStore prefs = ProtocolHandlerStartup.getPluginActivator().getPreferenceStore();
        if (prefs.getBoolean("AptanaPluginInstallerProtocolHandlerRegistered") && !Boolean.getBoolean("ALWAYS_REGISTER_PROTOCOL")) {
            return;
        }
        prefs.setValue("AptanaPluginInstallerProtocolHandlerRegistered", true);
        if ("win32".equals(Platform.getOS())) {
            ProtocolHandlerStartup.registerOnWindows();
        } else if ("linux".equals(Platform.getOS())) {
            ProtocolHandlerStartup.registerOnLinux();
        } else if ("macosx".equals(Platform.getOS())) {
            ProtocolHandlerStartup.registerOnMac();
        }
    }

    public static void registerOnWindows() {
        block17: {
            File protocolhandlerFolder = ProtocolHandlerStartup.getProtocolHandlerFolder();
            if (protocolhandlerFolder == null) {
                return;
            }
            String eclipseLauncher = ProtocolHandlerStartup.getEclipseLauncherPath();
            if (eclipseLauncher == null) {
                return;
            }
            eclipseLauncher = Matcher.quoteReplacement(eclipseLauncher);
            File templateFile = new File(protocolhandlerFolder, "aptanaplugininstaller.reg.template");
            if (templateFile.exists()) {
                try {
                    File regFile = File.createTempFile("aptanaplugininstaller", ".reg");
                    IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)("aptanaplugininstaller: protocol registration file: " + regFile));
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(templateFile));
                        PrintWriter pr = new PrintWriter(new FileWriter(regFile));
                        try {
                            String aLine;
                            while ((aLine = br.readLine()) != null) {
                                aLine = aLine.replaceAll(ECLIPSE_LAUNCHER_TOKEN, eclipseLauncher);
                                pr.println(aLine);
                            }
                        }
                        finally {
                            pr.flush();
                            pr.close();
                            br.close();
                        }
                        if (PlatformUtils.isUserAdmin()) {
                            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                            processBuilder.command("cmd", "/C", "regedit.exe", "/s", regFile.getAbsolutePath());
                            IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)("Running : " + processBuilder));
                            Process process = processBuilder.start();
                            try {
                                int exitStatus = process.waitFor();
                                if (exitStatus != 0) {
                                    IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)(String.valueOf(processBuilder.toString()) + " Exist status : " + exitStatus));
                                }
                                break block17;
                            }
                            catch (InterruptedException e) {
                                IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
                            }
                            break block17;
                        }
                        PlatformUtils.runAsAdmin((String)"cmd", (String[])new String[]{"/C", "regedit.exe", "/s", regFile.getAbsolutePath()});
                    }
                    finally {
                        regFile.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void registerOnLinux() {
        File protocolhandlerFolder = ProtocolHandlerStartup.getProtocolHandlerFolder();
        if (protocolhandlerFolder == null) {
            return;
        }
        String eclipseLauncher = ProtocolHandlerStartup.getEclipseLauncherPath();
        if (eclipseLauncher == null) {
            return;
        }
        File templateFile = new File(protocolhandlerFolder, "registeraptanaplugininstall.sh.template");
        if (templateFile.exists()) {
            try {
                File regFile = File.createTempFile("registeraptanaplugininstall", ".sh");
                IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)("aptanaplugininstaller: protocol registration file: " + regFile));
                try {
                    BufferedReader br = new BufferedReader(new FileReader(templateFile));
                    PrintWriter pr = new PrintWriter(new FileWriter(regFile));
                    try {
                        String aLine;
                        while ((aLine = br.readLine()) != null) {
                            aLine = aLine.replaceAll(ECLIPSE_LAUNCHER_TOKEN, eclipseLauncher);
                            pr.println(aLine);
                        }
                    }
                    finally {
                        pr.flush();
                        pr.close();
                        br.close();
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    processBuilder.command("/bin/bash", "--norc", "--noprofile", regFile.getAbsolutePath());
                    IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)("Running : " + processBuilder));
                    try {
                        Process process = processBuilder.start();
                        int exitStatus = process.waitFor();
                        if (exitStatus != 0) {
                            IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)(String.valueOf(processBuilder.toString()) + " Exist status : " + exitStatus));
                        }
                    }
                    catch (InterruptedException e) {
                        IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    regFile.deleteOnExit();
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void registerOnMac() {
        block44: {
            protocolhandlerFolder = ProtocolHandlerStartup.getProtocolHandlerFolder();
            if (protocolhandlerFolder == null) {
                return;
            }
            eclipseLauncher = ProtocolHandlerStartup.getEclipseLauncherPath();
            if (eclipseLauncher == null) {
                return;
            }
            protocolApp = new File(protocolhandlerFolder, "AptanaStudio.app.jar");
            IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)MessageFormat.format(Messages.ProtocolHandlerStartup_INF_UnjarringApp, new Object[]{protocolApp}));
            input = null;
            try {
                input = new JarInputStream(new FileInputStream(protocolApp));
                b = new byte[10000];
                while ((entry = input.getNextJarEntry()) != null) {
                    contentFile = new File(protocolhandlerFolder, entry.toString());
                    if (!contentFile.getParentFile().exists()) {
                        contentFile.getParentFile().mkdirs();
                    }
                    if (entry.isDirectory()) {
                        contentFile.mkdir();
                        continue;
                    }
                    out = null;
                    try {
                        out = new FileOutputStream(contentFile);
                        while ((nread = input.read(b, 0, b.length)) >= 0) {
                            out.write(b, 0, nread);
                        }
                    }
                    catch (Throwable var9_15) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException v0) {}
                        }
                        throw var9_15;
                    }
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException v1) {}
                }
            }
            catch (FileNotFoundException e) {
                IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException v2) {}
                }
                break block44;
            }
            catch (IOException e) {
                try {
                    IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
                    ** if (input == null) goto lbl-1000
                }
                catch (Throwable var10_18) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException v4) {}
                    }
                    throw var10_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        input.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block44;
                }
            }
            if (input == null) break block44;
            try {
                input.close();
            }
            catch (IOException v5) {}
        }
        IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)MessageFormat.format(Messages.ProtocolHandlerStartup_INF_FinishedUnJar, new Object[]{protocolApp}));
        new SetExecutableBits(ProtocolHandlerActivator.getDefault().getBundle()).schedule();
        templateFile = new File(protocolhandlerFolder, "AptanaStudio.app/Contents/Resources/Scripts/API.sh.tmpl");
        if (templateFile.exists()) {
            try {
                regFile = new File(protocolhandlerFolder, "AptanaStudio.app/Contents/Resources/Scripts/AptanaPluginInstaller.sh");
                IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)("aptanaplugininstaller: protocol launcher file: " + regFile));
                br = new BufferedReader(new FileReader(templateFile));
                pr = new PrintWriter(new FileWriter(regFile));
                try {
                    while ((aLine = br.readLine()) != null) {
                        aLine = aLine.replaceAll(ProtocolHandlerStartup.ECLIPSE_LAUNCHER_TOKEN, eclipseLauncher);
                        pr.println(aLine);
                    }
                }
                finally {
                    pr.flush();
                    pr.close();
                    br.close();
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
            }
        }
        if ((templateFile = new File(protocolhandlerFolder, "AptanaStudio.app/Contents/Resources/Scripts/AOF.sh.tmpl")).exists()) {
            try {
                regFile = new File(protocolhandlerFolder, "AptanaStudio.app/Contents/Resources/Scripts/AptanaOpenFiles.sh");
                IdeLog.logInfo((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)("file open handler file: " + regFile));
                br = new BufferedReader(new FileReader(templateFile));
                pr = new PrintWriter(new FileWriter(regFile));
                try {
                    while ((aLine = br.readLine()) != null) {
                        aLine = aLine.replaceAll(ProtocolHandlerStartup.ECLIPSE_LAUNCHER_TOKEN, eclipseLauncher);
                        pr.println(aLine);
                    }
                }
                finally {
                    pr.flush();
                    pr.close();
                    br.close();
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static File getProtocolHandlerFolder() {
        File protocolhandlerFolder = null;
        URL protocolhandlerEntry = ProtocolHandlerActivator.getDefault().getBundle().getEntry("/protocolhandler");
        try {
            String protocolhandlerEntryPath;
            if (protocolhandlerEntry != null && (protocolhandlerEntryPath = FileLocator.toFileURL((URL)protocolhandlerEntry).getFile()) != null) {
                protocolhandlerFolder = new File(protocolhandlerEntryPath);
            }
        }
        catch (IOException iOException) {}
        if (protocolhandlerFolder == null || protocolhandlerFolder.exists() && !protocolhandlerFolder.isDirectory()) {
            IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)Messages.ProtocolHandlerStartup_ERR_CannotLocateProtocolhandler);
            return null;
        }
        return protocolhandlerFolder;
    }

    private static String getEclipseLauncherPath() {
        String eclipseLauncher = System.getProperty("eclipse.launcher");
        if (eclipseLauncher == null) {
            IdeLog.logError((Plugin)ProtocolHandlerStartup.getPluginActivator(), (String)Messages.ProtocolHandlerStartup_ERR_CannotLocateLauncher);
            return null;
        }
        return Matcher.quoteReplacement(eclipseLauncher);
    }

    private static ProtocolHandlerActivator getPluginActivator() {
        return ProtocolHandlerActivator.getDefault();
    }
}

