/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.internal.update.manager;

import com.aptana.ide.internal.update.manager.Messages;
import com.aptana.ide.update.Activator;
import com.aptana.ide.update.manager.IPluginManager;
import com.aptana.ide.update.manager.Plugin;
import com.aptana.ide.update.manager.PluginListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluginManager
implements IPluginManager,
IEclipsePreferences.IPreferenceChangeListener {
    protected static final String FEATURE_IU_SUFFIX = ".feature.group";
    private static final String CACHED_PLUGINS_XML_FILENAME = "cached_plugins.xml";
    private static final int DAY = 86400000;
    private final Set<PluginListener> listeners = new HashSet<PluginListener>();
    private String fgRemotePluginsURL;
    private long lastUpdated = -1L;

    protected AbstractPluginManager() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.ide.update");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    @Override
    public void addListener(PluginListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<PluginListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void removeListener(PluginListener pluginsListener) {
        this.listeners.remove(pluginsListener);
    }

    @Override
    public List<Plugin> getRemotePlugins() {
        ArrayList<Plugin> plugins = new ArrayList();
        try {
            InputStream xml = (InputStream)this.getLocalURL().getContent();
            plugins = AbstractPluginManager.parseXML(xml);
            AbstractPluginManager.loadImages(plugins);
        }
        catch (IOException iOException) {
            plugins = new ArrayList();
        }
        if (this.haventUpdatedInADay()) {
            this.scheduleLoadOfRemotePluginListing();
        }
        return plugins;
    }

    private void scheduleLoadOfRemotePluginListing() {
        Job job = new Job(Messages.PluginsManager_RemoteJobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        InputStream in = (InputStream)AbstractPluginManager.this.getURL(AbstractPluginManager.this.getRemotePluginsURL()).getContent();
                        AbstractPluginManager.this.saveCache(in);
                        AbstractPluginManager.this.cacheImages();
                    }
                    catch (IOException e) {
                        AbstractPluginManager.error(e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        AbstractPluginManager.this.lastUpdated = System.currentTimeMillis();
                        return iStatus;
                    }
                }
                finally {
                    AbstractPluginManager.this.lastUpdated = System.currentTimeMillis();
                }
                for (PluginListener listener : AbstractPluginManager.this.listeners) {
                    listener.remotePluginsRefreshed();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(10000L);
    }

    protected String getRemotePluginsURL() {
        if (this.fgRemotePluginsURL == null) {
            String location = System.getProperty("PLUGINS_XML_LOCATION");
            if (location == null || location.length() == 0) {
                String defaultURL = new DefaultScope().getNode("com.aptana.ide.update").get("com.aptana.ide.update.REMOTE_PLUGIN_LISTING_URL", "");
                location = Platform.getPreferencesService().getString("com.aptana.ide.update", "com.aptana.ide.update.REMOTE_PLUGIN_LISTING_URL", defaultURL, null);
            }
            this.fgRemotePluginsURL = location;
        }
        return this.fgRemotePluginsURL;
    }

    private void cacheImages() {
        List<Object> plugins = new ArrayList();
        try {
            InputStream xml = (InputStream)this.getLocalCacheURL().getContent();
            plugins = AbstractPluginManager.parseXML(xml);
        }
        catch (IOException iOException) {
            plugins = new ArrayList();
        }
        ImageLoader loader = new ImageLoader();
        IPath directory = Activator.getDefault().getStateLocation();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        for (Plugin plugin : plugins) {
            OutputStream out;
            String imagePath;
            block18: {
                imagePath = plugin.getImagePath();
                if (imagePath == null) continue;
                out = null;
                ImageDescriptor image = Activator.getImageDescriptor(imagePath);
                if (image == null) {
                    image = ImageDescriptor.createFromURL((URL)this.getURL(imagePath));
                }
                loader.data = new ImageData[1];
                loader.data[0] = image.getImageData();
                if (loader.data[0] != null) break block18;
                try {
                    if (out == null) continue;
                    out.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            try {
                try {
                    String id = plugin.getId();
                    String ext = AbstractPluginManager.getExtension(imagePath);
                    File newFile = directory.append(String.valueOf(id) + ext).toFile();
                    newFile.createNewFile();
                    out = new FileOutputStream(newFile);
                    loader.save(out, AbstractPluginManager.getImageFormat(ext));
                    urlMap.put(imagePath, newFile.toString());
                }
                catch (IOException e) {
                    AbstractPluginManager.error(e);
                    try {
                        if (out == null) continue;
                        out.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (out == null) continue;
                out.close();
            }
            catch (IOException iOException) {}
        }
        AbstractPluginManager.saveImageURLMap(urlMap);
    }

    private static void saveImageURLMap(Map<String, String> map) {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.ide.update");
        for (String key : map.keySet()) {
            prefs.put(key, map.get(key));
        }
    }

    private static String getExtension(String filename) {
        int index = filename.lastIndexOf(".");
        return index < 0 ? "" : filename.substring(index);
    }

    private static int getImageFormat(String extension) {
        if (extension.equals(".png")) {
            return 5;
        }
        if (extension.equals(".gif")) {
            return 2;
        }
        if (extension.equals(".bmp")) {
            return 0;
        }
        if (extension.equals(".jpg")) {
            return 4;
        }
        return 3;
    }

    private boolean haventUpdatedInADay() {
        return this.lastUpdated < System.currentTimeMillis() - 86400000L;
    }

    private URL getURL(String location) throws MalformedURLException {
        try {
            return new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            return new File(location).toURI().toURL();
        }
    }

    /*
     * Exception decompiling
     */
    private static List<Plugin> parseXML(InputStream xml) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void loadImages(List<Plugin> plugins) {
        IPreferencesService service = Platform.getPreferencesService();
        for (Plugin plugin : plugins) {
            String cachedPath;
            String imagePath = plugin.getImagePath();
            if (imagePath == null || (cachedPath = service.getString("com.aptana.ide.update", imagePath, "", null)) == null || cachedPath.length() <= 0) continue;
            plugin.setImagePath(cachedPath);
        }
    }

    private URL getLocalURL() throws MalformedURLException {
        try {
            return this.getLocalCacheURL();
        }
        catch (MalformedURLException malformedURLException) {
            return this.getOriginalFileURL();
        }
    }

    private URL getLocalCacheURL() throws MalformedURLException {
        return this.getLocalCacheFile().toURI().toURL();
    }

    private File getLocalCacheFile() {
        IPath statePath = Activator.getDefault().getStateLocation().append(this.getCacheFilename());
        File file = statePath.toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
                this.copyOriginalToCache();
            }
            catch (IOException e) {
                AbstractPluginManager.error(e);
            }
        }
        return file;
    }

    private String getCacheFilename() {
        return CACHED_PLUGINS_XML_FILENAME;
    }

    private URL getOriginalFileURL() throws MalformedURLException {
        String defaultURL = new DefaultScope().getNode("com.aptana.ide.update").get("com.aptana.ide.update.LOCAL_PLUGIN_LISTING_URL", "");
        return new URL(Platform.getPreferencesService().getString("com.aptana.ide.update", "com.aptana.ide.update.LOCAL_PLUGIN_LISTING_URL", defaultURL, null));
    }

    private void copyOriginalToCache() {
        try {
            InputStream in = (InputStream)this.getOriginalFileURL().getContent();
            this.saveCache(in);
        }
        catch (IOException e) {
            AbstractPluginManager.error(e);
        }
    }

    private static void error(Exception e) {
        Activator.log(4, e.getMessage(), e);
    }

    private void saveCache(InputStream xml) {
        block31: {
            File file = this.getLocalCacheFile();
            FileOutputStream writer = null;
            try {
                writer = new FileOutputStream(file);
                int b = -1;
                while ((b = xml.read()) != -1) {
                    ((OutputStream)writer).write(b);
                }
            }
            catch (FileNotFoundException e) {
                AbstractPluginManager.error(e);
                try {
                    if (xml != null) {
                        xml.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (writer != null) {
                        ((OutputStream)writer).close();
                    }
                    break block31;
                }
                catch (IOException iOException) {}
                break block31;
            }
            catch (IOException e) {
                try {
                    AbstractPluginManager.error(e);
                }
                catch (Throwable throwable) {
                    try {
                        if (xml != null) {
                            xml.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (writer != null) {
                            ((OutputStream)writer).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (xml != null) {
                        xml.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (writer != null) {
                        ((OutputStream)writer).close();
                    }
                    break block31;
                }
                catch (IOException iOException) {}
                break block31;
            }
            try {
                if (xml != null) {
                    xml.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (writer != null) {
                    ((OutputStream)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        File localCache;
        String key = event.getKey();
        if ("com.aptana.ide.update.REMOTE_PLUGIN_LISTING_URL".equals(key)) {
            this.fgRemotePluginsURL = null;
            this.scheduleLoadOfRemotePluginListing();
        } else if ("com.aptana.ide.update.LOCAL_PLUGIN_LISTING_URL".equals(key) && (localCache = this.getLocalCacheFile()) != null) {
            localCache.delete();
        }
    }
}

