/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.internal.update.manager;

import com.aptana.ide.update.Activator;
import com.aptana.ide.update.manager.InstallerCategory;
import com.aptana.ide.update.manager.Plugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsContentHandler
implements ContentHandler {
    private static final String YEAR = "year";
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String URL = "url";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String PLUGIN = "plugin";
    private static final String MORE = "more";
    private static final String CATEGORY = "category";
    private static final String SORTWEIGHT = "sortweight";
    private static final String ICON = "icon";
    private static final String REQUIRES = "requires";
    private static final String PARENT = "parent";
    private static final String COLLAPSE = "collapse";
    private static final String INSTALLER = "installer";
    private static final String INSTALLER_ID = "installer_id";
    private StringBuilder data;
    private Map<String, InstallerCategory> installerCategories;
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private URL url;
    private String version;
    private String name;
    private String description;
    private String id;
    private String category;
    private int sortweight;
    private int year;
    private int month;
    private int day;
    private String more;
    private String icon;
    private String requires;
    private String installerID;
    private String parentID;
    private boolean collapse;

    public PluginsContentHandler() {
        this.installerCategories = new HashMap<String, InstallerCategory>();
        this.sortweight = Integer.MAX_VALUE;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = start;
        while (i < start + length) {
            this.data.append(ch[i]);
            ++i;
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(URL)) {
            try {
                URL proj;
                this.url = proj = new URL(this.data.toString().trim());
            }
            catch (MalformedURLException e) {
                Activator.log(4, e.getMessage(), null);
            }
        } else if (qName.equals(NAME)) {
            this.name = this.data.toString().trim();
        } else if (qName.equals(ID)) {
            this.id = this.data.toString().trim();
        } else if (qName.equals(DESCRIPTION)) {
            this.description = this.data.toString().trim();
        } else if (qName.equals(CATEGORY)) {
            this.category = this.data.toString().trim();
        } else if (qName.equals(SORTWEIGHT)) {
            this.sortweight = Integer.parseInt(this.data.toString().trim());
        } else if (qName.equals(VERSION)) {
            this.version = this.data.toString().trim();
        } else if (qName.equals(YEAR)) {
            this.year = Integer.parseInt(this.data.toString().trim());
        } else if (qName.equals(MONTH)) {
            this.month = Integer.parseInt(this.data.toString().trim());
        } else if (qName.equals(DAY)) {
            this.day = Integer.parseInt(this.data.toString().trim());
        } else if (qName.equals(MORE)) {
            this.more = this.data.toString().trim();
        } else if (qName.equals(ICON)) {
            this.icon = this.data.toString().trim();
        } else if (qName.equals(REQUIRES)) {
            this.requires = this.data.toString().trim();
        } else if (qName.equals(INSTALLER_ID)) {
            this.installerID = this.data.toString().trim();
        } else if (qName.equals(PARENT)) {
            this.parentID = this.data.toString().trim();
        } else if (qName.equals(COLLAPSE)) {
            this.collapse = Boolean.parseBoolean(this.data.toString().trim());
        } else if (qName.equals(INSTALLER)) {
            InstallerCategory parent = null;
            if (this.parentID != null) {
                parent = this.installerCategories.get(this.parentID);
            }
            InstallerCategory installerCategory = new InstallerCategory(this.id, this.category, this.sortweight, parent, this.collapse);
            this.installerCategories.put(this.id, installerCategory);
        } else if (qName.equals(PLUGIN)) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.year);
            cal.set(2, this.month - 1);
            cal.set(5, this.day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.plugins.add(new Plugin(this.id, this.name, this.version, cal, this.description, this.url, this.more, this.category, this.sortweight, this.icon, this.requires, this.installerCategories.get(this.installerID)));
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.data = new StringBuilder();
        if (qName.equals(INSTALLER)) {
            this.clearInstallerData();
        } else if (qName.equals(PLUGIN)) {
            this.clearPluginData();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void clearInstallerData() {
        this.id = null;
        this.category = null;
        this.sortweight = 10;
        this.parentID = null;
        this.collapse = false;
    }

    private void clearPluginData() {
        this.url = null;
        this.version = null;
        this.name = null;
        this.description = null;
        this.id = null;
        this.category = null;
        this.sortweight = Integer.MAX_VALUE;
        this.year = 2010;
        this.month = 1;
        this.day = 1;
        this.more = null;
        this.icon = null;
        this.requires = null;
        this.installerID = null;
    }
}

