/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js;

import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSOffsetMapper;
import com.aptana.ide.editor.js.Messages;
import com.aptana.ide.editor.js.environment.LexemeBasedEnvironmentLoader;
import com.aptana.ide.editor.js.parsing.JSParseState;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.scriptdoc.ScriptDocHelper;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileContextListener;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.help.HelpResource;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.IDocumentationStore;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFileLanguageService
extends BaseFileLanguageService {
    private JSOffsetMapper _offsetMapper;
    private LexemeBasedEnvironmentLoader _loader;
    private IDocumentationStore _documentationStore;
    private IFileContextListener _delayedFileListener;

    public JSFileLanguageService(FileService fileService, final IParseState parseState, IParser parser, IParentOffsetMapper mapper) {
        super(fileService, parseState, parser, mapper);
        this.createOffsetMapper(mapper);
        this._loader = new LexemeBasedEnvironmentLoader((Environment)JSLanguageEnvironment.getInstance().getRuntimeEnvironment());
        this._delayedFileListener = new IFileContextListener(){

            public void onContentChanged(FileContextContentEvent evt) {
                JSParseState jsps;
                if (parseState.getFileIndex() == -1) {
                    JSFileLanguageService.this.reconnectToEnvironment();
                }
                if ((jsps = (JSParseState)parseState.getParseState(JSFileLanguageService.this.getDefaultLanguage())) != null) {
                    JSFileLanguageService.this._loader.reloadEnvironment((IParseState)jsps);
                }
            }
        };
        this.fileService.addDelayedFileListener(this._delayedFileListener);
    }

    public String getDocumentationTitleFromLexeme(Lexeme lexeme) {
        String title = Messages.JSFileLanguageService_Javascript_editor;
        if (lexeme == null) {
            return title;
        }
        String titleLower = lexeme.getText();
        if (lexeme.getCategoryIndex() == 3) {
            title = MessageFormat.format(Messages.JSFileLanguageService_0_keyword, titleLower);
        } else if (lexeme.getCategoryIndex() == 2) {
            title = MessageFormat.format(Messages.JSFileLanguageService_0_identifier, titleLower);
        }
        return title;
    }

    public HelpResource[] getDocumentationResourcesFromLexeme(Lexeme lexeme) {
        if (lexeme == null) {
            return new HelpResource[0];
        }
        ArrayList<HelpResource> topics = new ArrayList<HelpResource>();
        ArrayList<HelpResource> generalTopics = new ArrayList<HelpResource>();
        String lowerName = lexeme.getText().toLowerCase();
        if (lexeme.getCategoryIndex() == 3) {
            this.addKeywordHelpTopics(topics, generalTopics, lowerName);
        } else if (lexeme.getCategoryIndex() == 2) {
            this.addIdentifierHelpTopics(topics, generalTopics, lowerName);
        }
        if (generalTopics.size() == 0) {
            HelpResource index = new HelpResource(Messages.JSFileLanguageService_Javascript_core_reference, "/com.aptana.ide.documentation/html/reference/api/JSCore.index.html");
            generalTopics.add(index);
            index = new HelpResource(Messages.JSFileLanguageService_HTML_dom_0_reference, "/com.aptana.ide.documentation/html/reference/api/HTMLDOM0.index.html");
            generalTopics.add(index);
            index = new HelpResource(Messages.JSFileLanguageService_HTML_dom_1_2_reference, "/com.aptana.ide.documentation/html/reference/api/HTMLDOM2.index.html");
            generalTopics.add(index);
        }
        Iterator iter = generalTopics.iterator();
        while (iter.hasNext()) {
            topics.add((HelpResource)iter.next());
        }
        return topics.toArray(new HelpResource[0]);
    }

    private void addKeywordHelpTopics(List<HelpResource> topics, List<HelpResource> generalTopics, String lowerName) {
        HelpResource index = new HelpResource(Messages.JSFileLanguageService_11, "/com.aptana.ide.documentation/html/reference/api/JSKeywords.index.html");
        generalTopics.add(index);
    }

    private void addIdentifierHelpTopics(List<HelpResource> topics, List<HelpResource> generalTopics, String lowerName) {
    }

    public String getDocumentationFromLexeme(Lexeme lexeme) {
        if (lexeme == null) {
            return "";
        }
        Lexeme l = this.findPreviousValidLexeme(lexeme);
        if (l == null) {
            return "";
        }
        return ScriptDocHelper.getInformationForLexeme(this._offsetMapper, l, true);
    }

    public Lexeme getValidDocumentationLexeme(Lexeme lexeme) {
        return this.findPreviousValidLexeme(lexeme);
    }

    private Lexeme findPreviousValidLexeme(Lexeme lexeme) {
        if (lexeme.getCategoryIndex() == 2 || lexeme.getCategoryIndex() == 3) {
            return lexeme;
        }
        LexemeList ll = this.getFileContext().getLexemeList();
        if (ll == null) {
            return null;
        }
        Lexeme newLexeme = null;
        int index = ll.getLexemeIndex(lexeme);
        while (index > 0) {
            Lexeme l = ll.get(index);
            if (l == null) {
                return null;
            }
            if (l.getCategoryIndex() == 2 || l.getCategoryIndex() == 3) {
                newLexeme = l;
                break;
            }
            --index;
        }
        return newLexeme;
    }

    public IOffsetMapper getOffsetMapper() {
        return this._offsetMapper;
    }

    public void createOffsetMapper(IParentOffsetMapper parent) {
        this._offsetMapper = new JSOffsetMapper(parent);
    }

    public LexemeBasedEnvironmentLoader getEnvironmentLoader() {
        return this._loader;
    }

    public String getDefaultLanguage() {
        return "text/javascript";
    }

    public void reset(boolean resetFileIndex) {
        this._loader.unloadEnvironment();
        this.getParseState().reset();
        if (resetFileIndex) {
            this.getParseState().setFileIndex(-1);
        }
    }

    public void connectSourceProvider(IFileSourceProvider sourceProvider) {
    }

    public void disconnectSourceProvider(IFileSourceProvider sourceProvider) {
        this._loader.unloadEnvironment();
        this.getParseState().setFileIndex(-1);
        this._offsetMapper.dispose();
        this._offsetMapper = null;
        this._loader = null;
        this._documentationStore = null;
    }

    public IDocumentationStore getDocumentationStore() {
        return this._documentationStore;
    }

    public void setDocumentationStore(IDocumentationStore store) {
        this._documentationStore = store;
    }

    public static JSFileLanguageService getJSFileLanguageService(IFileService context) {
        return (JSFileLanguageService)context.getLanguageService("text/javascript");
    }

    public void activateForEditing() {
        super.activateForEditing();
    }

    public void deactivateForEditing() {
        super.deactivateForEditing();
        this._loader.unloadEnvironment();
    }
}

