/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.js.JSColorizer;
import com.aptana.ide.editor.js.JSFileLanguageService;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.Messages;
import com.aptana.ide.editor.js.environment.LexemeBasedEnvironmentLoader;
import com.aptana.ide.editor.js.parsing.JSParseState;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.FunctionBase;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.JSFunction;
import com.aptana.ide.editor.js.runtime.JSObjectConstructor;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.Reference;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.reader.NativeObjectsReader;
import com.aptana.ide.editor.scriptdoc.parsing.reader.NativeObjectsReader2;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.managers.EnvironmentManager;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.ILanguageEnvironment;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLanguageEnvironment
implements ILanguageEnvironment {
    private static ILanguageEnvironment instance;
    private Environment environment;
    private ObjectBase global;
    private boolean isEnvironmentLoaded = false;
    public static final String SCRIPTDOC_ID = "scriptdoc";
    public static final String TAG_BINARY_FILE = "binary-file";
    public static final String TAG_JS_FILE = "js-file";
    public static final String TAG_XML_FILE = "xml-file";
    public static final String ATTR_FILE_PATH = "path";
    public static final String ATTR_USER_AGENT = "user-agent";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_LOAD = "load";
    public static final String JS_CORE = "JS Core";
    public static final String DOM_5 = "DOM 5";
    public static final String DOM_3 = "DOM 3";
    public static final String DOM_1_2 = "DOM 1 & 2";
    public static final String DOM_0 = "DOM 0";
    public static int SLEEP_DELAY;
    public static boolean includeCore;
    public static boolean includeHtml0;
    public static boolean includeHtml12;
    public static boolean includeHtml3;
    public static boolean includeHtml5;
    private IObject undef = ObjectBase.UNDEFINED;

    static {
        SLEEP_DELAY = 2000;
        includeCore = false;
        includeHtml0 = false;
        includeHtml12 = false;
        includeHtml3 = false;
        includeHtml5 = false;
    }

    JSLanguageEnvironment() {
        this.initEnvironment();
        EnvironmentManager.addEnvironmentMapping((String)"text/javascript", (IRuntimeEnvironment)this.environment);
        EnvironmentManager.addEnvironmentMapping((String)"text/scriptdoc", (IRuntimeEnvironment)this.environment);
    }

    public static void rebuildEnvironment() {
        if (instance != null) {
            ((JSLanguageEnvironment)instance).buildEnvironment();
            EnvironmentManager.addEnvironmentMapping((String)"text/javascript", (IRuntimeEnvironment)JSLanguageEnvironment.getInstance().getRuntimeEnvironment());
            EnvironmentManager.addEnvironmentMapping((String)"text/scriptdoc", (IRuntimeEnvironment)JSLanguageEnvironment.getInstance().getRuntimeEnvironment());
        }
    }

    public static void resetEnvironment() {
        if (instance != null) {
            JSLanguageEnvironment.rebuildEnvironment();
            JSLanguageEnvironment.getInstance().cleanEnvironment();
            UnifiedEditorsPlugin.getDefault().getProfileManager().addLanguageSupport("text/javascript", JSLanguageEnvironment.getInstance(), null);
            UnifiedEditorsPlugin.getDefault().getProfileManager().onUpdaterThreadUpdate();
        }
    }

    public IRuntimeEnvironment getRuntimeEnvironment() {
        return this.environment;
    }

    public Environment getJSEnvironment() {
        return this.environment;
    }

    private void buildEnvironment() {
        this.isEnvironmentLoaded = false;
        this.global = this.environment.initBuiltInObjects();
        this.loadEnvironment();
    }

    private void initEnvironment() {
        this.environment = new Environment();
        this.global = this.environment.initBuiltInObjects();
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(SLEEP_DELAY);
                    JSLanguageEnvironment.this.loadEnvironment();
                }
                catch (Exception e1) {
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)"initEnvironment aborted", (Throwable)e1);
                }
            }
        }, "Aptana: JS Language Environment Loader");
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public static ILanguageEnvironment getInstance() {
        if (instance == null) {
            instance = new JSLanguageEnvironment();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanEnvironment() {
        JSLanguageEnvironment jSLanguageEnvironment = this;
        synchronized (jSLanguageEnvironment) {
            String[] keys = FileContextManager.getKeySet();
            int i = 0;
            while (i < keys.length) {
                String path = keys[i];
                FileService fileService = FileContextManager.get((String)path);
                if (fileService != null) {
                    JSFileLanguageService languageService;
                    IFileLanguageService jsfs = fileService.getLanguageService("text/javascript");
                    if (jsfs != null) {
                        jsfs.reset(false);
                    }
                    if ((languageService = JSFileLanguageService.getJSFileLanguageService((IFileService)fileService)) != null) {
                        languageService.reset(false);
                    }
                } else {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_FileServiceNull, (String)path));
                }
                Environment environment = this.environment;
                synchronized (environment) {
                    Map idProps = EnvironmentManager.getDocumentationRefMap();
                    for (Object o : idProps.values()) {
                        Reference reference = (Reference)o;
                        String propertyName = reference.getPropertyName();
                        IObject parentObject = reference.getObjectBase();
                        parentObject.deletePropertyName(propertyName);
                    }
                    idProps.clear();
                    EnvironmentManager.getDocumentationIdMap().clear();
                }
                ++i;
            }
        }
    }

    public void loadEnvironment() {
        if (this.isEnvironmentLoaded) {
            return;
        }
        this.isEnvironmentLoaded = true;
        Map<String, TextAttribute> htmlIdents = JSColorizer.htmlIdents;
        Map<String, TextAttribute> jsCoreIdents = JSColorizer.jsCoreIdents;
        ObjectBase gb = this.global;
        Environment env = this.environment;
        NativeObjectsReader reader = new NativeObjectsReader(env);
        try {
            int fileIndex = Integer.MIN_VALUE;
            int offset = Range.Empty.getStartingOffset();
            String[] envs = JSLanguageEnvironment.getLoadedEnvironments();
            includeHtml5 = false;
            includeHtml3 = false;
            includeHtml12 = false;
            includeHtml0 = false;
            int i = 0;
            while (i < envs.length) {
                if (DOM_5.equals(envs[i])) {
                    includeHtml5 = true;
                }
                if (DOM_3.equals(envs[i])) {
                    includeHtml3 = true;
                }
                if (DOM_1_2.equals(envs[i])) {
                    includeHtml12 = true;
                } else if (DOM_0.equals(envs[i])) {
                    includeHtml0 = true;
                }
                ++i;
            }
            includeCore = true;
            gb.putPropertyValue("this", gb, fileIndex, 6);
            if (includeCore) {
                InputStream jsIn = this.getClass().getResourceAsStream("/com/aptana/ide/editor/js/parsing/js_core.bin");
                reader.setUserAgent(JS_CORE);
                reader.load(jsIn, false);
                jsCoreIdents.putAll(reader.getNames());
                jsIn.close();
                JSObjectConstructor gObj = (JSObjectConstructor)gb.getPropertyValue("Object", fileIndex, offset);
                IObject newobj = gObj.construct(env, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty);
                gb.putPropertyValue("prototype", newobj, fileIndex, 6);
                gb.setPrototype(gb.getPropertyValue("prototype", fileIndex, offset));
            }
            if (includeHtml0) {
                gb.putPropertyValue("window", gb, fileIndex, 6);
                gb.putPropertyValue("Window", gb, fileIndex, 30);
                InputStream dom0 = this.getClass().getResourceAsStream("/com/aptana/ide/editor/js/parsing/dom_0.bin");
                reader.setUserAgent(DOM_0);
                reader.load(dom0, true);
                htmlIdents.putAll(reader.getNames());
                dom0.close();
                htmlIdents.put("window", null);
            }
            if (includeHtml12) {
                InputStream dom2 = this.getClass().getResourceAsStream("/com/aptana/ide/editor/js/parsing/dom_2.bin");
                reader.setUserAgent(DOM_1_2);
                reader.load(dom2, true);
                htmlIdents.putAll(reader.getNames());
                dom2.close();
                IObject hdoc = gb.getPropertyValue("HTMLDocument", fileIndex, offset);
                if (hdoc != this.undef) {
                    JSFunction htmldocFn = (JSFunction)hdoc;
                    IObject doc = htmldocFn.construct(env, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty);
                    gb.putPropertyValue("document", doc, fileIndex, 6);
                    ((FunctionDocumentation)htmldocFn.getDocumentation()).setIsInstance(true);
                    doc.setDocumentation(htmldocFn.getDocumentation());
                }
                htmlIdents.put("document", null);
            }
            if (includeHtml3) {
                InputStream dom3 = this.getClass().getResourceAsStream("/com/aptana/ide/editor/js/parsing/dom_3.bin");
                reader.setUserAgent(DOM_3);
                reader.load(dom3, true);
                htmlIdents.putAll(reader.getNames());
                dom3.close();
            }
            if (includeHtml5) {
                InputStream dom5 = this.getClass().getResourceAsStream("/com/aptana/ide/editor/js/parsing/dom_5.bin");
                reader.setUserAgent(DOM_5);
                reader.load(dom5, true);
                htmlIdents.putAll(reader.getNames());
                dom5.close();
            }
            try {
                this.loadContributedFiles();
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.JSLanguageEnvironment_ErrorLoadingEnvironment, (Throwable)e);
            }
        }
        catch (IOException e) {
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.JSLanguageEnvironment_ErrorLoadingEnvironment, (Throwable)e);
        }
    }

    public static void enableEnvironment(String environmentName) {
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        String[] envsToLoad = JSLanguageEnvironment.getEnabledEnvironments();
        String[] envsToDisable = JSLanguageEnvironment.getDisabledEnvironments();
        HashSet<String> envs = new HashSet<String>();
        envs.addAll(Arrays.asList(envsToLoad));
        HashSet<String> disabledEnvs = new HashSet<String>();
        disabledEnvs.addAll(Arrays.asList(envsToDisable));
        if (!envs.contains(environmentName)) {
            envs.add(environmentName);
        }
        if (disabledEnvs.contains(environmentName)) {
            disabledEnvs.remove(environmentName);
        }
        store.setValue("com.aptana.ide.editor.js.LOADED_ENVIRONMENTS", StringUtils.join((String)",", (String[])envs.toArray(new String[0])));
        store.setValue("com.aptana.ide.editor.js.DISABLED_ENVIRONMENTS", StringUtils.join((String)",", (String[])disabledEnvs.toArray(new String[0])));
    }

    public static void disableEnvironment(String environmentName) {
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        String[] envsToLoad = JSLanguageEnvironment.getEnabledEnvironments();
        String[] envsToDisable = JSLanguageEnvironment.getDisabledEnvironments();
        HashSet<String> envs = new HashSet<String>();
        envs.addAll(Arrays.asList(envsToLoad));
        HashSet<String> disabledEnvs = new HashSet<String>();
        disabledEnvs.addAll(Arrays.asList(envsToDisable));
        if (envs.contains(environmentName)) {
            envs.remove(environmentName);
        }
        if (!disabledEnvs.contains(environmentName)) {
            disabledEnvs.add(environmentName);
        }
        store.setValue("com.aptana.ide.editor.js.LOADED_ENVIRONMENTS", StringUtils.join((String)",", (String[])envs.toArray(new String[0])));
        store.setValue("com.aptana.ide.editor.js.DISABLED_ENVIRONMENTS", StringUtils.join((String)",", (String[])disabledEnvs.toArray(new String[0])));
    }

    public static String[] getLoadedEnvironments() {
        String[] loaded = JSLanguageEnvironment.getEnabledEnvironments();
        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_INF_Enabled_environments, (String)StringUtils.join((String)",", (String[])loaded)));
        HashSet<String> envs = new HashSet<String>();
        envs.addAll(Arrays.asList(loaded));
        String[] defaults = JSLanguageEnvironment.getDefaultLoadedEnvironments();
        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_INF_Default_loaded_environments, (String)StringUtils.join((String)",", (String[])defaults)));
        envs.addAll(Arrays.asList(defaults));
        String[] disabled = JSLanguageEnvironment.getDisabledEnvironments();
        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_INF_Disabled_environments, (String)StringUtils.join((String)",", (String[])disabled)));
        envs.removeAll(Arrays.asList(disabled));
        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_INF_Resulting_set, (String)StringUtils.join((String)",", (String[])envs.toArray(new String[0]))));
        return envs.toArray(new String[0]);
    }

    public static String[] getEnabledEnvironments() {
        String envsToLoad = JSPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.js.LOADED_ENVIRONMENTS");
        if (envsToLoad != null) {
            return envsToLoad.split(",");
        }
        return new String[0];
    }

    public static String[] getDisabledEnvironments() {
        String envsToDisable = JSPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.js.DISABLED_ENVIRONMENTS");
        if (envsToDisable != null) {
            return envsToDisable.split(",");
        }
        return new String[0];
    }

    public static void setEnabledEnvironments(String[] environments) {
        String env = StringUtils.join((String)",", (String[])environments);
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        store.setValue("com.aptana.ide.editor.js.LOADED_ENVIRONMENTS", env);
    }

    public static void setDisabledEnvironments(String[] environments) {
        String env = StringUtils.join((String)",", (String[])environments);
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        store.setValue("com.aptana.ide.editor.js.DISABLED_ENVIRONMENTS", env);
    }

    public static void addUserEnvironment(String toAdd) {
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        String value = store.getString("com.aptana.ide.editor.js.ADDED_ENVIRONMENTS");
        value = String.valueOf(value) + "," + toAdd;
        store.setValue("com.aptana.ide.editor.js.ADDED_ENVIRONMENTS", value);
    }

    public static void removeUserEnvironment(String toRemove) {
        String[] envs = JSLanguageEnvironment.getUserAddedJSEnvironments();
        ArrayList<String> newEnvs = new ArrayList<String>();
        int i = 0;
        while (i < envs.length) {
            if (!envs[i].equals(toRemove) && !newEnvs.contains(envs[i])) {
                newEnvs.add(envs[i]);
            }
            ++i;
        }
        String toSet = StringUtils.join((String)",", (String[])newEnvs.toArray(new String[0]));
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        store.setValue("com.aptana.ide.editor.js.ADDED_ENVIRONMENTS", toSet);
    }

    public static String[] getUserAddedJSEnvironments() {
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        String jsEnv = store.getString("com.aptana.ide.editor.js.ADDED_ENVIRONMENTS");
        return jsEnv.split(",");
    }

    public static String[] getDefaultLoadedEnvironments() {
        String defaultEnvsToLoad = JSPlugin.getDefault().getPreferenceStore().getDefaultString("com.aptana.ide.editor.js.LOADED_ENVIRONMENTS");
        ArrayList<String> list = new ArrayList<String>();
        String[] envs = defaultEnvsToLoad.split(",");
        list.addAll(Arrays.asList(envs));
        envs = JSLanguageEnvironment.getLoadedEnvironmentsFromExtension(TAG_BINARY_FILE);
        list.addAll(Arrays.asList(envs));
        envs = JSLanguageEnvironment.getLoadedEnvironmentsFromExtension(TAG_XML_FILE);
        list.addAll(Arrays.asList(envs));
        envs = JSLanguageEnvironment.getLoadedEnvironmentsFromExtension(TAG_JS_FILE);
        list.addAll(Arrays.asList(envs));
        return list.toArray(new String[0]);
    }

    private void addContributedXML(NativeObjectsReader2 reader, URL key, String userAgent) {
        if (userAgent != null) {
            reader.setUserAgent(userAgent);
        }
        try {
            reader.loadXML(key.openStream());
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_INF_Loaded_environment, (String)key.toExternalForm()));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.JSLanguageEnvironment_ErrorLoadingEnvironment, (Throwable)e);
        }
    }

    private void addContributedBinary(NativeObjectsReader2 reader, URL key, String userAgent) {
        if (userAgent != null) {
            reader.setUserAgent(userAgent);
        }
        try {
            reader.load(key.openStream());
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_INF_Loaded_environment, (String)key.toExternalForm()));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.JSLanguageEnvironment_ErrorLoadingEnvironment, (Throwable)e);
        }
    }

    private void addContributedJS(URL key, String userAgent) {
        if (!(DOM_5.equals(userAgent) || DOM_3.equals(userAgent) || DOM_1_2.equals(userAgent) || DOM_0.equals(userAgent))) {
            try {
                key = FileLocator.toFileURL((URL)key);
            }
            catch (IOException iOException) {}
            String path = CoreUIUtils.getPathFromURI((String)key.getFile());
            try {
                String source = FileUtils.readContent((File)new File(path));
                IParser parser = LanguageRegistry.getParser((String)"text/javascript");
                JSParseState parseState = (JSParseState)parser.createParseState(null);
                parseState.setEditState(source, source, 0, 0);
                parseState.setFileIndex(Integer.MAX_VALUE);
                parser.parse((IParseState)parseState);
                LexemeBasedEnvironmentLoader loader = new LexemeBasedEnvironmentLoader(this.environment);
                loader.reloadEnvironment((IParseState)parseState);
                IDocumentation[] docs = parseState.getDocumentationStore().getDocumentationObjects();
                if (docs != null) {
                    int i = 0;
                    while (i < docs.length) {
                        docs[i].setUserAgent(userAgent);
                        ++i;
                    }
                }
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_INF_Loaded_environment, (String)key.toExternalForm()));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_ERR_Loading_contributed_javascript_file, (String)key.toExternalForm()), (Throwable)e);
            }
        }
    }

    private void loadContributedFiles() {
        Hashtable<URL, String> xmlFiles = new Hashtable<URL, String>();
        JSLanguageEnvironment.addFromExtension(xmlFiles, TAG_XML_FILE);
        NativeObjectsReader2 reader = new NativeObjectsReader2(this.environment);
        Set keys = xmlFiles.keySet();
        for (URL key : keys) {
            String userAgent = (String)xmlFiles.get(key);
            this.addContributedXML(reader, key, userAgent);
        }
        Hashtable<URL, String> binaryFiles = new Hashtable<URL, String>();
        JSLanguageEnvironment.addFromExtension(binaryFiles, TAG_BINARY_FILE);
        keys = binaryFiles.keySet();
        for (URL key : keys) {
            String userAgent = (String)binaryFiles.get(key);
            this.addContributedBinary(reader, key, userAgent);
        }
        Hashtable<URL, String> jsFiles = new Hashtable<URL, String>();
        JSLanguageEnvironment.addFromExtension(jsFiles, TAG_JS_FILE);
        keys = jsFiles.keySet();
        for (URL key : keys) {
            String userAgent = (String)jsFiles.get(key);
            this.addContributedJS(key, userAgent);
        }
        Hashtable<URL, String> userXMLFiles = new Hashtable<URL, String>();
        JSLanguageEnvironment.addUserContributedFiles(userXMLFiles, "com.aptana.ide.editor.js.ADDED_ENVIRONMENTS");
        keys = userXMLFiles.keySet();
        for (URL key : keys) {
            String userAgent = (String)userXMLFiles.get(key);
            String keyValue = key.toExternalForm();
            if (keyValue.endsWith(".js") || keyValue.endsWith(".sdoc")) {
                this.addContributedJS(key, userAgent);
                continue;
            }
            if (keyValue.endsWith(".bin")) {
                this.addContributedBinary(reader, key, userAgent);
                continue;
            }
            if (!keyValue.endsWith(".xml")) continue;
            this.addContributedXML(reader, key, userAgent);
        }
    }

    private static void addUserContributedFiles(Map<URL, String> ids, String prefKey) {
        IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
        String values = store.getString(prefKey);
        String[] entries = values.split(",");
        String[] envs = JSLanguageEnvironment.getLoadedEnvironments();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            try {
                File file = new File(entry);
                if (file.exists()) {
                    boolean load = false;
                    int k = 0;
                    while (k < envs.length) {
                        if (file.getName().equals(envs[k])) {
                            load = true;
                            break;
                        }
                        ++k;
                    }
                    if (load) {
                        ids.put(file.toURL(), file.getName());
                    }
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public boolean isEnvironmentLoaded() {
        return this.isEnvironmentLoaded;
    }

    private static void addFromExtension(Map<URL, String> ids, String elementName) {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        String[] envs = JSLanguageEnvironment.getLoadedEnvironments();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(JSPlugin.ID, SCRIPTDOC_ID)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(elementName)) {
                        String resourceName = element.getAttribute(ATTR_FILE_PATH);
                        String userAgent = element.getAttribute(ATTR_USER_AGENT);
                        if (userAgent != null) {
                            boolean load = false;
                            int k = 0;
                            while (k < envs.length) {
                                if (userAgent.equals(envs[k])) {
                                    load = true;
                                    break;
                                }
                                ++k;
                            }
                            if (load) {
                                IExtension ext = element.getDeclaringExtension();
                                String pluginId = ext.getNamespaceIdentifier();
                                Bundle bundle = Platform.getBundle((String)pluginId);
                                URL resource = bundle.getResource(resourceName);
                                if (resource != null) {
                                    ids.put(resource, userAgent);
                                } else {
                                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSLanguageEnvironment_ERR_Unable_load_javascript_env_resource, (String)resourceName));
                                }
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static String[] getLoadedEnvironmentsFromExtension(String elementName) {
        IExtensionPoint extensionPoint;
        ArrayList<String> ids = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(JSPlugin.ID, SCRIPTDOC_ID)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(elementName)) {
                        String userAgent = element.getAttribute(ATTR_USER_AGENT);
                        String loadByDefault = element.getAttribute(ATTR_LOAD);
                        if (userAgent != null && Boolean.parseBoolean(loadByDefault)) {
                            ids.add(userAgent);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return ids.toArray(new String[0]);
    }
}

