/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.environment;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.environment.EndOfFileException;
import com.aptana.ide.editor.js.environment.JSReference;
import com.aptana.ide.editor.js.environment.LexemeBasedEnvironmentLoader;
import com.aptana.ide.editor.js.environment.Messages;
import com.aptana.ide.editor.js.parsing.JSParseState;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.FunctionBase;
import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.IScope;
import com.aptana.ide.editor.js.runtime.JSFunction;
import com.aptana.ide.editor.js.runtime.JSObject;
import com.aptana.ide.editor.js.runtime.JSScope;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.js.runtime.Reference;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.metadata.IDocumentationStore;
import com.aptana.ide.parsing.IParseState;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;

public class LexemeConsumerHelper {
    Environment env;
    LexemeBasedEnvironmentLoader envLoader;
    LexemeList lexemeList;
    int llSize;
    private IParseState parseState;
    private int lastIndex = -1;
    private Lexeme lastLexeme = null;
    private Stack lastObjectKind = new Stack();
    private final String OBJECT_LITERAL = "__objectLiteral__";
    private final String FUNCTION = "__function__";
    private static String NOT_AN_IDENTIFIER = "NOT_AN_IDENTIFIER";

    LexemeConsumerHelper(Environment env, LexemeBasedEnvironmentLoader envLoader, IParseState parseState) {
        this.env = env;
        this.envLoader = envLoader;
        this.parseState = parseState;
        this.lexemeList = parseState.getLexemeList();
        this.llSize = this.lexemeList.size();
    }

    protected LexemeConsumerResult consumeIdentifier(int startIndex, IScope scope, boolean isVar) throws EndOfFileException {
        JSIdentifierConsumer indentifier = new JSIdentifierConsumer(scope, isVar);
        return indentifier.consume(startIndex);
    }

    protected LexemeConsumerResult consumeIdentifier(int startIndex, IScope scope, IObject parent) throws EndOfFileException {
        JSIdentifierConsumer indentifier = new JSIdentifierConsumer(scope, parent);
        return indentifier.consume(startIndex);
    }

    protected LexemeConsumerResult consumeStatements(int startIndex, IScope scope) throws EndOfFileException {
        JSStatementConsumer statements = new JSStatementConsumer(scope);
        return statements.consume(startIndex);
    }

    protected LexemeConsumerResult consumeObjectLiteral(int startIndex, IScope scope, IObject objectLiteral) throws EndOfFileException {
        JSObjectLiteralConsumer objectLiteralConsumer = new JSObjectLiteralConsumer(scope, objectLiteral);
        return objectLiteralConsumer.consume(startIndex);
    }

    private void addPotentialAliases(IObject obj, TypedDescription alias) {
        if (obj != null && alias != null && alias.getTypes().length > 0) {
            String[] aliasTypes = alias.getTypes();
            int i = 0;
            while (i < aliasTypes.length) {
                String type = aliasTypes[i];
                if (type != null && type != "") {
                    String name = type;
                    IObject root = this.env.getGlobal();
                    if (type.indexOf(".") > -1) {
                        int dotLoc = type.lastIndexOf(".");
                        String basename = type.substring(0, dotLoc);
                        name = type.substring(dotLoc + 1);
                        root = LexemeConsumerHelper.lookupOrCreateObject(basename, this.env);
                    }
                    if (!name.equals("")) {
                        JSReference aliasRef = new JSReference(root, name, false);
                        this.envLoader.putPropertyValue(aliasRef, obj);
                    }
                }
                ++i;
            }
        }
    }

    protected LexemeConsumerResult consumeArrayLiteral(int startIndex, IScope scope) throws EndOfFileException {
        JSArrayLiteralConsumer arrayLiteral = new JSArrayLiteralConsumer(scope);
        return arrayLiteral.consume(startIndex);
    }

    protected LexemeConsumerResult consumeFunction(int startIndex, IScope scope, JSReference ref, FunctionDocumentation functionDoc) throws EndOfFileException {
        JSFunctionConsumer function = new JSFunctionConsumer(scope, ref, functionDoc);
        return function.consume(startIndex);
    }

    protected LexemeConsumerResult consumeAssignment(int startIndex, IScope scope, JSReference reference, int referenceStartIndex) throws EndOfFileException {
        JSAssignmentConsumer assignment = new JSAssignmentConsumer(scope, reference, referenceStartIndex);
        return assignment.consume(startIndex);
    }

    protected LexemeConsumerResult consumeNewStatement(int startIndex, IScope scope) throws EndOfFileException {
        JSNewStatementConsumer newStatement = new JSNewStatementConsumer(scope);
        return newStatement.consume(startIndex);
    }

    private int getJSLexeme(int index) {
        if (index == this.lastIndex) {
            return index;
        }
        this.lastLexeme = this.lexemeList.get(index);
        if (!this.lastLexeme.getLanguage().equals("text/javascript")) {
            while (++index < this.llSize) {
                this.lastLexeme = this.lexemeList.get(index);
                if (this.lastLexeme.getLanguage().equals("text/javascript")) break;
            }
        }
        this.lastIndex = index;
        return this.lastIndex;
    }

    private static String getNameHash(int position, LexemeList lexemes) {
        String name = "";
        int parenCount = 0;
        int lexLen = lexemes.size();
        while (position < lexLen) {
            Lexeme curLexeme = lexemes.get(position);
            if (name.equals(NOT_AN_IDENTIFIER)) {
                name = "";
            }
            block0 : switch (curLexeme.typeIndex) {
                case 50: {
                    int startParenCount = parenCount++;
                    name = String.valueOf(name) + "(";
                    while (++position < lexLen) {
                        Lexeme lx = lexemes.get(position);
                        if (lx.typeIndex == 50) {
                            ++parenCount;
                        } else if (lx.typeIndex == 58) {
                            --parenCount;
                        }
                        if (startParenCount != parenCount) continue;
                        name = String.valueOf(name) + ")";
                        break block0;
                    }
                    break;
                }
                case 58: {
                    name = String.valueOf(name) + ")";
                    --parenCount;
                    break;
                }
                case 8: {
                    name = String.valueOf(name) + curLexeme.getText();
                    break;
                }
                case 35: {
                    name = String.valueOf(name) + curLexeme.getText();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    position = lexLen;
                }
            }
            if (curLexeme.isAfterEOL()) break;
            ++position;
        }
        return name;
    }

    private static String lookupReturnStringFromHash(String fullname, IScope scope, Environment environment) {
        if (fullname.equals(NOT_AN_IDENTIFIER)) {
            return null;
        }
        if (fullname.length() == 0) {
            return null;
        }
        String result = "";
        int lastDot = fullname.lastIndexOf(".");
        String baseName = "";
        String name = fullname;
        if (lastDot > -1) {
            baseName = fullname.substring(0, lastDot);
            name = fullname.substring(lastDot + 1);
        }
        IObject obj = environment.getGlobal();
        if (baseName != "") {
            obj = LexemeConsumerHelper.lookupReturnTypeFromNameHash(baseName, scope, environment);
        }
        if (obj == null) {
            return "";
        }
        boolean isInvoking = false;
        int firstParen = name.indexOf("(");
        if (name.endsWith(")") && firstParen > -1) {
            isInvoking = true;
            name = name.substring(0, firstParen);
        }
        IObject robj = obj.getPropertyValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(environment, Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (!isInvoking && robj instanceof IFunction) {
            result = fullname;
        } else if (robj.getDocumentation() != null && robj.getDocumentation() instanceof PropertyDocumentation) {
            String[] types;
            PropertyDocumentation pdoc = (PropertyDocumentation)robj.getDocumentation();
            if (pdoc.getReturn() != null && pdoc.getReturn().getTypes() != null && (types = pdoc.getReturn().getTypes()).length > 0) {
                result = pdoc.getIsInstance() ? "+" + types[0] : types[0];
            }
        } else {
            name = name.toString();
        }
        return result;
    }

    private static IObject lookupReturnTypeFromNameHash(String fullname, IScope scope, Environment environment) {
        if (fullname.equals(NOT_AN_IDENTIFIER)) {
            return null;
        }
        if (fullname.length() == 0) {
            return null;
        }
        String[] names = fullname.split("\\.");
        IObject obj = scope;
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            boolean isMethodCall = false;
            if (name.endsWith("()")) {
                isMethodCall = true;
                name = name.substring(0, name.length() - 2);
            }
            if (i == 0) {
                if (name.equals("this") && obj instanceof IScope) {
                    IFunction enclFn = obj.getEnclosingFunction();
                    if (enclFn != null && enclFn instanceof JSFunction) {
                        JSFunction fn = (JSFunction)enclFn;
                        IDocumentation doc = fn.getDocumentation();
                        if (doc instanceof PropertyDocumentation) {
                            PropertyDocumentation pdoc = (PropertyDocumentation)doc;
                            if (pdoc instanceof FunctionDocumentation && ((FunctionDocumentation)pdoc).getIsConstructor()) {
                                obj = fn.getPropertyValue("prototype", Integer.MAX_VALUE, Integer.MAX_VALUE);
                            } else {
                                String rettype = fn.getMemberOf();
                                if (rettype != null && !rettype.equals("") && (obj = rettype.indexOf(".") > -1 ? LexemeConsumerHelper.lookupNamespaceFromNameHash(rettype, environment) : LexemeConsumerHelper.lookupReturnTypeFromNameHash(rettype, environment.getGlobal(), environment)) != null) {
                                    obj = obj.getPropertyValue("prototype", Integer.MAX_VALUE, Integer.MAX_VALUE);
                                }
                            }
                        } else {
                            obj = fn.getGuessedMemberObject();
                        }
                    }
                } else {
                    obj = scope.getVariableValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(environment, Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
            } else {
                obj = obj.getPropertyValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(environment, Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            if (obj == null || obj == ObjectBase.UNDEFINED) {
                return null;
            }
            if (isMethodCall || i == names.length - 1 && fullname.endsWith(".")) {
                IDocumentation doc = obj.getDocumentation();
                if (doc instanceof PropertyDocumentation) {
                    String rettype;
                    PropertyDocumentation pdoc = (PropertyDocumentation)doc;
                    String[] rettypes = pdoc.getReturn().getTypes();
                    if (rettypes.length > 0 && (obj = (rettype = rettypes[0]).indexOf(".") > -1 ? LexemeConsumerHelper.lookupNamespaceFromNameHash(rettype, environment) : LexemeConsumerHelper.lookupReturnTypeFromNameHash(rettype, environment.getGlobal(), environment)) != null) {
                        obj = obj.getPropertyValue("prototype", Integer.MAX_VALUE, Integer.MAX_VALUE);
                    }
                } else {
                    obj = obj instanceof JSFunction ? ((JSFunction)obj).getGuessedMemberObject() : environment.getGlobal().getPropertyValue("Object", Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
            }
            ++i;
        }
        return obj;
    }

    private static IObject lookupNamespaceFromNameHash(String fullname, Environment environment) {
        JSScope scope;
        if (fullname.length() == 0) {
            return null;
        }
        String[] names = fullname.split("\\.");
        IObject obj = scope = environment.getGlobal();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            obj = i == 0 ? scope.getVariableValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(environment, Integer.MAX_VALUE, Integer.MAX_VALUE) : obj.getPropertyValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(environment, Integer.MAX_VALUE, Integer.MAX_VALUE);
            if (obj == ObjectBase.UNDEFINED) {
                return null;
            }
            ++i;
        }
        return obj;
    }

    private static IObject lookupOrCreateObject(String fullname, Environment environment) {
        if (fullname.length() == 0) {
            return environment.getGlobal();
        }
        String[] names = fullname.split("\\.");
        JSScope scope = environment.getGlobal();
        IObject obj = scope;
        ObjectBase prevObj = scope;
        String path = "";
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (i == 0) {
                path = name;
                obj = scope.getVariableValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(environment, Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else {
                path = String.valueOf(path) + "." + name;
                obj = obj.getPropertyValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(environment, Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            if (obj == ObjectBase.UNDEFINED) {
                Range r = new Range(0, 0);
                JSObject guessedObj = new JSObject((IRange)r);
                Property p = new Property(guessedObj, Integer.MIN_VALUE, 0);
                prevObj.putLocalProperty(name, p);
                obj = guessedObj;
                prevObj = guessedObj;
            }
            ++i;
        }
        return obj;
    }

    public static Reference addDocHolderToEnvironment(String id, IDocumentation doc, IParseState parseState) {
        String name;
        String[] stringArray;
        JSReference result = null;
        Environment environment = (Environment)JSLanguageEnvironment.getInstance().getRuntimeEnvironment();
        if (id.indexOf(".") > -1) {
            stringArray = id.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = id;
        }
        String[] path = stringArray;
        IObject scope = environment.getGlobal();
        boolean hasDef = true;
        int i = 0;
        while (i < path.length) {
            name = path[i];
            if (!scope.hasLocalProperty(name)) {
                hasDef = false;
                break;
            }
            scope = scope.getPropertyValue(name, Integer.MAX_VALUE, Integer.MAX_VALUE);
            ++i;
        }
        if (!hasDef) {
            IObject objBase = environment.getGlobal();
            name = id;
            int dotLoc = id.lastIndexOf(".");
            if (dotLoc > -1) {
                name = id.substring(dotLoc + 1);
                String basename = id.substring(0, dotLoc);
                objBase = LexemeConsumerHelper.lookupOrCreateObject(basename, environment);
            }
            if ("".equals(name)) {
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.LexemeConsumerHelper_MalformedIdTag, (String)id));
            }
            if (objBase != null && !"".equals(name)) {
                Range r = new Range(0, 0);
                JSObject obj = new JSObject((IRange)r);
                Property p = new Property(obj, parseState.getFileIndex(), 0);
                objBase.putLocalProperty(name, p);
                result = new JSReference(objBase, name, false);
                if (obj.getDocumentation() == null) {
                    obj.setDocumentation(doc);
                }
            }
        }
        return result;
    }

    class JSArrayLiteralConsumer
    extends LexemeConsumer {
        IScope parentScope;

        JSArrayLiteralConsumer(IScope parentScope) {
            this.parentScope = parentScope;
        }

        public LexemeConsumerResult consume(int startIndex) throws EndOfFileException {
            startIndex = LexemeConsumerHelper.this.getJSLexeme(startIndex);
            Lexeme lexeme = LexemeConsumerHelper.this.lastLexeme;
            if (lexeme.typeIndex != 66) {
                throw new IllegalStateException();
            }
            int startingOffset = lexeme.getStartingOffset();
            int bracketDepth = 1;
            int index = startIndex;
            if (index + 1 < LexemeConsumerHelper.this.llSize) {
                index = this.skipWhitespace(index + 1);
            }
            String type = "Object";
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            lexeme = LexemeConsumerHelper.this.lastLexeme;
            switch (lexeme.typeIndex) {
                case 74: {
                    --bracketDepth;
                    break;
                }
                case 88: {
                    type = "String";
                    break;
                }
                case 87: {
                    type = "Number";
                    break;
                }
                case 85: 
                case 86: {
                    type = "Boolean";
                    break;
                }
                case 89: {
                    type = "RegExp";
                    break;
                }
                case 66: {
                    type = "Array";
                    break;
                }
                case 22: {
                    type = "Function";
                    break;
                }
                case 23: {
                    if (index + 1 < LexemeConsumerHelper.this.llSize) {
                        index = this.skipWhitespace(index + 1);
                    }
                    index = LexemeConsumerHelper.this.getJSLexeme(index);
                    lexeme = LexemeConsumerHelper.this.lastLexeme;
                    if (lexeme.typeIndex == 74) {
                        bracketDepth = 0;
                        break;
                    }
                    if (lexeme.typeIndex != 8) break;
                    type = lexeme.getText();
                    break;
                }
            }
            while (index < LexemeConsumerHelper.this.llSize && bracketDepth > 0) {
                if (index + 1 >= LexemeConsumerHelper.this.llSize) {
                    bracketDepth = 0;
                    break;
                }
                index = this.skipWhitespace(index + 1);
                index = LexemeConsumerHelper.this.getJSLexeme(index);
                lexeme = LexemeConsumerHelper.this.lastLexeme;
                switch (lexeme.typeIndex) {
                    case 74: {
                        --bracketDepth;
                        break;
                    }
                }
                if (!lexeme.isAfterEOL()) continue;
                bracketDepth = 0;
            }
            PropertyDocumentation doc = new PropertyDocumentation();
            doc.getReturn().addType("Array");
            doc.getReturn().addType(type);
            IObject array = LexemeConsumerHelper.this.envLoader.createNewInstance("Array", startingOffset, false);
            array.setDocumentation(doc);
            return new LexemeConsumerResult(index, array);
        }
    }

    class JSAssignmentConsumer
    extends LexemeConsumer {
        IScope scope;
        boolean isVar;
        JSReference reference;
        int referenceStartIndex;

        JSAssignmentConsumer(IScope scope, JSReference reference, int referenceStartIndex) {
            this.scope = scope;
            this.reference = reference;
            this.referenceStartIndex = referenceStartIndex;
        }

        public LexemeConsumerResult consume(int startIndex) throws EndOfFileException {
            int index = startIndex;
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            Lexeme lexeme = LexemeConsumerHelper.this.lastLexeme;
            if (lexeme.typeIndex != 40 && lexeme.typeIndex != 78) {
                throw new IllegalStateException();
            }
            index = this.skipWhitespace(index + 1);
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            lexeme = LexemeConsumerHelper.this.lastLexeme;
            IObject assignValue = null;
            switch (lexeme.typeIndex) {
                case 22: {
                    if (LexemeConsumerHelper.this.lastObjectKind.size() > 0) {
                        LexemeConsumerHelper.this.lastObjectKind.pop();
                        LexemeConsumerHelper.this.lastObjectKind.push("__function__");
                    }
                    FunctionDocumentation functionDoc = this.getFunctionDocumentation(this.findDocumentationLexemeAboveIndex(this.referenceStartIndex));
                    JSFunctionConsumerResult fResult = (JSFunctionConsumerResult)LexemeConsumerHelper.this.consumeFunction(index, this.scope, this.reference, functionDoc);
                    if (fResult.function != null) {
                        LexemeConsumerHelper.this.envLoader.registerScope(fResult.function.getBodyScope(), fResult.scopeStartingOffset, fResult.scopeEndingOffset);
                        if (this.reference.getObjectBase() instanceof JSObject) {
                            fResult.function.setGuessedMemberObject((JSObject)this.reference.getObjectBase());
                        }
                    }
                    index = fResult.endIndex;
                    break;
                }
                case 23: {
                    LexemeConsumerResult result = LexemeConsumerHelper.this.consumeNewStatement(index, this.scope);
                    index = result.endIndex;
                    assignValue = (IObject)result.value;
                    if (assignValue == null) break;
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 88: {
                    ++index;
                    assignValue = LexemeConsumerHelper.this.envLoader.createNewInstance("String", lexeme.getStartingOffset(), false);
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 87: {
                    ++index;
                    assignValue = LexemeConsumerHelper.this.envLoader.createNewInstance("Number", lexeme.getStartingOffset(), false);
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 84: {
                    ++index;
                    assignValue = ObjectBase.NULL;
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 85: 
                case 86: {
                    ++index;
                    assignValue = LexemeConsumerHelper.this.envLoader.createNewInstance("Boolean", lexeme.getStartingOffset(), false);
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 89: {
                    ++index;
                    assignValue = LexemeConsumerHelper.this.envLoader.createNewInstance("RegExp", lexeme.getStartingOffset(), false);
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 34: {
                    if (LexemeConsumerHelper.this.lastObjectKind.size() > 0) {
                        LexemeConsumerHelper.this.lastObjectKind.pop();
                        LexemeConsumerHelper.this.lastObjectKind.push("__objectLiteral__");
                    }
                    JSObject objectLiteral = new JSObject((IRange)new Range(lexeme.getStartingOffset(), lexeme.getEndingOffset()));
                    if (this.reference != null) {
                        IObject o = null;
                        Property p = this.reference.getObjectBase().getProperty(this.reference.getPropertyName());
                        if (p != null) {
                            o = p.getValue(Integer.MAX_VALUE, Integer.MAX_VALUE);
                        }
                        if (o != null) {
                            objectLiteral = o;
                        }
                        LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, objectLiteral);
                    }
                    LexemeConsumerResult result = LexemeConsumerHelper.this.consumeObjectLiteral(index, this.scope, objectLiteral);
                    index = result.endIndex;
                    assignValue = (IObject)result.value;
                    if (assignValue == null) break;
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 66: {
                    LexemeConsumerResult result = LexemeConsumerHelper.this.consumeArrayLiteral(index, this.scope);
                    index = result.endIndex;
                    assignValue = (IObject)result.value;
                    if (assignValue == null) break;
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
                case 8: {
                    IObject fobj;
                    String hashName = LexemeConsumerHelper.getNameHash(index, LexemeConsumerHelper.this.lexemeList);
                    boolean isInvoking = hashName.endsWith(")");
                    String retName = LexemeConsumerHelper.lookupReturnStringFromHash(hashName, this.scope, LexemeConsumerHelper.this.env);
                    if (retName != null && !retName.equals("")) {
                        assignValue = LexemeConsumerHelper.this.envLoader.createNewInstance(retName, lexeme.getStartingOffset(), isInvoking);
                        LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                        break;
                    }
                    IObject obj = LexemeConsumerHelper.lookupReturnTypeFromNameHash(hashName, this.scope, LexemeConsumerHelper.this.env);
                    int offset = lexeme.getStartingOffset();
                    int fileIndex = LexemeConsumerHelper.this.envLoader.getFileIndex();
                    if (obj instanceof IFunction) {
                        IFunction f = (IFunction)((Object)obj);
                        assignValue = f.construct(LexemeConsumerHelper.this.env, FunctionBase.EmptyArgs, fileIndex, (IRange)new Range(offset, offset + 1));
                        LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                        break;
                    }
                    if (obj == null || (fobj = obj.getPropertyValue("constructor", fileIndex, offset)) == null || !(fobj instanceof IFunction)) break;
                    IFunction f = (IFunction)((Object)fobj);
                    assignValue = f.construct(LexemeConsumerHelper.this.env, FunctionBase.EmptyArgs, fileIndex, (IRange)new Range(offset, offset + 1));
                    LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, assignValue);
                    break;
                }
            }
            return new LexemeConsumerResult(index, assignValue);
        }
    }

    class JSFunctionConsumer
    extends LexemeConsumer {
        private IScope parentScope;
        private String functionName;
        private ArrayList functionArgs;
        private JSReference reference;
        private FunctionDocumentation functionDocs;

        JSFunctionConsumer(IScope parentScope, JSReference ref, FunctionDocumentation functionDocs) {
            this.functionArgs = new ArrayList();
            this.parentScope = parentScope;
            this.reference = ref;
            this.functionDocs = functionDocs;
        }

        public LexemeConsumerResult consume(int startIndex) throws EndOfFileException {
            int index = startIndex;
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            Lexeme lexeme = LexemeConsumerHelper.this.lastLexeme;
            if (lexeme.typeIndex != 22) {
                throw new IllegalStateException();
            }
            int functionStart = lexeme.getEndingOffset();
            FunctionDocumentation functionDoc = this.functionDocs;
            if (functionDoc == null) {
                functionDoc = this.getFunctionDocumentation(this.findDocumentationLexemeAboveIndex(index));
            }
            index = this.advanceToLCurly(index);
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            Lexeme lCurly = LexemeConsumerHelper.this.lastLexeme;
            if (lCurly.typeIndex != 34) {
                return new JSFunctionConsumerResult(index, null, this.functionName, 0, 0);
            }
            String[] funcArgs = new String[this.functionArgs.size()];
            int i = 0;
            while (i < funcArgs.length) {
                Lexeme l = (Lexeme)this.functionArgs.get(i);
                funcArgs[i] = l.getText();
                ++i;
            }
            int functionOffset = lexeme.getStartingOffset();
            if (this.functionName != null) {
                functionOffset = -2147483647 + lexeme.getStartingOffset();
            }
            JSFunction func = LexemeConsumerHelper.this.envLoader.createFunctionInstance(functionOffset, false);
            if (this.reference != null && this.reference.getObjectBase() instanceof JSObject) {
                func.setGuessedMemberObject((JSObject)this.reference.getObjectBase());
            } else {
                func.setGuessedMemberObject((JSObject)func.getLocalProperty("prototype").getValue(Integer.MAX_VALUE, Integer.MAX_VALUE));
            }
            JSScope bodyScope = new JSScope();
            bodyScope.setParentScope(this.parentScope);
            bodyScope.setEnclosingFunction(func);
            func.setBodyScope(bodyScope);
            if (functionDoc != null) {
                func.setDocumentation(functionDoc);
            }
            func.setParameters(funcArgs);
            TypedDescription[] argTypes = functionDoc != null ? functionDoc.getParams() : new TypedDescription[]{};
            int size = this.functionArgs.size();
            int i2 = 0;
            while (i2 < size) {
                String type = null;
                TypedDescription argDesc = null;
                if (argTypes.length > i2) {
                    argDesc = argTypes[i2];
                    String[] types = argDesc.getTypes();
                    type = types.length > 0 ? types[0] : type;
                }
                Lexeme l = (Lexeme)this.functionArgs.get(i2);
                if (type == null) {
                    LexemeConsumerHelper.this.envLoader.addVariable(bodyScope, l.getText(), l.getStartingOffset(), true);
                } else {
                    IObject argVal = null;
                    IObject classType = LexemeConsumerHelper.lookupReturnTypeFromNameHash(type, LexemeConsumerHelper.this.env.getGlobal(), LexemeConsumerHelper.this.env);
                    boolean isFunction = true;
                    if (classType instanceof IFunction) {
                        argVal = LexemeConsumerHelper.this.envLoader.createNewInstance(functionOffset, (IFunction)((Object)classType));
                    } else {
                        isFunction = false;
                        argVal = classType;
                    }
                    if (argVal != null) {
                        LexemeConsumerHelper.this.envLoader.putVariableValue(bodyScope, l.getText(), argVal, true);
                        PropertyDocumentation argDoc = new PropertyDocumentation();
                        String desc = argDesc.getDescription() == null ? "" : argDesc.getDescription();
                        argDoc.setDescription(desc);
                        if (isFunction) {
                            argDoc.getReturn().addType(type);
                        }
                        argVal.setDocumentation(argDoc);
                    }
                }
                ++i2;
            }
            IObject argsArray = LexemeConsumerHelper.this.envLoader.addVariable(bodyScope, "arguments", lCurly.getStartingOffset(), true);
            int fileIndex = Integer.MIN_VALUE;
            IObject gFn = LexemeConsumerHelper.this.env.getGlobal().getPropertyValue("Function", fileIndex, 0);
            IObject fnprot = gFn.getPropertyValue("prototype", fileIndex, 0);
            IObject args = fnprot.getPropertyValue("arguments", fileIndex, 0);
            argsArray.setDocumentation(args.getDocumentation());
            if (functionDoc != null && functionDoc.getExtends() != null) {
                Property prot;
                String type;
                String[] types = functionDoc.getExtends().getTypes();
                IObject fnObj = null;
                if (types.length > 0 && !(type = types[0]).equals("Object") && (fnObj = LexemeConsumerHelper.lookupReturnTypeFromNameHash(type, LexemeConsumerHelper.this.env.getGlobal(), LexemeConsumerHelper.this.env)) != null && (prot = fnObj.getProperty("prototype")) != null) {
                    func.deletePropertyName("prototype");
                    func.putPropertyValue("prototype", prot.getAssignment(0), LexemeConsumerHelper.this.envLoader.getFileIndex());
                }
                LexemeConsumerHelper.this.addPotentialAliases(func, functionDoc.getAliases());
            }
            if (this.reference != null) {
                LexemeConsumerHelper.this.envLoader.putPropertyValue(this.reference, func);
            } else if (this.functionName != null) {
                LexemeConsumerHelper.this.envLoader.replaceFunctionDeclaration(lexeme.getStartingOffset(), this.parentScope, this.functionName, func);
            }
            index = this.skipWhitespace(index + 1);
            LexemeConsumerResult result = LexemeConsumerHelper.this.consumeStatements(index, bodyScope);
            index = result.endIndex;
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            Lexeme offsetLx = LexemeConsumerHelper.this.lastLexeme;
            int endScopeOffset = offsetLx.getEndingOffset();
            return new JSFunctionConsumerResult(result.endIndex, func, this.functionName, functionStart, endScopeOffset);
        }

        private int advanceToLCurly(int functionIndex) throws EndOfFileException {
            int index = this.skipWhitespace(functionIndex + 1);
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            Lexeme nextLexeme = LexemeConsumerHelper.this.lastLexeme;
            if (nextLexeme.typeIndex == 8) {
                this.functionName = nextLexeme.getText();
                index = this.skipWhitespace(index + 1);
            }
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            nextLexeme = LexemeConsumerHelper.this.lastLexeme;
            if (nextLexeme.typeIndex == 50) {
                index = this.skipWhitespace(index + 1);
                index = LexemeConsumerHelper.this.getJSLexeme(index);
                nextLexeme = LexemeConsumerHelper.this.lastLexeme;
                while (nextLexeme.typeIndex != 58) {
                    if (nextLexeme.typeIndex == 8) {
                        this.functionArgs.add(nextLexeme);
                    } else if (nextLexeme.typeIndex != 51) {
                        return index;
                    }
                    index = this.skipWhitespace(index + 1);
                    index = LexemeConsumerHelper.this.getJSLexeme(index);
                    nextLexeme = LexemeConsumerHelper.this.lastLexeme;
                }
                index = this.skipWhitespace(index + 1);
                index = LexemeConsumerHelper.this.getJSLexeme(index);
                nextLexeme = LexemeConsumerHelper.this.lastLexeme;
            }
            if (nextLexeme.typeIndex == 34) {
                return index;
            }
            return index;
        }
    }

    class JSFunctionConsumerResult
    extends LexemeConsumerResult {
        String name;
        JSFunction function;
        int scopeStartingOffset;
        int scopeEndingOffset;

        JSFunctionConsumerResult(int endIndex, JSFunction function, String name, int scopeStartingOffset, int scopeEndingOffset) {
            super(endIndex, function);
            this.name = name;
            this.function = function;
            this.scopeStartingOffset = scopeStartingOffset;
            this.scopeEndingOffset = scopeEndingOffset;
        }
    }

    class JSIdentifierConsumer
    extends LexemeConsumer {
        private IScope scope;
        private boolean isVar;
        private JSReference reference;
        IObject parentObject;

        JSIdentifierConsumer(IScope scope, boolean isVar) {
            this.scope = scope;
            this.isVar = isVar;
            this.parentObject = scope;
        }

        JSIdentifierConsumer(IScope scope, IObject parentObject) {
            this.scope = scope;
            this.isVar = false;
            this.parentObject = parentObject;
        }

        public LexemeConsumerResult consume(int startIndex) throws EndOfFileException {
            int index = startIndex;
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            Lexeme lexeme = LexemeConsumerHelper.this.lastLexeme;
            boolean isLocalVar = this.isVar || lexeme.typeIndex == 26;
            while (lexeme != null && index != -1) {
                if (lexeme.typeIndex == 8 || lexeme.typeIndex == 26) {
                    JSObject guessedPrototype;
                    IFunction fn;
                    String propertyName = lexeme.getText();
                    int nextIndex = this.skipWhitespace(index + 1);
                    nextIndex = LexemeConsumerHelper.this.getJSLexeme(nextIndex);
                    Lexeme nextLexeme = LexemeConsumerHelper.this.lastLexeme;
                    if (nextLexeme.typeIndex == 66) {
                        int bracketDepth = 1;
                        while (bracketDepth > 0 && nextLexeme != null) {
                            nextIndex = this.skipWhitespace(nextIndex + 1);
                            nextIndex = LexemeConsumerHelper.this.getJSLexeme(nextIndex);
                            nextLexeme = LexemeConsumerHelper.this.lastLexeme;
                            if (nextLexeme.typeIndex == 66) {
                                ++bracketDepth;
                                continue;
                            }
                            if (nextLexeme.typeIndex != 74) continue;
                            --bracketDepth;
                        }
                        index = nextIndex;
                        propertyName = String.valueOf(propertyName) + "[]";
                    }
                    this.reference = new JSReference(this.parentObject, propertyName, isLocalVar);
                    IObject parentTemp = this.parentObject;
                    if (this.parentObject instanceof IScope) {
                        this.parentObject = LexemeConsumerHelper.this.envLoader.addVariable(this.scope, propertyName, lexeme.getStartingOffset(), isLocalVar);
                        isLocalVar = false;
                    } else {
                        this.parentObject = LexemeConsumerHelper.this.envLoader.addProperty(this.scope, this.parentObject, propertyName, lexeme.getStartingOffset());
                    }
                    if (propertyName.equals("this") && parentTemp instanceof IScope && (fn = ((IScope)parentTemp).getEnclosingFunction()) instanceof JSFunction && (guessedPrototype = ((JSFunction)fn).getGuessedMemberObject()) != null) {
                        this.parentObject = guessedPrototype;
                    }
                } else if (lexeme.typeIndex != 35) {
                    --index;
                    break;
                }
                if (LexemeConsumerHelper.this.llSize > ++index) {
                    index = LexemeConsumerHelper.this.getJSLexeme(index);
                    lexeme = LexemeConsumerHelper.this.lastLexeme;
                    continue;
                }
                lexeme = null;
            }
            return new LexemeConsumerResult(index, this.reference);
        }
    }

    class JSNewStatementConsumer
    extends LexemeConsumer {
        IScope scope;

        JSNewStatementConsumer(IScope scope) {
            this.scope = scope;
        }

        public LexemeConsumerResult consume(int startIndex) throws EndOfFileException {
            int index = startIndex;
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            Lexeme lexeme = LexemeConsumerHelper.this.lastLexeme;
            if (lexeme.typeIndex != 23) {
                throw new IllegalStateException();
            }
            Range range = new Range(lexeme.getStartingOffset(), lexeme.getEndingOffset());
            index = this.skipWhitespace(index + 1);
            index = LexemeConsumerHelper.this.getJSLexeme(index);
            lexeme = LexemeConsumerHelper.this.lastLexeme;
            IObject newValue = null;
            if (lexeme.typeIndex == 8) {
                LexemeConsumerResult result = LexemeConsumerHelper.this.consumeIdentifier(index, this.scope, false);
                index = result.endIndex;
                JSReference propReference = (JSReference)result.value;
                IObject value = propReference.getObjectBase() instanceof IScope ? LexemeConsumerHelper.this.envLoader.getVariableValue((IScope)propReference.getObjectBase(), propReference.getPropertyName(), range.getStartingOffset()) : LexemeConsumerHelper.this.envLoader.getPropertyValue(propReference, range.getStartingOffset());
                if (value instanceof IFunction) {
                    newValue = LexemeConsumerHelper.this.envLoader.createNewInstance(range.getStartingOffset(), (IFunction)((Object)value));
                }
            } else {
                index = startIndex;
            }
            if (newValue == null) {
                newValue = new JSObject((IRange)range);
            }
            return new LexemeConsumerResult(index, newValue);
        }
    }

    class JSObjectLiteralConsumer
    extends LexemeConsumer {
        IScope parentScope;
        IObject objectLiteral;

        JSObjectLiteralConsumer(IScope parentScope, IObject objectLiteral) {
            this.parentScope = parentScope;
            this.objectLiteral = objectLiteral;
        }

        public LexemeConsumerResult consume(int startIndex) throws EndOfFileException {
            startIndex = LexemeConsumerHelper.this.getJSLexeme(startIndex);
            Lexeme lexeme = LexemeConsumerHelper.this.lastLexeme;
            if (lexeme.typeIndex != 34) {
                throw new IllegalStateException();
            }
            int curlyDepth = 1;
            int index = startIndex;
            JSReference currentReference = null;
            int currentReferenceStartIndex = -1;
            block6: while (index < LexemeConsumerHelper.this.llSize && curlyDepth > 0) {
                if (index + 1 < LexemeConsumerHelper.this.llSize) {
                    index = this.skipWhitespace(index + 1);
                }
                index = LexemeConsumerHelper.this.getJSLexeme(index);
                lexeme = LexemeConsumerHelper.this.lastLexeme;
                switch (lexeme.typeIndex) {
                    case 42: {
                        --curlyDepth;
                        break;
                    }
                    case 51: {
                        if (index + 1 != LexemeConsumerHelper.this.llSize) continue block6;
                        ++index;
                        break;
                    }
                    case 8: {
                        currentReferenceStartIndex = index;
                        LexemeConsumerResult result = LexemeConsumerHelper.this.consumeIdentifier(index, this.parentScope, this.objectLiteral);
                        currentReference = (JSReference)result.value;
                        index = result.endIndex;
                        break;
                    }
                    case 78: {
                        LexemeConsumerResult result;
                        LexemeConsumerHelper.this.lastObjectKind.push("unknown");
                        if (currentReference != null) {
                            result = LexemeConsumerHelper.this.consumeAssignment(index, this.parentScope, currentReference, currentReferenceStartIndex);
                            index = result.endIndex;
                        }
                        String lastObj = (String)LexemeConsumerHelper.this.lastObjectKind.pop();
                        boolean wasObjLit = lastObj.equals("__objectLiteral__");
                        boolean wasFn = lastObj.equals("__function__");
                        if (wasObjLit || wasFn || index >= LexemeConsumerHelper.this.llSize) continue block6;
                        Lexeme curLexeme = LexemeConsumerHelper.this.lexemeList.get(index);
                        if (curLexeme.typeIndex != 42) continue block6;
                        --curlyDepth;
                        break;
                    }
                    default: {
                        curlyDepth = 0;
                    }
                }
            }
            return new LexemeConsumerResult(index, this.objectLiteral);
        }
    }

    class JSStatementConsumer
    extends LexemeConsumer {
        boolean isVar;
        IScope parentScope;
        int curlyDepth;
        JSReference assignToReference;
        int assignToLexemeStartIndex;

        JSStatementConsumer(IScope parentScope) {
            this.parentScope = parentScope;
        }

        public LexemeConsumerResult consume(int startIndex) throws EndOfFileException {
            int index = startIndex;
            while (index < LexemeConsumerHelper.this.llSize) {
                index = this.skipWhitespace(index);
                index = LexemeConsumerHelper.this.getJSLexeme(index);
                Lexeme lexeme = LexemeConsumerHelper.this.lastLexeme;
                switch (lexeme.typeIndex) {
                    case 22: {
                        JSFunctionConsumerResult fResult = (JSFunctionConsumerResult)LexemeConsumerHelper.this.consumeFunction(index, this.parentScope, null, null);
                        if (fResult.function != null) {
                            LexemeConsumerHelper.this.envLoader.registerScope(fResult.function.getBodyScope(), fResult.scopeStartingOffset, fResult.scopeEndingOffset);
                        }
                        index = fResult.endIndex;
                        break;
                    }
                    case 8: 
                    case 26: {
                        int identifierStartIndex = index;
                        LexemeConsumerResult result = LexemeConsumerHelper.this.consumeIdentifier(index, this.parentScope, this.isVar);
                        this.isVar = false;
                        index = result.endIndex;
                        int nextIndex = this.skipWhitespace(index + 1);
                        nextIndex = LexemeConsumerHelper.this.getJSLexeme(nextIndex);
                        Lexeme nextLexeme = LexemeConsumerHelper.this.lastLexeme;
                        if (nextLexeme.typeIndex != 40) break;
                        this.assignToLexemeStartIndex = identifierStartIndex;
                        this.assignToReference = (JSReference)result.value;
                        break;
                    }
                    case 30: {
                        this.isVar = true;
                        break;
                    }
                    case 34: {
                        ++this.curlyDepth;
                        break;
                    }
                    case 42: {
                        --this.curlyDepth;
                        if (this.curlyDepth >= 0) break;
                        return new LexemeConsumerResult(index, null);
                    }
                    case 40: {
                        LexemeConsumerResult result;
                        IObject assignedValue = null;
                        if (this.assignToReference == null) break;
                        int nextIndex = this.skipWhitespace(index + 1);
                        nextIndex = LexemeConsumerHelper.this.getJSLexeme(nextIndex);
                        Lexeme nextLexeme = LexemeConsumerHelper.this.lastLexeme;
                        if (nextLexeme.typeIndex == 22 || nextLexeme.typeIndex == 23 || nextLexeme.typeIndex == 34 || nextLexeme.typeIndex == 66) {
                            result = LexemeConsumerHelper.this.consumeAssignment(index, this.parentScope, this.assignToReference, this.assignToLexemeStartIndex);
                            index = result.endIndex;
                            assignedValue = (IObject)result.value;
                        } else if (nextLexeme.typeIndex == 88 || nextLexeme.typeIndex == 87 || nextLexeme.typeIndex == 89 || nextLexeme.typeIndex == 85 || nextLexeme.typeIndex == 86) {
                            nextIndex = this.skipWhitespace(nextIndex + 1);
                            nextIndex = LexemeConsumerHelper.this.getJSLexeme(nextIndex);
                            nextLexeme = LexemeConsumerHelper.this.lastLexeme;
                            if (nextLexeme.typeIndex == 43) {
                                result = LexemeConsumerHelper.this.consumeAssignment(index, this.parentScope, this.assignToReference, this.assignToLexemeStartIndex);
                                index = result.endIndex;
                                assignedValue = (IObject)result.value;
                            }
                        } else if (nextLexeme.typeIndex == 8) {
                            result = LexemeConsumerHelper.this.consumeAssignment(index, this.parentScope, this.assignToReference, this.assignToLexemeStartIndex);
                            index = result.endIndex;
                            assignedValue = (IObject)result.value;
                        }
                        IDocumentation propertyDoc = this.getPropertyDocumentation(this.findDocumentationLexemeAboveIndex(this.assignToLexemeStartIndex));
                        if (propertyDoc != null) {
                            IObject propValue = assignedValue;
                            if (propValue == null || propValue == ObjectBase.UNDEFINED) {
                                propValue = LexemeConsumerHelper.this.envLoader.getPropertyValue(this.assignToReference, lexeme.getStartingOffset());
                            }
                            if (propValue != ObjectBase.UNDEFINED) {
                                try {
                                    if (propertyDoc instanceof PropertyDocumentation) {
                                        String type;
                                        PropertyDocumentation pDoc = (PropertyDocumentation)propertyDoc;
                                        IObject retValue = null;
                                        TypedDescription typeDesc = pDoc.getReturn();
                                        if (typeDesc != null && typeDesc.getTypes().length > 0 && (type = typeDesc.getTypes()[0]) != null) {
                                            retValue = LexemeConsumerHelper.this.envLoader.createNewInstance(type, lexeme.getStartingOffset(), false);
                                            LexemeConsumerHelper.this.envLoader.putPropertyValue(this.assignToReference, retValue);
                                            propValue.setPrototype(retValue);
                                        }
                                        LexemeConsumerHelper.this.addPotentialAliases(propValue, pDoc.getAliases());
                                    }
                                }
                                catch (Exception e) {
                                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.LexemeConsumerHelper_ErrorSettingPrototype, (Throwable)e);
                                }
                                if (propValue != null) {
                                    propValue.setDocumentation(propertyDoc);
                                }
                            }
                        }
                        this.assignToReference = null;
                        this.assignToLexemeStartIndex = -1;
                        break;
                    }
                }
                ++index;
            }
            throw new EndOfFileException();
        }
    }

    abstract class LexemeConsumer {
        LexemeConsumer() {
        }

        public abstract LexemeConsumerResult consume(int var1) throws EndOfFileException;

        protected int skipWhitespace(int startIndex) throws EndOfFileException {
            int index = startIndex;
            while (index < LexemeConsumerHelper.this.llSize) {
                index = LexemeConsumerHelper.this.getJSLexeme(index);
                Lexeme l = LexemeConsumerHelper.this.lastLexeme;
                if (l.typeIndex != 2 && l.typeIndex != 91) {
                    return index;
                }
                ++index;
            }
            throw new EndOfFileException();
        }

        protected FunctionDocumentation getFunctionDocumentation(Lexeme lexeme) {
            IDocumentationStore store;
            IDocumentation doc;
            if (lexeme == null) {
                return null;
            }
            JSParseState jsps = (JSParseState)LexemeConsumerHelper.this.parseState.getParseState("text/javascript");
            if (jsps != null && (doc = (store = jsps.getDocumentationStore()).getDocumentationFromOffset(lexeme.getEndingOffset())) instanceof FunctionDocumentation) {
                return (FunctionDocumentation)doc;
            }
            return null;
        }

        protected IDocumentation getPropertyDocumentation(Lexeme lexeme) {
            if (lexeme == null) {
                return null;
            }
            JSParseState jsps = (JSParseState)LexemeConsumerHelper.this.parseState.getParseState("text/javascript");
            if (jsps != null) {
                IDocumentationStore store = jsps.getDocumentationStore();
                IDocumentation doc = store.getDocumentationFromOffset(lexeme.offset + lexeme.getLength());
                return doc;
            }
            return null;
        }

        protected Lexeme findDocumentationLexemeAboveIndex(int index) {
            int i = index - 1;
            int maxLookback = 10;
            int minIndex = i > maxLookback ? i - maxLookback : 0;
            while (i >= minIndex) {
                Lexeme lexeme = LexemeConsumerHelper.this.lexemeList.get(i);
                if (lexeme.typeIndex == 32 && lexeme.getToken().getLanguage().equals("text/scriptdoc")) {
                    return lexeme;
                }
                switch (lexeme.typeIndex) {
                    case 2: {
                        break;
                    }
                    case 30: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 78: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                --i;
            }
            return null;
        }
    }

    class LexemeConsumerResult {
        int endIndex;
        Object value;

        LexemeConsumerResult(int endIndex, Object value) {
            this.endIndex = endIndex;
            this.value = value;
        }
    }
}

