/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.formatting;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HTMLCodeFormatterOptions {
    public String formatterTabChar;
    public int tabSize;
    public boolean doFormatting = true;

    public HTMLCodeFormatterOptions() {
        this.initFromPreferences();
    }

    private void initFromPreferences() {
        AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"com.aptana.ide.editor.html");
        if (abstractUIPlugin != null) {
            IPreferenceStore preferenceStore = abstractUIPlugin.getPreferenceStore();
            this.formatterTabChar = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
            this.tabSize = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        } else {
            this.initDefaults();
        }
    }

    private void initDefaults() {
        this.formatterTabChar = " ";
        this.tabSize = 4;
    }

    public HTMLCodeFormatterOptions(Map map, IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode("com.aptana.ide.editor.html");
            if (preferences != null) {
                String string = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size", null);
                if (string == null) {
                    this.initFromPreferences();
                    return;
                }
                this.formatterTabChar = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char", "");
                this.tabSize = Integer.parseInt(string);
            } else {
                this.initDefaults();
            }
        } else if (map == null) {
            this.initFromPreferences();
        } else {
            Object object10;
            this.formatterTabChar = (String)map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
            if (this.formatterTabChar == null) {
                this.formatterTabChar = " ";
            }
            this.tabSize = (object10 = map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size")) != null ? Integer.parseInt(object10.toString()) : 4;
        }
    }
}

