/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.formatting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSFileLanguageService;
import com.aptana.ide.editor.js.JSPairFinder;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.formatting.IFormattingCallback;
import com.aptana.ide.editor.js.formatting.JSCodeFormatter;
import com.aptana.ide.editor.js.formatting.JSCodeFormatterOptions;
import com.aptana.ide.editor.js.parsing.JSParseState;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.UnifiedAutoIndentStrategy;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class JSAutoIndentStrategy
extends UnifiedAutoIndentStrategy {
    public JSAutoIndentStrategy(EditorFileContext context, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(context, configuration, sourceViewer);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        block22: {
            if (command.text == null || command.length > 0) {
                return;
            }
            String[] lineDelimiters = document.getLegalLineDelimiters();
            int index = TextUtilities.endsWith((String[])lineDelimiters, (String)command.text);
            if (index > -1) {
                if (lineDelimiters[index].equals(command.text)) {
                    this.indentAfterNewLine(document, command);
                }
                return;
            }
            if (command.text.equals("\t")) {
                UnifiedConfiguration uc;
                if (this.configuration instanceof UnifiedConfiguration && (uc = (UnifiedConfiguration)this.configuration).useSpacesAsTabs()) {
                    command.text = uc.getTabAsSpaces();
                }
            } else if (command.text.equals("}")) {
                try {
                    IParseNode parentNode;
                    LexemeList ll;
                    Lexeme lexeme;
                    if (!JSPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.js.AUTO_FORMAT_ON_CLOSE_CURLY") || (lexeme = (ll = this.getLexemeList()).getFloorLexeme(command.offset)) == null || lexeme.getToken().getTypeIndex() == 88) break block22;
                    String unit = document.get();
                    JSPairFinder finder = new JSPairFinder();
                    unit = String.valueOf(unit.substring(0, command.offset)) + "}" + unit.substring(command.offset);
                    IParser parser = LanguageRegistry.getParser((String)"text/javascript");
                    JSParseState createParseState = (JSParseState)parser.createParseState(null);
                    JSCodeFormatter formatter = new JSCodeFormatter();
                    createParseState.setEditState(unit, unit, 0, 0);
                    try {
                        parser.parse((IParseState)createParseState);
                    }
                    catch (LexerException lexerException) {
                        return;
                    }
                    PairMatch findPairMatch = finder.findPairMatch(command.offset, (IParseState)createParseState);
                    if (findPairMatch == null) {
                        return;
                    }
                    IParseNode ast = parser.parse((IParseState)createParseState);
                    IParseNode formattedNode = this.findAstNode(ast, command.offset + 1);
                    if (formattedNode == null || (parentNode = formattedNode) == null) break block22;
                    int emNodeEnd = parentNode.getEndingOffset();
                    int emNodeStart = parentNode.getStartingOffset();
                    if (emNodeStart >= emNodeEnd) {
                        return;
                    }
                    String nodeContent = unit.substring(emNodeStart, emNodeEnd);
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)("nodeContent: +++++++++++++++++++++++++++++++++\r\n" + nodeContent + ":"));
                    JSParseState parseState = (JSParseState)createParseState.getParseState("text/javascript");
                    formatter.addMarkedNode(formattedNode, new IFormattingCallback(){

                        public void nodeIsBeingFormatted(IParseNode node, JSCodeFormatter formatter) {
                        }
                    });
                    String lineSeparator = "";
                    if (document instanceof IDocumentExtension4) {
                        IDocumentExtension4 ext = (IDocumentExtension4)document;
                        lineSeparator = ext.getDefaultLineDelimiter();
                    }
                    try {
                        lineSeparator = document.getLineDelimiter(0);
                    }
                    catch (BadLocationException badLocationException) {}
                    IProject project = this.getProject();
                    LexemeList lexList = this.getLexemes(parseState.getLexemeList(), emNodeStart, emNodeEnd);
                    IParseNode[] comments = this.getComments(parseState, emNodeStart, emNodeEnd);
                    JSCodeFormatterOptions options = new JSCodeFormatterOptions(null, project);
                    int indentation = this.getIndentationLevelAtOffset(document, emNodeStart);
                    formatter.configureWriter(indentation, this.getIndentString(), options.tabSize);
                    String formatted = formatter.format(unit, nodeContent, parentNode, lexList, comments, options, lineSeparator);
                    if (formatted.equals(nodeContent)) {
                        return;
                    }
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)("Formatted: +++++++++++++++++++++++++++++++++\r\n" + formatted + ":"));
                    String indented = formatted;
                    indented = StringUtils.trimStart((String)indented);
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)("Indented: +++++++++++++++++++++++++++++++++\r\n" + indented + ":"));
                    if (!nodeContent.endsWith("\r") && !nodeContent.endsWith("\n")) {
                        if (indented.endsWith("\r\n")) {
                            indented = indented.substring(0, indented.length() - 2);
                        } else if (indented.endsWith("\n") || indented.endsWith("\r")) {
                            indented = indented.substring(0, indented.length() - 1);
                        }
                    }
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)("Indented Trimmed: +++++++++++++++++++++++++++++++++\r\n" + indented + ":"));
                    command.offset = emNodeStart;
                    command.length = emNodeEnd - emNodeStart - 1;
                    command.text = indented;
                    command.shiftsCaret = true;
                    return;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)e.getMessage());
                    return;
                }
                catch (Error e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)e.getMessage());
                    return;
                }
            }
        }
    }

    private IProject getProject() {
        IEditorInput editorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IProject project = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fl = (IFileEditorInput)editorInput;
            project = fl.getFile().getProject();
        }
        return project;
    }

    private LexemeList getLexemes(LexemeList lexemes, int startOffset, int endOffset) {
        int start = lexemes.getLexemeIndex(startOffset);
        int end = lexemes.getLexemeIndex(endOffset - 1);
        Lexeme[] lexList = lexemes.copyRange(start, end);
        LexemeList ll = new LexemeList();
        int i = 0;
        while (i < lexList.length) {
            Lexeme lexeme = lexList[i];
            ll.add(lexeme);
            ++i;
        }
        return ll;
    }

    private IParseNode[] getComments(JSParseState parseState, int startOffset, int endOffset) {
        ArrayList<IParseNode> list = new ArrayList<IParseNode>();
        IParseNode[] nodes = parseState.getCommentRegions();
        int i = 0;
        while (i < nodes.length) {
            IParseNode node = nodes[i];
            if (node.getStartingOffset() >= startOffset && node.getEndingOffset() <= endOffset) {
                list.add(node);
            }
            ++i;
        }
        return list.toArray(new IParseNode[0]);
    }

    private IParseNode findAstNode(IParseNode ast, int offset) {
        if (ast.getTypeIndex() == 48 && ast.getChild(1).getEndingOffset() == offset) {
            return ast;
        }
        if (ast.getTypeIndex() == 72) {
            if (ast.getChild(0).getEndingOffset() == offset) {
                return ast;
            }
            if (ast.getChild(1).getEndingOffset() == offset) {
                return ast;
            }
        }
        if (ast.getTypeIndex() == 42) {
            if (ast.getChild(0).getEndingOffset() == offset) {
                return ast;
            }
            if (ast.getChild(1).getEndingOffset() == offset) {
                return ast;
            }
        }
        if (ast.getEndingOffset() == offset && ast.getParent() != null) {
            return ast;
        }
        int a = 0;
        while (a < ast.getChildCount()) {
            IParseNode findAstNode = this.findAstNode(ast.getChild(a), offset);
            if (findAstNode != null) {
                return findAstNode;
            }
            ++a;
        }
        return null;
    }

    protected int getIndentationLevelAtOffset(IDocument d, int offset) {
        String lineIndent;
        block7: {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            lineIndent = null;
            try {
                lineIndent = d.get(lineOffset, firstNonWS - lineOffset);
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
            if (!lineIndent.equals("")) break block7;
            return 0;
        }
        try {
            int indentSize = 0;
            int tabWidth = this.configuration.getTabWidth(this.sourceViewer);
            char[] indentChars = lineIndent.toCharArray();
            int i = 0;
            while (i < indentChars.length) {
                char e = indentChars[i];
                indentSize = e == '\t' ? (indentSize += tabWidth - indentSize % tabWidth) : ++indentSize;
                ++i;
            }
            return indentSize;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public String indent(int level, String languageContent, String lineSeparator) {
        if (lineSeparator == null) {
            return languageContent;
        }
        String[] split = languageContent.split(lineSeparator);
        int indentSize = 4;
        if (this.configuration instanceof UnifiedConfiguration) {
            UnifiedConfiguration uc = (UnifiedConfiguration)this.configuration;
            indentSize = uc.getTabWidth(this.sourceViewer);
        }
        SourceWriter result = new SourceWriter(level, this.getIndentString(), indentSize);
        if (split.length == 1) {
            result.printIndent();
            result.print(split[0]);
            return result.toString();
        }
        int a = 0;
        while (a < split.length) {
            result.printlnWithIndent(split[a]);
            ++a;
        }
        return result.toString();
    }

    protected void indentAfterNewLine(IDocument d, DocumentCommand c) {
        String indentString = this.getIndentString();
        if (indentString.equals("")) {
            return;
        }
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            String lineText;
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            int lineLen = d.getLineLength(d.getLineOfOffset(lineOffset)) - 2;
            if (lineLen > 0 && lineOffset + lineLen < d.getLength() && (lineText = d.get(lineOffset, lineLen)).endsWith(" */")) {
                --firstNonWS;
            }
            StringBuffer buf = new StringBuffer(c.text);
            String currentIndent = this.getIndentationString(d, lineOffset, firstNonWS);
            String newline = c.text;
            buf.append(currentIndent);
            if (c.offset > 1 && d.getChar(c.offset - 1) == '{') {
                JSCodeFormatterOptions options = new JSCodeFormatterOptions(null, this.getProject());
                if (options.formatterBracePositionForMethodDecl != 0) {
                    --c.offset;
                    buf = new StringBuffer();
                    buf.append(newline).append(currentIndent).append("{");
                    buf.append(c.text);
                    buf.append(currentIndent);
                    ++c.length;
                    if (this.shouldAutoIndent()) {
                        c.shiftsCaret = false;
                        buf.append(indentString);
                        c.caretOffset = c.offset + buf.length();
                        if (d.getChar(c.offset + 1) == '}') {
                            buf.append(newline);
                            buf.append(currentIndent);
                        }
                    } else {
                        c.shiftsCaret = false;
                        c.caretOffset = c.offset + buf.length() - 1;
                    }
                } else if (this.shouldAutoIndent()) {
                    buf.append(indentString);
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    if (d.getChar(c.offset) == '}') {
                        buf.append(newline);
                        buf.append(currentIndent);
                    }
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean shouldAutoIndent() {
        return Platform.getPreferencesService().getBoolean(JSPlugin.ID, "com.aptana.ide.editor.js.AUTO_INDENT_ON_CARRIAGE_RETURN", true, null);
    }

    public IPreferenceStore getPreferenceStore() {
        return JSPlugin.getDefault().getPreferenceStore();
    }

    protected LexemeList getLexemeList() {
        JSFileLanguageService ls = (JSFileLanguageService)this.context.getLanguageService("text/javascript");
        return ls.getFileContext().getLexemeList();
    }

    public int getCurrentIndentLevel(String source, int pos) {
        int res = 0;
        int a = pos;
        while (a >= 0) {
            char charAt = source.charAt(a);
            if (charAt == '\n' || charAt == '\r') break;
            ++res;
            if (!Character.isWhitespace(charAt)) {
                res = 0;
            }
            --a;
        }
        return res;
    }
}

