/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.outline;

import com.aptana.ide.editor.js.outline.Messages;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.views.outline.IResolvableItem;
import com.aptana.ide.views.outline.OutlineItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IEditorInput;

public class JSOutlineItem
extends OutlineItem
implements IResolvableItem {
    private List<IParseNode> _virtualChildren;
    private IEditorInput input;
    private IResolvableItem parent;

    public JSOutlineItem(String label, int type, IRange sourceRange, IParseNode referenceNode) {
        super(label, "text/javascript", type, sourceRange, referenceNode, 0);
    }

    public JSOutlineItem(String label, int type, IRange sourceRange, IParseNode referenceNode, int childCount) {
        super(label, "text/javascript", type, sourceRange, referenceNode, childCount);
    }

    public void addVirtualChild(IParseNode target) {
        if (target == null) {
            throw new IllegalArgumentException(Messages.JSOutlineItem_Target_Not_Defined);
        }
        if (this._virtualChildren == null) {
            this._virtualChildren = new ArrayList<IParseNode>();
        }
        this._virtualChildren.add(target);
    }

    public int getChildCount() {
        int result = super.getChildCount();
        if (this._virtualChildren != null) {
            result += this._virtualChildren.size();
        }
        return result;
    }

    public IParseNode[] getReferenceNodes() {
        IParseNode[] result = null;
        if (this.hasVirtualChildren()) {
            result = new IParseNode[this._virtualChildren.size() + 1];
            result = this._virtualChildren.toArray(result);
            result[result.length - 1] = this.getReferenceNode();
        } else {
            result = new IParseNode[]{this.getReferenceNode()};
        }
        return result;
    }

    public IParseNode[] getVirtualChildren() {
        IParseNode[] result = null;
        if (this._virtualChildren != null) {
            result = this._virtualChildren.toArray(new IParseNode[this._virtualChildren.size()]);
        }
        return result;
    }

    public boolean hasVirtualChildren() {
        return this._virtualChildren != null && this._virtualChildren.size() > 0;
    }

    public boolean isResolvable() {
        return this.input != null;
    }

    public void setResolveInformation(IEditorInput input) {
        this.input = input;
    }

    public void setParent(IResolvableItem parent) {
        this.parent = parent;
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public boolean stillHighlight() {
        return false;
    }

    public IResolvableItem getParentItem() {
        return this.parent;
    }
}

