/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.parsing;

import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.parsing.IParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLanguageRegistry {
    private static String TAG_PARSER = "parser";
    private static String TAG_SCANNER = "scanner";
    private static String TAG_PI_LANGUAGE = "pi-language";
    private static String TAG_SINGLE_LINE_COMMENT_LANGUAGE = "single-line-comment-language";
    private static String TAG_MULTI_LINE_COMMENT_LANGUAGE = "multi-line-comment-language";
    private static String TAG_DOCUMENTATION_COMMENT_LANGUAGE = "documentation-comment-language";
    private static String ATTR_LANGUAGE = "language";
    private static String ATTR_PI_NAME = "pi-name";
    private static String SINGLE_LINE_COMMENT_KEY = "//";
    private static String MULTI_LINE_COMMENT_KEY = "/*";
    private static String DOCUMENTATION_COMMENT_KEY = "/**";
    private Map<String, IParser> _parserByMimeType = new HashMap<String, IParser>();
    private Map<String, IParser> _scannerByMimeType = new HashMap<String, IParser>();

    public IParser getDocumentationCommentParser() {
        return this.getParser(DOCUMENTATION_COMMENT_KEY);
    }

    public IParser getDocumentationCommentScanner() {
        return this.getScanner(DOCUMENTATION_COMMENT_KEY);
    }

    public IParser getMultiLineCommentParser() {
        return this.getParser(MULTI_LINE_COMMENT_KEY);
    }

    public IParser getMultiLineCommentScanner() {
        return this.getScanner(MULTI_LINE_COMMENT_KEY);
    }

    public IParser getParser(String key) {
        IParser result = null;
        if (this._parserByMimeType.containsKey(key)) {
            result = this._parserByMimeType.get(key);
        }
        return result;
    }

    public IParser getProcessingInstructionLanguage(String processInstructionName) {
        return this.getParser(processInstructionName);
    }

    public IParser getProcessingInstructionScanner(String processInstructionName) {
        return this.getScanner(processInstructionName);
    }

    public IParser getScanner(String key) {
        IParser result = null;
        if (this._scannerByMimeType.containsKey(key)) {
            result = this._scannerByMimeType.get(key);
        }
        return result;
    }

    public IParser getSingleLineCommentParser() {
        return this.getParser(SINGLE_LINE_COMMENT_KEY);
    }

    public IParser getSingleLineCommentScanner() {
        return this.getScanner(SINGLE_LINE_COMMENT_KEY);
    }

    public IParser[] loadParsersFromExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        ArrayList<IParser> parsers = new ArrayList<IParser>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TAG_PARSER)) {
                this.processElement(parsers, element, false);
            }
            ++n2;
        }
        return parsers.toArray(new IParser[parsers.size()]);
    }

    public IParser[] loadScannersFromExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        ArrayList<IParser> parsers = new ArrayList<IParser>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TAG_SCANNER)) {
                this.processElement(parsers, element, true);
            }
            ++n2;
        }
        return parsers.toArray(new IParser[parsers.size()]);
    }

    private void processElement(List<IParser> parsers, IConfigurationElement element, boolean isScanner) {
        String language = element.getAttribute(ATTR_LANGUAGE);
        if (language != null && language.length() > 0) {
            IParser parser = isScanner ? LanguageRegistry.createScanner((String)language) : LanguageRegistry.createParser((String)language);
            this.registerPILanguages(element.getChildren(TAG_PI_LANGUAGE), parser, isScanner);
            this.registerCommentLanguages(SINGLE_LINE_COMMENT_KEY, element.getChildren(TAG_SINGLE_LINE_COMMENT_LANGUAGE), parser, isScanner);
            this.registerCommentLanguages(MULTI_LINE_COMMENT_KEY, element.getChildren(TAG_MULTI_LINE_COMMENT_LANGUAGE), parser, isScanner);
            this.registerCommentLanguages(DOCUMENTATION_COMMENT_KEY, element.getChildren(TAG_DOCUMENTATION_COMMENT_LANGUAGE), parser, isScanner);
            parsers.add(parser);
        }
    }

    private void registerCommentLanguages(String key, IConfigurationElement[] elements, IParser parser, boolean isScanner) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String piName = "<?" + element.getAttribute(ATTR_PI_NAME);
            if (isScanner) {
                this.registerScanner(piName, parser);
            } else {
                this.registerParser(piName, parser);
            }
            ++i;
        }
    }

    private void registerParser(String key, IParser parser) {
        this._parserByMimeType.put(key, parser);
    }

    private void registerPILanguages(IConfigurationElement[] elements, IParser parser, boolean isScanner) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String piName = "<?" + element.getAttribute(ATTR_PI_NAME);
            if (isScanner) {
                this.registerScanner(piName, parser);
            } else {
                this.registerParser(piName, parser);
            }
            ++i;
        }
    }

    private void registerScanner(String key, IParser parser) {
        this._scannerByMimeType.put(key, parser);
    }
}

