/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.runtime;

import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.Messages;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.OrderedObject;
import com.aptana.ide.editor.js.runtime.OrderedObjectCollection;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.metadata.IDocumentationContainer;

public class Property
implements IDocumentationContainer {
    private IDocumentation _documentation;
    public static final int NONE = 0;
    public static final int READ_ONLY = 1;
    public static final int DONT_ENUM = 2;
    public static final int DONT_DELETE = 4;
    public static final int INTERNAL = 8;
    public static final int NOT_VISIBLE = 16;
    private OrderedObjectCollection _assignments = new OrderedObjectCollection();
    private int _attributes;
    private int _referenceCount;

    public IObject getAssignment(int index) {
        return this._assignments.get((int)index).object;
    }

    public int getReferenceCount() {
        return this._referenceCount;
    }

    public int getSourceFileIndex(int fileIndex, int offset) {
        return this._assignments.getFloorFileIndex(fileIndex, offset);
    }

    public IObject getValue(int fileIndex, int offset) {
        return this._assignments.getFloorObject(fileIndex, offset);
    }

    public void setValue(IObject value, int fileIndex) {
        if (value != ObjectBase.UNDEFINED) {
            this._assignments.add(value, fileIndex);
        }
    }

    public void unsetValue(int fileIndex, int offset) {
        this._assignments.remove(fileIndex, offset);
    }

    public boolean hasReferences() {
        return this._referenceCount > 0;
    }

    public OrderedObjectCollection getAssignments() {
        return this._assignments;
    }

    public boolean hasAssignments() {
        return this._assignments.size() > 0;
    }

    public boolean isEnumerable() {
        return (this._attributes & 2) != 2;
    }

    public boolean isInternal() {
        return (this._attributes & 8) == 8;
    }

    public boolean isPermanent() {
        return (this._attributes & 4) == 4;
    }

    public boolean isReadOnly() {
        return (this._attributes & 1) == 1;
    }

    public boolean isVisible() {
        return (this._attributes & 0x10) != 16;
    }

    public Property(IObject value, int fileIndex, int attributes) {
        this._attributes = attributes;
        this.setValue(value, fileIndex);
    }

    public int addReference() {
        return ++this._referenceCount;
    }

    public int removeReference() {
        if (this._referenceCount == 0) {
            throw new IllegalStateException(Messages.Property_RefCountBelowZero);
        }
        return --this._referenceCount;
    }

    public String toString() {
        return this._assignments.toString();
    }

    public IDocumentation getDocumentation() {
        return this._documentation;
    }

    public boolean hasDocumentation() {
        return this._documentation != null;
    }

    public void setDocumentation(IDocumentation documentation) {
        this._documentation = documentation;
    }

    public IDocumentation getAnyValidDocumentation(int sourceFileIndex, int beginOffset) {
        IDocumentation result = null;
        int index = this._assignments.size() - 1;
        while (index > 0) {
            OrderedObject oo = this._assignments.get(index);
            IObject obj = oo.object;
            if (obj.hasDocumentation()) {
                result = obj.getDocumentation();
                if (sourceFileIndex > oo.fileIndex || sourceFileIndex == oo.fileIndex && beginOffset > obj.getStartingOffset()) break;
            }
            --index;
        }
        return result;
    }
}

