/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.jscomment;

import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.colorizer.CategoryColorizer;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.TokenColorizer;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.parsing.IParseState;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.custom.StyleRange;

public class JSCommentColorizer
extends LanguageColorizer {
    private LanguageColorizer jsColorizer;
    private TokenList jsList;
    private IToken multi;
    private IToken single;

    public JSCommentColorizer() {
        super("text/jscomment");
        if (LanguageRegistry.hasLanguageColorizer((String)"text/javascript")) {
            this.jsColorizer = LanguageRegistry.getLanguageColorizer((String)"text/javascript");
            this.jsList = LanguageRegistry.getTokenList((String)"text/javascript");
            if (this.jsList != null) {
                int i = 0;
                while (i < this.jsList.size()) {
                    IToken token = this.jsList.get(i);
                    if (token.getTypeIndex() == 6) {
                        this.multi = token;
                    } else if (token.getTypeIndex() == 2) {
                        this.single = token;
                    }
                    ++i;
                }
            }
        }
    }

    public void createStyle(IParseState parseState, Lexeme lx, Vector styles) {
        CategoryColorizer catColorizer;
        if (this.jsColorizer == null) {
            this.jsColorizer = LanguageRegistry.getLanguageColorizer((String)"text/javascript");
        }
        if (this.jsList == null) {
            this.jsList = LanguageRegistry.getTokenList((String)"text/javascript");
            int i = 0;
            while (i < this.jsList.size()) {
                IToken token = this.jsList.get(i);
                if (token.getTypeIndex() == 6) {
                    this.multi = token;
                } else if (token.getTypeIndex() == 2) {
                    this.single = token;
                }
                ++i;
            }
        }
        if (lx.getToken().getLexerGroup().equals("multiline") || lx.getToken().getTypeIndex() == 1 || lx.getToken().getTypeIndex() == 5) {
            TokenColorizer colorizer = null;
            if (this.multi != null) {
                colorizer = this.jsColorizer.getTokenColorizer(this.multi);
            }
            if (colorizer != null) {
                colorizer.colorize((List)styles, lx.offset, lx.length);
            } else {
                catColorizer = this.jsColorizer.getCategoryColorizer("WHITESPACE");
                ColorizationStyle style = catColorizer.getStyle();
                int bold = style.isBold() ? 1 : 0;
                int italic = style.isItalic() ? 2 : 0;
                StyleRange sr = new StyleRange(lx.offset, lx.length, style.getForegroundColor(), style.getBackgroundColor(), bold | italic);
                sr.underline = style.isUnderline();
                styles.add(sr);
            }
        } else if (lx.getToken().getLexerGroup().equals("singleline") || lx.getToken().getTypeIndex() == 2) {
            TokenColorizer colorizer = null;
            if (this.single != null) {
                colorizer = this.jsColorizer.getTokenColorizer(this.single);
            }
            if (colorizer != null) {
                colorizer.colorize((List)styles, lx.offset, lx.length);
            } else {
                catColorizer = this.jsColorizer.getCategoryColorizer("WHITESPACE");
                ColorizationStyle style = catColorizer.getStyle();
                int bold = style.isBold() ? 1 : 0;
                int italic = style.isItalic() ? 2 : 0;
                StyleRange sr = new StyleRange(lx.offset, lx.length, style.getForegroundColor(), style.getBackgroundColor(), bold | italic);
                sr.underline = style.isUnderline();
                styles.add(sr);
            }
        }
    }
}

